/*
 * $Id: CSVFileQueryDAOTest.java 5576 2007-11-15 13:13:32Z pakucn $
 * 
 * Copyright (c) 2006 NTT DATA Corporation
 * 
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.CSVFileQueryDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> CSVt@CǎpFileLineIteratorNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.CSVFileQueryDAO
 */
public class CSVFileQueryDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(CSVFileQueryDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public CSVFileQueryDAOTest(String name) {
        super(name);
    }

    /**
     * testExecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() fileName:CSVFleQueryDAO01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:FileFormatAme[VX^ugp<br>
     * CSVFileQueryDAO_Stub01<br>
     * () FileQueryDAO.columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     * vf1<br>
     * key:"java.lang.String"<br>
     * value:ColumnParserCX^X<br>
     * CSVFileLineIterator_ColumnParserStub01CX^X<br>
     * <br>
     * <br>
     * ҒlF(߂l) FileLineIterator<T>:CSVFileLineIterator<T>̃CX^X<br>
     * (ԕω) CSVFileLineIterator:1Ă΂B<br>
     * 1FfileName<br>
     * 2Fclazz<br>
     * 3FFileQueryDAO.columnParserMap<br>
     * <br>
     * p^[ <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExecute01() throws Exception {
        // eXgΏۂ̃CX^X
        CSVFileQueryDAO fileQueryDAO = new CSVFileQueryDAO();

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<CSVFileQueryDAO_Stub01> clazz = CSVFileQueryDAO_Stub01.class;

        // O̐ݒ
        Map<String, ColumnParser> columnParser = new HashMap<String, ColumnParser>();
        ColumnParser parser = new CSVFileQueryDAO_ColumnParserStub01();
        columnParser.put("java.lang.String", parser);
        UTUtil.setPrivateField(fileQueryDAO, "columnParserMap", columnParser);

        // eXg{
        FileLineIterator fileLineIterator = fileQueryDAO.execute(fileName,
                clazz);

        // ԋpl̊mF
        assertEquals(CSVFileLineIterator.class, fileLineIterator.getClass());

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(CSVFileLineIterator.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(CSVFileLineIterator.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnParser, arguments.get(2));
    }
}
