/*
 * $Id: AbstractFileLineWriterTest.java 5819 2007-12-20 05:55:47Z fukuyot $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;
import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.annotation.StringConverter;
import jp.terasoluna.fw.file.annotation.StringConverterToLowerCase;
import jp.terasoluna.fw.file.annotation.StringConverterToUpperCase;
import jp.terasoluna.fw.file.annotation.TrimType;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.AbstractFileLineWriter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CANZX(o)̃X[p[NXBۃNX̂߁AAbstractFileLineWriterImplNX쐬Ď{B
 * <p>
 * @author c Ni
 * @author  O
 * @see jp.terasoluna.fw.file.dao.standard.AbstractFileLineWriter
 */
public class AbstractFileLineWriterTest<T> {

    private static final String TEMP_FILE_NAME = AbstractFileLineWriterTest.class
            .getResource("AbstractFileLineWriterTest_tmp.txt").getPath();

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(AbstractFileLineWriterTest.class);
    }

    @Before
    public void setUp() throws Exception {
        VMOUTUtil.initialize();
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
//        file.delete();
        while (!file.delete()) {
            System.gc();
        }
        file.createNewFile();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    /**
     * testAbstractFileLineWriter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>01_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) this.fileName:fileNameƓCX^X<br>
     * (ԕω) this.clazz:clazẑƓCX^X<br>
     * (ԕω) lineFeedChar:"\r"<br>
     * (ԕω) fileEncoding:"UTF-8"<br>
     * (ԕω) columnFormatterMap:columnFormatterMapCX^X<br>
     * (ԕω) O:Ȃ<br>
     * <br>
     * p^[B<br>
     * ɐݒ肳ꂽ@FileFormat̏ɏ]ĐAbstractFileLineWriterCX^X邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter01() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>01_fileName";

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> result = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // (߂l)
        assertNotNull(result);

        assertSame(fileName, UTUtil.getPrivateField(result, "fileName"));

        assertSame(clazz, UTUtil.getPrivateField(result, "clazz"));

        assertEquals("\r", UTUtil.getPrivateField(result, "lineFeedChar"));

        assertEquals("UTF-8", UTUtil.getPrivateField(result, "fileEncoding"));

        assertSame(columnFormatterMap, UTUtil.getPrivateField(result,
                "columnFormatterMap"));
    }

    /**
     * testAbstractFileLineWriter02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:null<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"fileName is required."<br>
     * EOFIllegalArgumentException<br>
     * Et@CFnull<br>
     * <br>
     * OB<br>
     * t@Cݒ肳ĂȂ(null)ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter02() throws Exception {
        // O()
        String fileName = null;

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)

            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("fileName is required.", e.getMessage());

            assertTrue(IllegalArgumentException.class.isAssignableFrom(e
                    .getCause().getClass()));
        }
    }

    /**
     * testAbstractFileLineWriter03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>03_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"FileFormat annotation is not found."<br>
     * EOFIllegalStateException<br>
     * Et@CFfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * clazzɓnꂽNXCX^XɁA@FileFormat̐ݒ肪݂Ȃꍇ́AO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter03() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>03_fileName";

        Class<AbstractFileLineWriter_Stub02> clazz = AbstractFileLineWriter_Stub02.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub02>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("FileFormat annotation is not found.", e.getMessage());

            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));

            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineWriter04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,E <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>04_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF""(󕶎AftHgl)<br>
     * - fileEncodingF""(󕶎AftHgl)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) this.fileName:fileNameƓCX^X<br>
     * (ԕω) this.clazz:clazẑƓCX^X<br>
     * (ԕω) lineFeedChar:VXe̍s؂蕶<br>
     * System.getProperty("line.separator")<br>
     * (ԕω) fileEncoding:VXẽt@CGR[fBO<br>
     * System.getProperty("file.encoding")<br>
     * (ԕω) columnFormatterMap:columnFormatterMapCX^X<br>
     * <br>
     * p^[B<br>
     * clazzɓnꂽNXCX^X́FileFormatɁulineFeedCharvƁufileEncodingv󕶎Őݒ肳ĂꍇAAbstractFileLineWriterNXthis.
     * lineFeddCharthis.fileEncodingVXeftHglŏĐ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter04() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>04_fileName";

        Class<AbstractFileLineWriter_Stub03> clazz = AbstractFileLineWriter_Stub03.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        AbstractFileLineWriter<AbstractFileLineWriter_Stub03> result = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub03>(
                fileName, clazz, columnFormatterMap);
        // (߂l)
        assertNotNull(result);

        assertSame(fileName, UTUtil.getPrivateField(result, "fileName"));

        assertSame(clazz, UTUtil.getPrivateField(result, "clazz"));

        assertEquals(System.getProperty("line.separator"), UTUtil
                .getPrivateField(result, "lineFeedChar"));

        assertEquals(System.getProperty("file.encoding"), UTUtil
                .getPrivateField(result, "fileEncoding"));

        assertSame(columnFormatterMap, UTUtil.getPrivateField(result,
                "columnFormatterMap"));
    }

    /**
     * testAbstractFileLineWriter05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>05_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF";"(encloseCharƓl)<br>
     * - encloseCharF";"(delimiterƓl)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Delimiter is the same as EncloseChar and is no use."<br>
     * EOFIllegalStateException<br>
     * Et@CFfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * clazzɓnꂽNXCX^X@FileFormaɁudelimitervƁuencloseCharvꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter05() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>05_fileName";

        Class<AbstractFileLineWriter_Stub04> clazz = AbstractFileLineWriter_Stub04.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub04>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("Delimiter is the same as EncloseChar and is no use.",
                    e.getMessage());

            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));

            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineWriter06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * ""<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"fileName is required."<br>
     * EOFIllegalArgumentException<br>
     * Et@CF""(󕶎)<br>
     * <br>
     * OB<br>
     * t@C󕶎̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter06() throws Exception {
        // O()
        String fileName = "";

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("fileName is required.", e.getMessage());

            assertTrue(IllegalArgumentException.class.isAssignableFrom(e
                    .getCause().getClass()));
        }
    }

    /**
     * testAbstractFileLineWriter07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>07_fileName"<br>
     * () clazz:null<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"clazz is required."<br>
     * EOFIllegalArgumentException<br>
     * Et@CFfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * clazzunullv̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter07() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>07_fileName";

        Class<AbstractFileLineWriter_Stub01> clazz = null;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("clazz is required.", e.getMessage());

            assertTrue(IllegalArgumentException.class.isAssignableFrom(e
                    .getCause().getClass()));
        }
    }

    /**
     * testAbstractFileLineWriter08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>08_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:null<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"columnFormaterMap is required."<br>
     * EOFIllegalArgumentException<br>
     * Et@CFfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * columnFormatterMapunullv̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter08() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>08_fileName";

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = null;

        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("columnFormatterMap is required.", e.getMessage());

            assertTrue(IllegalArgumentException.class.isAssignableFrom(e
                    .getCause().getClass()));
        }
    }

    /**
     * testAbstractFileLineWriter09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>09_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:vfȂMap<String, ColumnFormatter>CX^X<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"columnFormaterMap is required."<br>
     * EOFIllegalArgumentException<br>
     * Et@CFfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * columnFormatterMap͂邪AMapɗvfꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter09() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>09_fileName";

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();

        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("columnFormatterMap is required.", e.getMessage());

            assertTrue(IllegalArgumentException.class.isAssignableFrom(e
                    .getCause().getClass()));
        }
    }

    /**
     * testAbstractFileLineWriter10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>10_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r\n\t"(ftHglȊOA3ȏ)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"lineFeedChar length must be 1 or 2. but: 3"<br>
     * EOFIllegalStateException<br>
     * Et@CFfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * FileFormatlineFeedChar`3ȏ̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter10() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>10_fileName";

        Class<AbstractFileLineWriter_Stub05> clazz = AbstractFileLineWriter_Stub05.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub05>(
                    fileName, clazz, columnFormatterMap);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("lineFeedChar length must be 1 or 2. but: 3", e
                    .getMessage());

            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
        }
    }

    /**
     * testAbstractFileLineWriter11() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>11_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) this.fileName:fileNameƓCX^X<br>
     * (ԕω) this.clazz:clazẑƓCX^X<br>
     * (ԕω) lineFeedChar:VXe̍s؂蕶<br>
     * System.getProperty("line.separator")<br>
     * (ԕω) fileEncoding:VXẽt@CGR[fBO<br>
     * System.getProperty("file.encoding")<br>
     * (ԕω) columnFormatterMap:columnFormatterMapCX^X<br>
     * (ԕω) O:Ȃ<br>
     * <br>
     * p^[B<br>
     * ɐݒ肳ꂽ@FileFormat̏񂪃ftHg܂܂̏ꍇAAbstractFileLineWriterCX^XȂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter11() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>11_fileName";

        Class<AbstractFileLineWriter_Stub08> clazz = AbstractFileLineWriter_Stub08.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        AbstractFileLineWriter<AbstractFileLineWriter_Stub08> result = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub08>(
                fileName, clazz, columnFormatterMap);

        // (߂l)
        assertNotNull(result);

        assertSame(fileName, UTUtil.getPrivateField(result, "fileName"));

        assertSame(clazz, UTUtil.getPrivateField(result, "clazz"));

        assertEquals(System.getProperty("line.separator"), UTUtil
                .getPrivateField(result, "lineFeedChar"));

        assertEquals(System.getProperty("file.encoding"), UTUtil
                .getPrivateField(result, "fileEncoding"));

        assertSame(columnFormatterMap, UTUtil.getPrivateField(result,
                "columnFormatterMap"));
    }

    /**
     * testAbstractFileLineWriter12() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>13_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * <br>
     * ȉeNX̒`<br>
     * E@FileFormat̐ݒȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) this.fileName:fileNameƓCX^X<br>
     * (ԕω) this.clazz:clazẑƓCX^X<br>
     * (ԕω) lineFeedChar:VXe̍s؂蕶<br>
     * System.getProperty("line.separator")<br>
     * (ԕω) fileEncoding:VXẽt@CGR[fBO<br>
     * System.getProperty("file.encoding")<br>
     * (ԕω) columnFormatterMap:columnFormatterMapCX^X<br>
     * (ԕω) O:Ȃ<br>
     * <br>
     * p^[B<br>
     * clazzFileFormatȂNXpĂꍇAݒ肳ꂽ@FileFormat̏ɏ]AbstractFileLineWriterCX^X邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter12() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>12_fileName";

        Class<AbstractFileLineWriter_Stub38> clazz = AbstractFileLineWriter_Stub38.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        AbstractFileLineWriter<AbstractFileLineWriter_Stub38> result = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub38>(
                fileName, clazz, columnFormatterMap);

        // (߂l)
        assertNotNull(result);

        assertSame(fileName, UTUtil.getPrivateField(result, "fileName"));

        assertSame(clazz, UTUtil.getPrivateField(result, "clazz"));

        assertEquals(System.getProperty("line.separator"), UTUtil
                .getPrivateField(result, "lineFeedChar"));

        assertEquals(System.getProperty("file.encoding"), UTUtil
                .getPrivateField(result, "fileEncoding"));

        assertSame(columnFormatterMap, UTUtil.getPrivateField(result,
                "columnFormatterMap"));
    }

    /**
     * testAbstractFileLineWriter13() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineWriter_<init>12_fileName"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * <br>
     * ȉeNX̒`<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHglȊO<br>
     * EtB[hĂȂ<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) this.fileName:fileNameƓCX^X<br>
     * (ԕω) this.clazz:clazẑƓCX^X<br>
     * (ԕω) lineFeedChar:VXe̍s؂蕶<br>
     * System.getProperty("line.separator")<br>
     * (ԕω) fileEncoding:VXẽt@CGR[fBO<br>
     * System.getProperty("file.encoding")<br>
     * (ԕω) columnFormatterMap:columnFormatterMapCX^X<br>
     * (ԕω) O:Ȃ<br>
     * <br>
     * p^[B<br>
     * clazzFileFormatNXpĂꍇAeNXł͂Ȃclazzɐݒ肳ꂽ@FileFormat̏ɏ]AbstractFileLineWriterCX^X邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testAbstractFileLineWriter13() throws Exception {
        // O()
        String fileName = "AbstractFileLineWriter_<init>13_fileName";

        Class<AbstractFileLineWriter_Stub39> clazz = AbstractFileLineWriter_Stub39.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        AbstractFileLineWriter<AbstractFileLineWriter_Stub39> result = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub39>(
                fileName, clazz, columnFormatterMap);

        // (߂l)
        assertNotNull(result);

        assertSame(fileName, UTUtil.getPrivateField(result, "fileName"));

        assertSame(clazz, UTUtil.getPrivateField(result, "clazz"));

        assertEquals(System.getProperty("line.separator"), UTUtil
                .getPrivateField(result, "lineFeedChar"));

        assertEquals(System.getProperty("file.encoding"), UTUtil
                .getPrivateField(result, "fileEncoding"));

        assertSame(columnFormatterMap, UTUtil.getPrivateField(result,
                "columnFormatterMap"));
    }

    /**
     * testInit01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "File_1Line.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () this.calledInit:true<br>
     * () this.fileEncoding:clazz@FileFormat̐ݒɏ]B<br>
     * () this.writer:ȉ̐ݒBufferedWriterCX^X<br>
     * Enew BufferedWriter(<br>
     * new OutputStreamWriter(<br>
     * (new FileOutputStream(fileName, true)),<br>
     * fileEncoding))<br>
     * <br>
     * Writer̐\͕GȂߊmFB<br>
     * DJUnitŌďömF邱ƂɂB<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "File_1Line.txt"<br>
     * E1sf[^<br>
     * <br>
     * ҒlF(ԕω) this.writer:ȉ̐ݒBufferedWriterCX^X<br>
     * Enew BufferedWriter(<br>
     * new OutputStreamWriter(<br>
     * (new FileOutputStream(fileName, true)),<br>
     * fileEncoding))<br>
     * <br>
     * ωȂ<br>
     * (ԕω) #buildFields():Ă΂Ȃ<br>
     * (ԕω) #buildStringConverters():Ă΂Ȃ<br>
     * (ԕω) #buildMethods():Ă΂Ȃ<br>
     * (ԕω) file#delete():Ă΂Ȃ<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "File_1Line.txt"<br>
     * E1sf[^<br>
     * <br>
     * ωȂ<br>
     * <br>
     * p^[<br>
     * init()sĂꍇ́AsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testInit01() throws Exception {
        // O()
        String fileName = TEMP_FILE_NAME;

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O(Ώ)
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        BufferedWriter writer = null;
        BufferedReader postReader = null;
        try {
            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "calledInit", Boolean.TRUE);

            writer = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(fileName, true), "UTF-8"));

            UTUtil.setPrivateField(fileLineWriter, "writer", writer);

            // O(\bh)
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter_Stub01.class,
                    "buildFields", 0, null);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter_Stub01.class,
                    "buildStringConverts", 0, null);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter_Stub01.class,
                    "buildMethods", 0, null);

            // eXg{
            fileLineWriter.init();

            // (tB[h)
            assertSame(writer, UTUtil.getPrivateField(fileLineWriter, "writer"));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "buildFields"));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "buildStringConverts"));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "buildMethods"));

            assertFalse(VMOUTUtil.isCalled(File.class, "delete"));

            // (t@C)
            assertTrue(new File(fileName).exists());

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), "UTF-8"));
        } finally {
            if (writer != null) {
                writer.close();
            }
            if (postReader != null) {
                postReader.close();
            }
        }
    }

    /**
     * testInit02() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "File_1Line.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () this.calledInit:false<br>
     * () this.fileEncoding:clazz@FileFormat̐ݒɏ]B<br>
     * () this.writer:null<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "File_1Line.txt"<br>
     * E1sf[^<br>
     * <br>
     * ҒlF(ԕω) this.writer:ȉ̐ݒBufferedWriterCX^X<br>
     * Enew BufferedWriter(<br>
     * new OutputStreamWriter(<br>
     * (new FileOutputStream(fileName, true)),<br>
     * fileEncoding))<br>
     * <br>
     * Writer̐\͕GȂߊmFB<br>
     * DJUnitŌďömF邱ƂɂB<br>
     * (ԕω) #buildFields():1Ă΂<br>
     * (ԕω) #buildStringConverters():1Ă΂<br>
     * (ԕω) #buildMethods():1Ă΂<br>
     * (ԕω) file#delete():1Ă΂<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "File_1Line.txt"<br>
     * Ef[^Ȃ<br>
     * <br>
     * p^[B<br>
     * (overWriteFlgݒFTrue)<br>
     * t@CsIuWFNgɑ΂init()s邱ƂmFB<br>
     * ܂AݑΏۃt@C̏񂪍폜Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testInit02() throws Exception {
        // O()
        String fileName = TEMP_FILE_NAME;

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O(Ώ)
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "calledInit", Boolean.FALSE);

        UTUtil.setPrivateField(fileLineWriter, "writer", null);

        BufferedReader postReader = null;
        try {
            // eXg{
            fileLineWriter.init();

            // (tB[h)
            assertNotNull(UTUtil.getPrivateField(fileLineWriter, "writer"));
            assertEquals(1, VMOUTUtil.getCallCount(BufferedWriter.class,
                    "<init>"));
            List bufferedWriterInitArguments = VMOUTUtil.getArguments(
                    BufferedWriter.class, "<init>", 0);
            assertEquals(1, bufferedWriterInitArguments.size());
            assertTrue(OutputStreamWriter.class
                    .isAssignableFrom(bufferedWriterInitArguments.get(0)
                            .getClass()));
            assertEquals(1, VMOUTUtil.getCallCount(OutputStreamWriter.class,
                    "<init>"));
            List outputStreamWriterInitArguments = VMOUTUtil.getArguments(
                    OutputStreamWriter.class, "<init>", 0);
            assertEquals(2, outputStreamWriterInitArguments.size());
            assertTrue(FileOutputStream.class
                    .isAssignableFrom(outputStreamWriterInitArguments.get(0)
                            .getClass()));
            assertEquals("UTF-8", outputStreamWriterInitArguments.get(1));
            assertEquals(1, VMOUTUtil.getCallCount(FileOutputStream.class,
                    "<init>"));
            List fileOutputStreamInitArguments = VMOUTUtil.getArguments(
                    FileOutputStream.class, "<init>", 0);
            assertEquals(2, fileOutputStreamInitArguments.size());
            assertEquals(fileName, fileOutputStreamInitArguments.get(0));
            assertTrue(Boolean.class.cast(fileOutputStreamInitArguments.get(1)));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildFields"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildStringConverters"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildMethods"));

            assertEquals(1, VMOUTUtil.getCallCount(File.class, "delete"));

            // (t@C)
            assertTrue(new File(fileName).exists());

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), "UTF-8"));
            assertFalse(postReader.ready());

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }
        }
    }

    /**
     * testInit03() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testInit03.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFfalse(ftHgl)<br>
     * EtB[hĂȂ<br>
     * () this.calledInit:false<br>
     * () this.fileEncoding:clazz@FileFormat̐ݒɏ]B<br>
     * () this.writer:null<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testInit03.txt"<br>
     * E1sf[^<br>
     * <br>
     * ҒlF(ԕω) this.writer:ȉ̐ݒBufferedWriterCX^X<br>
     * Enew BufferedWriter(<br>
     * new OutputStreamWriter(<br>
     * (new FileOutputStream(fileName, true)),<br>
     * fileEncoding))<br>
     * <br>
     * Writer̐\͕GȂߊmFB<br>
     * DJUnitŌďömF邱ƂɂB<br>
     * (ԕω) #buildFields():1Ă΂<br>
     * (ԕω) #buildStringConverters():1Ă΂<br>
     * (ԕω) #buildMethods():1Ă΂<br>
     * (ԕω) file#delete():Ă΂Ȃ<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testInit03.txt"<br>
     * E1sf[^<br>
     * <br>
     * ωȂ<br>
     * <br>
     * p^[B<br>
     * (overWriteFlgݒFfalse(ftHgl))<br>
     * t@CsIuWFNgɑ΂init()s邱ƂmFB<br>
     * ܂AݑΏۃt@C̏񂪍폜ȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testInit03() throws Exception {
        // O()
        String fileName = TEMP_FILE_NAME;

        Class<AbstractFileLineWriter_Stub06> clazz = AbstractFileLineWriter_Stub06.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O(Ώ)
        AbstractFileLineWriter<AbstractFileLineWriter_Stub06> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub06>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "calledInit", Boolean.FALSE);

        UTUtil.setPrivateField(fileLineWriter, "writer", null);

        BufferedReader postReader = null;
        try {
            // eXg{
            fileLineWriter.init();

            // (tB[h)
            assertNotNull(UTUtil.getPrivateField(fileLineWriter, "writer"));
            assertEquals(1, VMOUTUtil.getCallCount(BufferedWriter.class,
                    "<init>"));
            List bufferedWriterInitArguments = VMOUTUtil.getArguments(
                    BufferedWriter.class, "<init>", 0);
            assertEquals(1, bufferedWriterInitArguments.size());
            assertTrue(OutputStreamWriter.class
                    .isAssignableFrom(bufferedWriterInitArguments.get(0)
                            .getClass()));
            assertEquals(1, VMOUTUtil.getCallCount(OutputStreamWriter.class,
                    "<init>"));
            List outputStreamWriterInitArguments = VMOUTUtil.getArguments(
                    OutputStreamWriter.class, "<init>", 0);
            assertEquals(2, outputStreamWriterInitArguments.size());
            assertTrue(FileOutputStream.class
                    .isAssignableFrom(outputStreamWriterInitArguments.get(0)
                            .getClass()));
            assertEquals("UTF-8", outputStreamWriterInitArguments.get(1));
            assertEquals(1, VMOUTUtil.getCallCount(FileOutputStream.class,
                    "<init>"));
            List fileOutputStreamInitArguments = VMOUTUtil.getArguments(
                    FileOutputStream.class, "<init>", 0);
            assertEquals(2, fileOutputStreamInitArguments.size());
            assertEquals(fileName, fileOutputStreamInitArguments.get(0));
            assertTrue(Boolean.class.cast(fileOutputStreamInitArguments.get(1)));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildFields"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildStringConverters"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildMethods"));

            assertFalse(VMOUTUtil.isCalled(File.class, "delete"));

            // (t@C)
            assertTrue(new File(fileName).exists());

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), "UTF-8"));

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }
        }
    }

    /**
     * testInit04() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testInit04.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-X"(݂ȂGR[fBO)<br>
     * - overWriteFlgFtrue(ftHglȊO)<br>
     * EtB[hĂȂ<br>
     * () this.calledInit:false<br>
     * () this.fileEncoding:clazz@FileFormat̐ݒɏ]B<br>
     * () this.writer:null<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testInit04.txt"<br>
     * E1sf[^<br>
     * <br>
     * ҒlF(ԕω) #buildFields():1Ă΂<br>
     * (ԕω) #buildStringConverters():1Ă΂<br>
     * (ԕω) #buildMethods():1Ă΂<br>
     * (ԕω) file#delete():Ă΂Ȃ<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testInit03.txt"<br>
     * E1sf[^<br>
     * <br>
     * ωȂ<br>
     * (ԕω) -:ȉ̏FileExceptionB<br>
     * EbZ[WF"Failed in generation of writer."<br>
     * EOFUnsupportedEncodingException<br>
     * EfileNameFfileNameƓCX^XB<br>
     * <br>
     * ُp^[B<br>
     * ݂ȂGR[fBOݒ肳ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testInit04() throws Exception {
        // O()
        String fileName = TEMP_FILE_NAME;

        Class<AbstractFileLineWriter_Stub07> clazz = AbstractFileLineWriter_Stub07.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O(Ώ)
        AbstractFileLineWriter<AbstractFileLineWriter_Stub07> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub07>(
                fileName, clazz, columnFormatterMap);
        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "calledInit", Boolean.FALSE);

        UTUtil.setPrivateField(fileLineWriter, "writer", null);

        BufferedReader postReader = null;
        try {
            // eXg{
            fileLineWriter.init();
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Failed in generation of writer.", e.getMessage());
            assertTrue(UnsupportedEncodingException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildFields"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildStringConverters"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildMethods"));

            assertFalse(VMOUTUtil.isCalled(File.class, "delete"));

            // (t@C)
            assertTrue(new File(fileName).exists());

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), "UTF-8"));

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }
        }
    }

    /**
     * testInit05() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * ".txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF"|"(ftHglȊO)<br>
     * - encloseCharF"\""(ftHglȊO)<br>
     * - lineFeedCharF"\r"(ftHglȊO)<br>
     * - fileEncodingF"UTF-8"(ftHglȊO)<br>
     * - overWriteFlgFfalse(ftHgl)<br>
     * EtB[hĂȂ<br>
     * () this.calledInit:false<br>
     * () this.fileEncoding:clazz@FileFormat̐ݒɏ]B<br>
     * () this.writer:null<br>
     * () t@C:NXpXɈȉ̃t@CсAfBNg݂͑ȂB<br>
     * "dummy/.txt"<br>
     * <br>
     * ҒlF(ԕω) #buildFields():1Ă΂<br>
     * (ԕω) #buildStringConverters():1Ă΂<br>
     * (ԕω) #buildMethods():1Ă΂<br>
     * (ԕω) file#delete():Ă΂Ȃ<br>
     * (ԕω) t@C:NXpXɈȉ̃t@CсAfBNg݂͑ȂB<br>
     * "dummy/.txt"<br>
     * (ԕω) -:ȉ̏FileExceptionB<br>
     * EbZ[WF"Failed in generation of writer."<br>
     * EOFFileNotFoundException<br>
     * EfileNameFfileNameƓCX^XB<br>
     * <br>
     * ُp^[B<br>
     * ݂Ȃt@Cݒ肳ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testInit05() throws Exception {
        // O()
        URL url = this.getClass().getResource("File_Empty.txt");

        String fileName = url.getPath().substring(0,
                url.getPath().indexOf("File_Empty.txt"))
                + "dummy/AbstractFileLineWriter_testInit05.txt";

        Class<AbstractFileLineWriter_Stub06> clazz = AbstractFileLineWriter_Stub06.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O(Ώ)
        AbstractFileLineWriter<AbstractFileLineWriter_Stub06> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub06>(
                fileName, clazz, columnFormatterMap);
        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "calledInit", Boolean.FALSE);

        UTUtil.setPrivateField(fileLineWriter, "writer", null);

        try {
            // eXg{
            fileLineWriter.init();
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Failed in generation of writer.", e.getMessage());
            assertTrue(FileNotFoundException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildFields"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildStringConverters"));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "buildMethods"));

            assertFalse(VMOUTUtil.isCalled(File.class, "delete"));

            // (t@C)
            assertFalse(new File(fileName).exists());
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }
        }
    }

    /**
     * testBuildFields01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields01.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * () this.filelds:null<br>
     * () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) this.fields:vfȂFieldz<br>
     * <br>
     * P[X<br>
     * (eNXAtB[h`Ȃ)<br>
     * t@CsIuWFNgNX(eNX܂)ɃtB[h`ȂꍇAfieldsvfȂzŏ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub38> clazz = AbstractFileLineWriter_Stub38.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub38> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub38>(
                fileName, clazz, columnFormatterMap);

        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(0, resultFields.length);
    }

    /**
     * testBuildFields02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields02.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * () this.filelds:null<br>
     * () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF (ԕω) this.fields:vfȂFieldz<br>
     * <br>
     * P[X<br>
     * (eNXȂAtB[h`F1)<br>
     * (@OutputFileColumnݒȂF1)<br>
     * t@CsIuWFNgNXɃtB[h`ꍇAfields邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields02() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub09> clazz = AbstractFileLineWriter_Stub09.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub09> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub09>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(0, resultFields.length);
    }

    /**
     * testBuildFields03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields03.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) this.fields:ȉ̗vfFieldz<br>
     *                         PDFieldIuWFNgFcolumn1<br>
     * <br>
     *                         P[X<br>
     *                         (eNXȂAtB[h`F1)<br>
     *                         (@OutputFileColumnݒ肠F1)<br>
     *                         t@CsIuWFNgNXɃtB[h`ꍇAfields邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields03() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(1, resultFields.length);
        Field resultFields1 = resultFields[0];
        assertEquals("column1", resultFields1.getName());
    }

    /**
     * testBuildFields04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields04.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * - tB[hFString noMappingColumn3<br>
     * () this.filelds:null<br>
     * () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"int"=IntColumnFormatter<br>
     * E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     * ҒlF(ԕω) this.fields:vfȂFieldz<br>
     * <br>
     * P[X<br>
     * (eNXȂAtB[h`F3)<br>
     * (@OutputFileColumnݒȂF3)<br>
     * t@CsIuWFNgNXɃtB[h`ꍇAfields邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields04() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub11> clazz = AbstractFileLineWriter_Stub11.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub11> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub11>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(0, resultFields.length);
    }

    /**
     * testBuildFields05() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields05.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) this.fields:ȉ̗vfFieldz<br>
     *                         PDFieldIuWFNgFcolumn1<br>
     * <br>
     *                         P[X<br>
     *                         (eNXȂAtB[h`F3)<br>
     *                         (@OutputFileColumnݒȂF2)<br>
     *                         (@OutputFileColumnݒ肠F1)<br>
     *                         t@CsIuWFNgNXɃtB[h`ꍇAfieldArrayfields邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields05() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub12> clazz = AbstractFileLineWriter_Stub12.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub12> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub12>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(1, resultFields.length);
        Field resultFields1 = resultFields[0];
        assertNotNull(resultFields1);
        assertEquals("column1", resultFields1.getName());
    }

    /**
     * testBuildFields06() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields06.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) this.fields:ȉ̗vfFieldz<br>
     *                         PDFieldIuWFNgFcolumn1<br>
     *                         QDFieldIuWFNgFcolumn2<br>
     *                         RDFieldIuWFNgFcolumn3<br>
     * <br>
     *                         P[X<br>
     *                         (eNXȂAtB[h`F3)<br>
     *                         (@OutputFileColumnݒ肠F3)<br>
     *                         t@CsIuWFNgNXɃtB[h`ꍇAfields邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields06() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub13> clazz = AbstractFileLineWriter_Stub13.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub13> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub13>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(3, resultFields.length);
        Field resultFieldsArray1 = resultFields[0];
        assertNotNull(resultFieldsArray1);
        assertEquals("column1", resultFieldsArray1.getName());
        Field resultFieldsArray2 = resultFields[1];
        assertNotNull(resultFieldsArray2);
        assertEquals("column2", resultFieldsArray2.getName());
        Field resultFieldsArray3 = resultFields[2];
        assertNotNull(resultFieldsArray3);
        assertEquals("column3", resultFieldsArray3.getName());
    }

    /**
     * testBuildFields07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields07.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         columnIndexdĂB<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) O:ȉ̐ݒFileException<br>
     *                         bZ[WF"Column Index is duplicate : 1"<br>
     *                         EfileNameFthis.fileNameƓCX^XB<br>
     * <br>
     *                         ُP[X<br>
     *                         (eNXȂAtB[h`F3)<br>
     *                         (@OutputFileColumnݒ肠F3)<br>
     *                         t@CsIuWFNgNXɃtB[h`columnIndexdꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields07() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub14> clazz = AbstractFileLineWriter_Stub14.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub14> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub14>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineWriter, "buildFields");
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));

            assertEquals("Column Index is duplicate : 1", e.getMessage());

            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testBuildFields08() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields08.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         etB[h̏Ԃ͋tiԂł͂ȂĵƁB<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω)this.fields:ȉ̗vfFieldz<br>
     *                         PDFieldIuWFNgFcolumn1<br>
     *                         QDFieldIuWFNgFcolumn2<br>
     *                         RDFieldIuWFNgFcolumn3<br>
     * <br>
     *                         P[X<br>
     *                         (eNXȂAtB[h`F3)<br>
     *                         (@OutputFileColumnݒ肠F3)<br>
     *                         t@CsIuWFNgNXɃtB[h`ꍇAfields邱ƂmFB<br>
     *                         ܂Afield̒`Ԃł͂ȂcolumnIndexԂɊi[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields08() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub15> clazz = AbstractFileLineWriter_Stub15.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub15> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub15>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(3, resultFields.length);
        Field resultFieldsArray1 = resultFields[0];
        assertNotNull(resultFieldsArray1);
        assertEquals("column1", resultFieldsArray1.getName());
        Field resultFieldsArray2 = resultFields[1];
        assertNotNull(resultFieldsArray2);
        assertEquals("column2", resultFieldsArray2.getName());
        Field resultFieldsArray3 = resultFields[2];
        assertNotNull(resultFieldsArray3);
        assertEquals("column3", resultFieldsArray3.getName());

    }

    /**
     * testBuildFields09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields09.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) O:ȉ̐ݒFileException<br>
     *                         bZ[WF"Column Index in FileLineObject is bigger than the total number of the field."<br>
     *                         EOFIllegalStateException<br>
     *                         EfileNameFthis.fileNameƓCX^XB<br>
     * <br>
     *                         ُP[X<br>
     *                         (eNXȂAtB[h`F1)<br>
     *                         (@OutputFileColumnݒ肠F1)<br>
     *                         t@CsIuWFNgNXɃtB[h`columnIndextB[h̐ȏݒ肵ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields09() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub16> clazz = AbstractFileLineWriter_Stub16.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub16> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub16>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineWriter, "buildFields");
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals("Column Index in FileLineObject is bigger than the "
                    + "total number of the field.", e.getMessage());
            assertEquals(fileName, e.getFileName());

            // (ԕωAtB[h)
            Field[] resultFields = (Field[]) UTUtil.getPrivateField(
                    fileLineWriter, "fields");
            assertNull(resultFields);
        }
    }

    /**
     * testBuildFields10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields10.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF-1<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) O:ȉ̐ݒFileException<br>
     *                         bZ[WF"Column Index in FileLineObject is the minus number."<br>
     *                         EOFIllegalStateException<br>
     *                         EfileNameFthis.fileNameƓCX^XB<br>
     * <br>
     *                         ُP[X<br>
     *                         (eNXȂAtB[h`F1)<br>
     *                         (@OutputFileColumnݒ肠F1)<br>
     *                         t@CsIuWFNgNXɃtB[h`columnIndex}CiXlݒ肵ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields10() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub17> clazz = AbstractFileLineWriter_Stub17.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub17> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub17>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineWriter, "buildFields");
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals("Column Index in FileLineObject is the minus number.",
                    e.getMessage());
            assertEquals(fileName, e.getFileName());

            // (ԕωAtB[h)
            Field[] resultFields = (Field[]) UTUtil.getPrivateField(
                    fileLineWriter, "fields");
            assertNull(resultFields);
        }
    }

    /**
     * testBuildFields11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields11.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * - tB[hFString noMappingColumn3<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     * <br>
     *                         columnIndexɌԂB<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) O:ȉ̐ݒFileException<br>
     *                         bZ[WF"columnIndex in FileLineObject is not sequential order."<br>
     *                         EOFIllegalStateException<br>
     *                         EfileNameFthis.fileNameƓCX^XB<br>
     * <br>
     *                         ُP[X<br>
     *                         (eNXȂAtB[h`F5)<br>
     *                         (@OutputFileColumnݒȂF3)<br>
     *                         (@OutputFileColumnݒ肠F2)<br>
     *                         t@CsIuWFNgNXɃtB[h`columnIndex̒`ŌԂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields11() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub18> clazz = AbstractFileLineWriter_Stub18.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub18> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub18>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineWriter, "buildFields");
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals(
                    "columnIndex in FileLineObject is not sequential order.", e
                            .getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
        }
    }

    /**
     * testBuildFields12() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields12.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     * <br>
     *                         ȉeNX̒`<br>
     *                         E@OutputFileColumnݒ肠̃tB[h<br>
     *                         - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     * <br>
     *                         eNXɃtB[h̏񂪂B<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) this.fields:ȉ̗vfFieldz<br>
     *                         PDFieldIuWFNgFcolumn1<br>
     *                         QDFieldIuWFNgFcolumn2<br>
     *                         RDFieldIuWFNgFcolumn3<br>
     * <br>
     *                         P[X<br>
     *                         (eNXAtB[h`F5)<br>
     *                         (@OutputFileColumnݒȂF2)<br>
     *                         (@OutputFileColumnݒ肠F3(eNX1))<br>
     *                         t@CsIuWFNgNXɃtB[h`鐳ĂꍇAfields邱ƂmFB<br>
     *                         eNX̃tB[h̒`F邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields12() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub19> clazz = AbstractFileLineWriter_Stub19.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub19> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub19>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // (ԕωAtB[h)
        Field[] resultFields = (Field[]) UTUtil.getPrivateField(fileLineWriter,
                "fields");
        assertEquals(3, resultFields.length);
        Field resultFields1 = resultFields[0];
        assertNotNull(resultFields1);
        assertEquals("column1", resultFields1.getName());
        Field resultFields2 = resultFields[1];
        assertNotNull(resultFields2);
        assertEquals("column2", resultFields2.getName());
        Field resultFields3 = resultFields[2];
        assertNotNull(resultFields3);
        assertEquals("column3", resultFields3.getName());
    }

    /**
     * testBuildFields13() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FB,G <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildFields15.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFlong column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         T|[gȂ^CṽtB[hB<br>
     *                         () this.filelds:null<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     * <br>
     *                         ҒlF(ԕω) this.fields:null<br>
     *                         (ԕω) O:ȉ̐ݒFileException<br>
     *                         bZ[WF"There is a type which isn't supported in a mapping target field in FileLineObject."<br>
     *                         EOFIllegalStateException<br>
     *                         EfileNameFthis.fileNameƓCX^XB<br>
     * <br>
     *                         ُP[X<br>
     *                         (eNXȂAtB[h`F3)<br>
     *                         (@OutputFileColumnݒ肠F3)<br>
     *                         t@CsIuWFNgNX̃tB[h^this.columnFormatterrMapɑ݂Ȃ^̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testBuildFields13() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub40> clazz = AbstractFileLineWriter_Stub40.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub40> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub40>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineWriter, "buildFields");
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals("There is a type which isn't supported in a mapping "
                    + "target field in FileLineObject.", e.getMessage());
            assertEquals(fileName, e.getFileName());

            // (ԕωAtB[h)
            Field[] resultFields = (Field[]) UTUtil.getPrivateField(
                    fileLineWriter, "fields");
            assertNull(resultFields);
        }
    }

    /**
     * testBuildStringConverters01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildStringConverters01.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * () this.stringConverterCacheMap:vfȂMapCX^X<br>
     * <br>
     * ҒlF(ԕω) this.stringConverterCacheMap:vfȂMapCX^X<br>
     * (ԕω) this.stringConverters:vfȂStringConverterz<br>
     * <br>
     * P[X<br>
     * t@CsIuWFNgNXtB[hȂꍇAstringConvetersz񂪋ŏ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @SuppressWarnings("unchecked")
    @Test
    public void testBuildStringConverters01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub08> clazz = AbstractFileLineWriter_Stub08.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub08> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub08>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // O(tB[h)
        Map<Class, StringConverter> preStringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(AbstractFileLineWriter.class,
                "stringConverterCacheMap", preStringConverterCacheMap);

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

            // (ԕωAtB[h)
            Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverterCacheMap");
            assertNotNull(stringConverterCacheMap);
            assertEquals(0, stringConverterCacheMap.size());

            StringConverter[] stringConverters = (StringConverter[]) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverters");
            assertNotNull(stringConverters);
            assertEquals(0, stringConverters.length);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildStringConverters02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildStringConverters02.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > StringConverter.classFNullStringConverter.class<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.stringConverterCacheMap:vfȂMapCX^X<br>
     * <br>
     *                         ҒlF(ԕω) this.stringConverterCacheMap:ȉ̗vfMapCX^X<br>
     *                         EkeyFNullStringConverter.class,<br>
     *                         valueFNullStringConverterCX^X<br>
     *                         (ԕω) this.stringConverters:ȉ̗vfStringConverterz<br>
     *                         1DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     * <br>
     *                         P[X<br>
     *                         (stringConverterݒ肠tB[hF1)<br>
     *                         t@CsIuWFNgNX̃tB[hstringConverterݒ肪ꍇAstringConvertersz񂪐邱ƂƁÃCX^XLbV邱ƂmF
     *                         B <br>
     * @throws Exception ̃\bhŔO
     */

    @SuppressWarnings("unchecked")
    @Test
    public void testBuildStringConverters02() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub20> clazz = AbstractFileLineWriter_Stub20.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub20> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub20>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // O(tB[h)
        Map<Class, StringConverter> preStringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(AbstractFileLineWriter.class,
                "stringConverterCacheMap", preStringConverterCacheMap);

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

            // (ԕωAtB[h)
            Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverterCacheMap");
            assertNotNull(stringConverterCacheMap);
            assertEquals(1, stringConverterCacheMap.size());
            assertTrue(stringConverterCacheMap
                    .containsKey(NullStringConverter.class));
            StringConverter nullStringConverter = stringConverterCacheMap
                    .get(NullStringConverter.class);
            assertNotNull(nullStringConverter);
            assertTrue(NullStringConverter.class
                    .isAssignableFrom(nullStringConverter.getClass()));

            StringConverter[] stringConverters = (StringConverter[]) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverters");
            assertNotNull(stringConverters);
            assertEquals(1, stringConverters.length);
            StringConverter stringConverters1 = stringConverters[0];
            assertSame(nullStringConverter, stringConverters1);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildStringConverters03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildStringConverters03.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > StringConverter.classFNullStringConverter.class<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > StringConverter.classFNullStringConverter.class<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > StringConverter.classFNullStringConverter.class<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.stringConverterCacheMap:vfȂMapCX^X<br>
     * <br>
     *                         ҒlF(ԕω) this.stringConverterCacheMap:ȉ̗vfMapCX^X<br>
     *                         EkeyFNullStringConverter.class,<br>
     *                         valueFNullStringConverterCX^X<br>
     *                         (ԕω) this.stringConverters:ȉ̗vfStringConverterz<br>
     *                         1DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         2DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         3DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     * <br>
     *                         P[X<br>
     *                         (stringConverterݒ肠tB[hF3A<br>
     *                         stringConverter𗘗pB)<br>
     *                         stringConverterݒ肪ꍇAstringConvertersz񂪐邱ƂƁÃCX^XLbV邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @SuppressWarnings("unchecked")
    @Test
    public void testBuildStringConverters03() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub21> clazz = AbstractFileLineWriter_Stub21.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub21> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub21>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // O(tB[h)
        Map<Class, StringConverter> preStringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(AbstractFileLineWriter.class,
                "stringConverterCacheMap", preStringConverterCacheMap);

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

            // (ԕωAtB[h)
            Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverterCacheMap");
            assertNotNull(stringConverterCacheMap);
            assertEquals(1, stringConverterCacheMap.size());
            assertTrue(stringConverterCacheMap
                    .containsKey(NullStringConverter.class));
            StringConverter nullStringConverter = stringConverterCacheMap
                    .get(NullStringConverter.class);
            assertNotNull(nullStringConverter);
            assertTrue(NullStringConverter.class
                    .isAssignableFrom(nullStringConverter.getClass()));

            StringConverter[] stringConverters = (StringConverter[]) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverters");
            assertNotNull(stringConverters);
            assertEquals(3, stringConverters.length);
            StringConverter stringConverters1 = stringConverters[0];
            assertNotNull(stringConverters1);
            assertSame(nullStringConverter, stringConverters1);
            StringConverter stringConverters2 = stringConverters[1];
            assertNotNull(stringConverters2);
            assertSame(nullStringConverter, stringConverters2);
            StringConverter stringConverters3 = stringConverters[2];
            assertNotNull(stringConverters3);
            assertSame(nullStringConverter, stringConverters3);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildStringConverters04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildStringConverters04.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > stringConverterFNullStringConverter.class<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > stringConverterFSringConverterToLowerCase.class<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > stringConverterFSringConverterToUpperCase.class<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column4<br>
     * @OutputFileColumnݒ<br> > columnIndexF3<br>
     *                         > stringConverterFNullStringConverter.class<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column5<br>
     * @OutputFileColumnݒ<br> > columnIndexF4<br>
     *                         > stringConverterFSringConverterToLowerCase.class<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column6<br>
     * @OutputFileColumnݒ<br> > columnIndexF5<br>
     *                         > stringConverterFSringConverterToUpperCase.class<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.stringConverterCacheMap:vfȂMapCX^X<br>
     * <br>
     *                         ҒlF(ԕω) this.stringConverterCacheMap:ȉ̗vfMapCX^X<br>
     *                         EkeyFNullStringConverter.class,<br>
     *                         valueFNullStringConverterCX^X<br>
     *                         EkeyFSringConverterToLowerCase.class,<br>
     *                         valueFSringConverterToLowerCaseCX^X<br>
     *                         EkeyFSringConverterToUpperCase.class,<br>
     *                         valueFSringConverterToUpperCaseCX^X<br>
     *                         (ԕω) this.stringConverters:ȉ̗vfStringConverterz<br>
     *                         1DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         2DSringConverterToLowerCaseCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         3DSringConverterToUpperCaseCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         4DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         5DSringConverterToLowerCaseCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         6DSringConverterToUpperCaseCX^X(LbVꂽ̂ƓCX^X)<br>
     * <br>
     *                         P[X<br>
     *                         (stringConverterݒ肠tB[hF5A<br>
     *                         stringConverter𗘗pB)<br>
     *                         stringConverterݒ肪ꍇAstringConvertersz񂪐邱ƂƁÃCX^XLbV邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @SuppressWarnings("unchecked")
    @Test
    public void testBuildStringConverters04() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub22> clazz = AbstractFileLineWriter_Stub22.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub22> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub22>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // O(tB[h)
        Map<Class, StringConverter> preStringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(AbstractFileLineWriter.class,
                "stringConverterCacheMap", preStringConverterCacheMap);

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

            // (ԕωAtB[h)
            Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverterCacheMap");
            assertNotNull(stringConverterCacheMap);
            assertEquals(3, stringConverterCacheMap.size());
            assertTrue(stringConverterCacheMap
                    .containsKey(NullStringConverter.class));
            StringConverter nullStringConverter = stringConverterCacheMap
                    .get(NullStringConverter.class);
            assertNotNull(nullStringConverter);
            assertTrue(NullStringConverter.class
                    .isAssignableFrom(nullStringConverter.getClass()));
            assertTrue(stringConverterCacheMap
                    .containsKey(NullStringConverter.class));
            StringConverter stringConverterToLowerCase = stringConverterCacheMap
                    .get(StringConverterToLowerCase.class);
            assertNotNull(stringConverterToLowerCase);
            assertTrue(StringConverterToLowerCase.class
                    .isAssignableFrom(stringConverterToLowerCase.getClass()));
            assertTrue(stringConverterCacheMap
                    .containsKey(StringConverterToUpperCase.class));
            StringConverter stringConverterToUpperCase = stringConverterCacheMap
                    .get(StringConverterToUpperCase.class);
            assertNotNull(stringConverterToUpperCase);
            assertTrue(StringConverterToUpperCase.class
                    .isAssignableFrom(stringConverterToUpperCase.getClass()));

            StringConverter[] stringConverters = (StringConverter[]) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverters");
            assertNotNull(stringConverters);
            assertEquals(6, stringConverters.length);
            StringConverter stringConverters1 = stringConverters[0];
            assertNotNull(stringConverters1);
            assertSame(nullStringConverter, stringConverters1);
            StringConverter stringConverters2 = stringConverters[1];
            assertNotNull(stringConverters2);
            assertSame(stringConverterToLowerCase, stringConverters2);
            StringConverter stringConverters3 = stringConverters[2];
            assertNotNull(stringConverters3);
            assertSame(stringConverterToUpperCase, stringConverters3);
            StringConverter stringConverters4 = stringConverters[3];
            assertNotNull(stringConverters4);
            assertSame(nullStringConverter, stringConverters4);
            StringConverter stringConverters5 = stringConverters[4];
            assertNotNull(stringConverters5);
            assertSame(stringConverterToLowerCase, stringConverters5);
            StringConverter stringConverters6 = stringConverters[5];
            assertNotNull(stringConverters6);
            assertSame(stringConverterToUpperCase, stringConverters6);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildStringConverters05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildStringConverters05.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > stringConverterFftHgRXgN^ĂȂStringConverter̃NXCX^X<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.stringConverterCacheMap:vfȂMapCX^X<br>
     * <br>
     *                         ҒlF(ԕω) -:ȉ̏FileLineException()<br>
     *                         EbZ[WF"Failed in an instantiate of a stringConverter."<br>
     *                         EOFInstantiationException<br>
     *                         Et@CFfileNameƓCX^X<br>
     *                         EsF-1<br>
     *                         EJFcolumn1<br>
     *                         EJԍF0<br>
     * <br>
     *                         ُP[X<br>
     *                         w肵StringConverterɃftHgRXgN^݂ȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testBuildStringConverters05() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub23> clazz = AbstractFileLineWriter_Stub23.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub23> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub23>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // O(tB[h)
        Map<Class, StringConverter> preStringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(AbstractFileLineWriter.class,
                "stringConverterCacheMap", preStringConverterCacheMap);

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals("Failed in an instantiate of a stringConverter.", e
                    .getMessage());
            assertTrue(InstantiationException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
            assertEquals(-1, e.getLineNo());
            assertEquals("column1", e.getColumnName());
            assertEquals(0, e.getColumnIndex());
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildStringConverters06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_Ff <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildStringConverters06.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > stringConverterFftHgRXgN^privateŐ錾ĂStringConverter̃NXCX^X<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.stringConverterCacheMap:vfȂMapCX^X<br>
     * <br>
     *                         ҒlF(ԕω) -:ȉ̏FileLineException()<br>
     *                         EbZ[WF"Failed in an instantiate of a stringConverter."<br>
     *                         EOFIllegalAccessException<br>
     *                         Et@CFfileNameƓCX^X<br>
     *                         EsF-1<br>
     *                         EJFcolumn1<br>
     *                         EJԍF0<br>
     * <br>
     *                         ُP[X<br>
     *                         w肵StringConverter̃ftHgRXgN^privateŐ錾ĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testBuildStringConverters06() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub24> clazz = AbstractFileLineWriter_Stub24.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub24> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub24>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // O(tB[h)
        Map<Class, StringConverter> preStringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(AbstractFileLineWriter.class,
                "stringConverterCacheMap", preStringConverterCacheMap);

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals("Failed in an instantiate of a stringConverter.", e
                    .getMessage());
            assertTrue(IllegalAccessException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
            assertEquals(-1, e.getLineNo());
            assertEquals("column1", e.getColumnName());
            assertEquals(0, e.getColumnIndex());
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildStringConverters07() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildStringConverters07.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         () this.stringConverterCacheMap:vfȂMapCX^X<br>
     * <br>
     *                         ҒlF(ԕω) this.stringConverterCacheMap:ȉ̗vfMapCX^X<br>
     *                         EkeyFNullStringConverter.class,<br>
     *                         valueFNullStringConverterCX^X<br>
     *                         (ԕω) this.stringConverters:ȉ̗vfStringConverterz<br>
     *                         1DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         2DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     *                         3DNullStringConverterCX^X(LbVꂽ̂ƓCX^X)<br>
     * <br>
     *                         P[X<br>
     *                         (stringConverterݒȂtB[hF3)<br>
     *                         stringConverterݒ肪ȂꍇANullStringConverterŏ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @SuppressWarnings("unchecked")
    @Test
    public void testBuildStringConverters07() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub13> clazz = AbstractFileLineWriter_Stub13.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub13> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub13>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");

        // O(tB[h)
        Map<Class, StringConverter> preStringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(AbstractFileLineWriter.class,
                "stringConverterCacheMap", preStringConverterCacheMap);

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

            // (ԕωAtB[h)
            Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverterCacheMap");
            assertNotNull(stringConverterCacheMap);
            assertEquals(1, stringConverterCacheMap.size());
            assertTrue(stringConverterCacheMap
                    .containsKey(NullStringConverter.class));
            StringConverter nullStringConverter = stringConverterCacheMap
                    .get(NullStringConverter.class);
            assertNotNull(nullStringConverter);
            assertTrue(NullStringConverter.class
                    .isAssignableFrom(nullStringConverter.getClass()));

            StringConverter[] stringConverters = (StringConverter[]) UTUtil
                    .getPrivateField(fileLineWriter, "stringConverters");
            assertNotNull(stringConverters);
            assertEquals(3, stringConverters.length);
            StringConverter stringConverters1 = stringConverters[0];
            assertNotNull(stringConverters1);
            assertSame(nullStringConverter, stringConverters1);
            StringConverter stringConverters2 = stringConverters[1];
            assertNotNull(stringConverters2);
            assertSame(nullStringConverter, stringConverters2);
            StringConverter stringConverters3 = stringConverters[2];
            assertNotNull(stringConverters3);
            assertSame(nullStringConverter, stringConverters3);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildMethods01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildMethodsConverters01.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * <br>
     * ҒlF(ԕω) this.methods:vfȂMethodzCX^X<br>
     * <br>
     * P[X<br>
     * t@CsIuWFNgNXtB[hȂꍇAmethodsz񂪋ŏ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testBuildMethods01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub08> clazz = AbstractFileLineWriter_Stub08.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub08> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub08>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");
        UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildMethods");

            // (ԕωAtB[h)
            Method[] methods = (Method[]) UTUtil.getPrivateField(
                    fileLineWriter, "methods");
            assertNotNull(methods);
            assertEquals(0, methods.length);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildMethods02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildMethodsConverters02.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     * <br>
     *                         ҒlF(ԕω) this.methods:ȉ̗vfMethodzCX^X<br>
     *                         PDMethodIuWFNg<br>
     *                         - \bhFgetColumn1<br>
     *                         - FȂ<br>
     * <br>
     *                         P[X<br>
     *                         (@OutputFileColumnݒ肠tB[hF1A<br>
     *                         tB[hɑ΂getter\bh)<br>
     *                         t@CsIuWFNgNX@OutputFileColumnݒ肠tB[hꍇAmethodsz񂪐邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testBuildMethods02() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");
        UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildMethods");

            // (ԕωAtB[h)
            Method[] methods = (Method[]) UTUtil.getPrivateField(
                    fileLineWriter, "methods");
            assertNotNull(methods);
            assertEquals(1, methods.length);
            Method methods1 = methods[0];
            assertEquals("getColumn1", methods1.getName());
            assertEquals(0, methods1.getParameterTypes().length);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildMethods03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildMethodsConverters03.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhȂB<br>
     * <br>
     *                         ҒlF(ԕω) -:ȉ̐ݒFileExceptionCX^X<br>
     *                         EbZ[WF"The getter method of column doesn't exist."<br>
     *                         EOFNoSuchMethodException<br>
     *                         Et@CFfileNameƓCX^X<br>
     * <br>
     *                         ُP[X<br>
     *                         (@OutputFileColumnݒ肠tB[hF1A<br>
     *                         tB[hɑ΂getter\bhȂ)<br>
     *                         tB[hɑ΂getter\bhȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testBuildMethods03() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub25> clazz = AbstractFileLineWriter_Stub25.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub25> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub25>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");
        UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildMethods");
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("The getter method of column doesn't exist.", e
                    .getMessage());
            assertTrue(NoSuchMethodException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());

        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildMethods04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildMethodsConverters04.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     * <br>
     *                         ҒlF(ԕω) this.methods:ȉ̗vfMethodzCX^X<br>
     *                         1DMethodIuWFNg<br>
     *                         - \bhFgetColumn1<br>
     *                         - FȂ<br>
     *                         2DMethodIuWFNg<br>
     *                         - \bhFgetColumn2<br>
     *                         - FȂ<br>
     *                         3DMethodIuWFNg<br>
     *                         - \bhFgetColumn3<br>
     *                         - FȂ<br>
     * <br>
     *                         P[X<br>
     *                         (@OutputFileColumnݒ肠tB[hF3A<br>
     *                         tB[hɑ΂getter\bh)<br>
     *                         t@CsIuWFNgNX@OutputFileColumnݒ肠tB[hꍇAmethodsz񂪐邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testBuildMethods04() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub13> clazz = AbstractFileLineWriter_Stub13.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub13> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub13>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");
        UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildMethods");

            // (ԕωAtB[h)
            Method[] methods = (Method[]) UTUtil.getPrivateField(
                    fileLineWriter, "methods");
            assertNotNull(methods);
            assertEquals(3, methods.length);
            Method methods1 = methods[0];
            assertEquals("getColumn1", methods1.getName());
            assertEquals(0, methods1.getParameterTypes().length);
            Method methods2 = methods[1];
            assertEquals("getColumn2", methods2.getName());
            assertEquals(0, methods2.getParameterTypes().length);
            Method methods3 = methods[2];
            assertEquals("getColumn3", methods3.getName());
            assertEquals(0, methods3.getParameterTypes().length);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testBuildMethods05() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testBuildMethodsConverters05.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     * <br>
     *                         ȉeNX̒`<br>
     *                         E@OutputFileColumnݒ肠̃tB[h<br>
     *                         - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     * <br>
     *                         eNXɃtB[h̏񂪂B<br>
     * <br>
     *                         ҒlF(ԕω) this.methods:ȉ̗vfMethodzCX^X<br>
     *                         1DMethodIuWFNg<br>
     *                         - \bhFgetColumn1<br>
     *                         - FȂ<br>
     *                         2DMethodIuWFNg<br>
     *                         - \bhFgetColumn2<br>
     *                         - FȂ<br>
     *                         3DMethodIuWFNg<br>
     *                         - \bhFgetColumn3<br>
     *                         - FȂ<br>
     * <br>
     *                         P[X<br>
     *                         (@OutputFileColumnݒ肠tB[hF3A<br>
     *                         tB[hɑ΂getter\bhA<br>
     *                         eNXɂtB[h`݂)<br>
     *                         t@CsIuWFNgNX@OutputFileColumnݒ肠tB[hꍇAmethodsz񂪐邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testBuildMethods05() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub19> clazz = AbstractFileLineWriter_Stub19.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub19> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub19>(
                fileName, clazz, columnFormatterMap);
        UTUtil.invokePrivate(fileLineWriter, "buildFields");
        UTUtil.invokePrivate(fileLineWriter, "buildStringConverters");

        try {
            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "buildMethods");

            // (ԕωAtB[h)
            Method[] methods = (Method[]) UTUtil.getPrivateField(
                    fileLineWriter, "methods");
            assertNotNull(methods);
            assertEquals(3, methods.length);
            Method methods1 = methods[0];
            assertEquals("getColumn1", methods1.getName());
            assertEquals(0, methods1.getParameterTypes().length);
            Method methods2 = methods[1];
            assertEquals("getColumn2", methods2.getName());
            assertEquals(0, methods2.getParameterTypes().length);
            Method methods3 = methods[2];
            assertEquals("getColumn3", methods3.getName());
            assertEquals(0, methods3.getParameterTypes().length);
        } finally {
            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintHeaderLine01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() headerLine:vfȂListCX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintHeaderLine01.txt"<br>
     * () writeTrailer:false<br>
     * () writeData:false<br>
     * <br>
     * ҒlF(ԕω) #printList():1Ă΂B<br>
     * ̊mFsB<br>
     * <br>
     * P[X<br>
     * f[^ƃgC̏ݏsOɎsꂽꍇAΏList̏o͏sƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintHeaderLine01() throws Exception {
        // O(Ώ)
        String fileName = TEMP_FILE_NAME;
        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);
        try {
            fileLineWriter.init();

            // O()
            List<String> headerLine = new ArrayList<String>();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "writeData", Boolean.FALSE);

            // eXg{
            fileLineWriter.printHeaderLine(headerLine);

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "printList"));
            List printListArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "printList", 0);
            assertSame(headerLine, printListArguments.get(0));
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintHeaderLine02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() headerLine:vfȂListCX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintHeaderLine02.txt"<br>
     * () writeTrailer:true<br>
     * () writeData:false<br>
     * <br>
     * ҒlF(ԕω) #printList():Ă΂Ȃ<br>
     * (ԕω) -:ȉ̏FileExceptionB<br>
     * EbZ[WF"Header part should be called before data part or trailer part."<br>
     * EOFIllegalStateException<br>
     * Et@CFfileNameƓCX^X<br>
     * <br>
     * ُP[X<br>
     * wb_so͂OɃgCso͂ĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintHeaderLine02() throws Exception {
        // O(Ώ)
        String fileName = TEMP_FILE_NAME;

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);
        try {
            fileLineWriter.init();

            // O()
            List<String> headerLine = new ArrayList<String>();

            // O(tB[h)
            UTUtil
                    .setPrivateField(fileLineWriter, "writeTrailer",
                            Boolean.TRUE);

            UTUtil.setPrivateField(fileLineWriter, "writeData", Boolean.FALSE);

            // eXg{
            fileLineWriter.printHeaderLine(headerLine);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Header part should be called before data part or "
                    + "trailer part.", e.getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "printList"));
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintHeaderLine03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() headerLine:vfȂListCX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintHeaderLine03.txt"<br>
     * () writeTrailer:false<br>
     * () writeData:true<br>
     * <br>
     * ҒlF(ԕω) #printList():Ă΂Ȃ<br>
     * (ԕω) -:ȉ̏FileExceptionB<br>
     * EbZ[WF"Header part should be called before data part or trailer part."<br>
     * EOFIllegalStateException<br>
     * Et@CFfileNameƓCX^X<br>
     * <br>
     * ُP[X<br>
     * wb_so͂OɃf[^so͂ĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintHeaderLine03() throws Exception {
        // O(Ώ)
        String fileName = TEMP_FILE_NAME;

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);
        try {
            fileLineWriter.init();

            // O()
            List<String> headerLine = new ArrayList<String>();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "writeData", Boolean.TRUE);

            // eXg{
            fileLineWriter.printHeaderLine(headerLine);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Header part should be called before data part or "
                    + "trailer part.", e.getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "printList"));
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine01.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:true<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():ُI<br>
     *                         Eȉ̗OԂB<br>
     *                         - ArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:0<br>
     *                         (ԕω) #getColumn():Ă΂Ȃ<br>
     *                         (ԕω) #getWriter().write():Ă΂Ȃ<br>
     *                         (ԕω) #setWriteData():Ă΂Ȃ<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ωȂ<br>
     *                         (ԕω) O:ȉ̏FileException<br>
     *                         EbZ[WF"Header part or data part should be called before TrailerPart"<br>
     *                         EOFIllegalStateException<br>
     *                         Et@CFfileNameƓCX^X<br>
     * <br>
     *                         ُP[X<br>
     *                         gC̏o͂ɊĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine01() throws Exception {

        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub10 t = new AbstractFileLineWriter_Stub10();

            // O(tB[h)
            UTUtil
                    .setPrivateField(fileLineWriter, "writeTrailer",
                            Boolean.TRUE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineWriter.class,
                    "getColumn", new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);
            fail("FileException܂łB");

        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Header part or data part should be called before "
                    + "TrailerPart", e.getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());

            // (ԕωAtB[h)
            assertEquals(0, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "getColumn"));

            assertFalse(VMOUTUtil.isCalled(Writer.class, "writer"));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "setWriteData"));

            // (t@C)
            writer.flush();

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine02.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * () this.writeTrailer:false<br>
     * () this.currentLineCount:0<br>
     * () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     * () #getColumn():ُI<br>
     * Eȉ̗OԂB<br>
     * - ArrayIndexOutOfBoundException<br>
     * () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     * () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     * () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * Ee͂Ȃ(Obyte)<br>
     * <br>
     * ҒlF(ԕω) this.currentLineCount:1<br>
     * (ԕω) #getColumn():Ă΂Ȃ<br>
     * (ԕω) #getWriter().write():1Ă΂<br>
     * mFB<br>
     * (ԕω) #setWriteData():1Ă΂<br>
     * mFB<br>
     * (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * EeFs؂蕶P̂<br>
     * <br>
     * P[X<br>
     * (o͑ΏۃtB[hFȂA؂蕶FftHglA<br>
     * ͂ݕFftHgl)<br>
     * o͑Ώۂ̃tB[hȂꍇAs؂蕶̂݃t@Cɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine02() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub08> clazz = AbstractFileLineWriter_Stub08.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub08> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub08>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub08 t = new AbstractFileLineWriter_Stub08();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineWriter.class,
                    "getColumn", new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "getColumn"));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine03() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine03.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine03_column1"<br>
     *                         - 2ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"testPrintDataLine03_column1<s؂蕶>"<br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF1A؂蕶FftHglA<br>
     *                         ͂ݕFftHgl)<br>
     *                         o͑Ώۂ̃tB[hPꍇAo͑ΏۃtB[h̏񂪏o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine03() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub10 t = new AbstractFileLineWriter_Stub10();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine03_column1");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    1, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtument = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtument.size());
            assertSame(t, getColumnArtument.get(0));
            assertEquals(0, getColumnArtument.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "testPrintDataLine03_column1"
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine04() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine04.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine04_column1"<br>
     *                         - 2ځF"testPrintDataLine04_column2"<br>
     *                         - 3ځF"testPrintDataLine04_column3"<br>
     *                         - 4ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():3Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"testPrintDataLine04_column1<؂蕶>testPrintDataLine04_column2<؂蕶>testPrintDataLine04_column3<s؂蕶>"
     * <br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF3A؂蕶FftHglA<br>
     *                         ͂ݕFftHgl)<br>
     *                         o͑Ώۂ̃tB[h3ꍇASo͑ΏۃtB[h̏Ƃ̊Ԃɋ؂蕶o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine04() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub13> clazz = AbstractFileLineWriter_Stub13.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub13> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub13>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub13 t = new AbstractFileLineWriter_Stub13();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine04_column1");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 1, "testPrintDataLine04_column2");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 2, "testPrintDataLine04_column3");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    3, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(3, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtuments1 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtuments1.size());
            assertSame(t, getColumnArtuments1.get(0));
            assertEquals(0, getColumnArtuments1.get(1));
            List getColumnArtuments2 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 1);
            assertEquals(2, getColumnArtuments2.size());
            assertSame(t, getColumnArtuments2.get(0));
            assertEquals(1, getColumnArtuments2.get(1));
            List getColumnArtuments3 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 2);
            assertEquals(2, getColumnArtuments3.size());
            assertSame(t, getColumnArtuments3.get(0));
            assertEquals(2, getColumnArtuments3.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "testPrintDataLine04_column1,"
                    + "testPrintDataLine04_column2,testPrintDataLine04_column3"
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine05.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         ɃN[YĂB<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine05_column1"<br>
     *                         - 2ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:0<br>
     *                         (ԕω) #getColumn():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():Ă΂Ȃ<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ωȂ<br>
     *                         (ԕω) O:ȉ̏FileException<br>
     *                         EbZ[WF"Processing of writer was failed."<br>
     *                         EOFIOException<br>
     *                         Et@CFfileNameƓCX^X<br>
     * <br>
     *                         ُP[X<br>
     *                         t@CݗpwriterɃN[YꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine05() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;

        // O()
        AbstractFileLineWriter_Stub10 t = new AbstractFileLineWriter_Stub10();

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));
            writer.close();

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine05_column1");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    1, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Processing of writer was failed.", e.getMessage());
            assertTrue(IOException.class.isAssignableFrom(e.getCause()
                    .getClass()));
            assertEquals(fileName, e.getFileName());

            // (ԕωAtB[h)
            assertEquals(0, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtument = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtument.size());
            assertSame(t, getColumnArtument.get(0));
            assertEquals(0, getColumnArtument.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "testPrintDataLine05_column1"
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "setWriteData"));

            // (t@C)
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine06() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine06.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF'\"'<br>
     * - ̑FftHgl<br>
     * EtB[hĂȂ<br>
     * () this.writeTrailer:false<br>
     * () this.currentLineCount:0<br>
     * () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     * () #getColumn():ُI<br>
     * Eȉ̗OԂB<br>
     * - ArrayIndexOutOfBoundException<br>
     * () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     * () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     * () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * Ee͂Ȃ(Obyte)<br>
     * <br>
     * ҒlF(ԕω) this.currentLineCount:1<br>
     * (ԕω) #getColumn():Ă΂Ȃ<br>
     * (ԕω) #getWriter().write():1Ă΂<br>
     * mFB<br>
     * (ԕω) #setWriteData():1Ă΂<br>
     * mFB<br>
     * (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * EeFs؂蕶P̂<br>
     * <br>
     * P[X<br>
     * (o͑ΏۃtB[hFȂA؂蕶FftHglA<br>
     * ͂ݕFftHglȊO)<br>
     * o͑Ώۂ̃tB[hȂꍇAs؂蕶̂݃t@Cɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine06() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub26> clazz = AbstractFileLineWriter_Stub26.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub26> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub26>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub26 t = new AbstractFileLineWriter_Stub26();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineWriter.class,
                    "getColumn", new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "getColumn"));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine07() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine07.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF'\"'<br>
     * - ̑FftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine07_column1"<br>
     *                         - 2ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"\"testPrintDataLine07_column1\"<s؂蕶>"<br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF1A؂蕶FftHglA<br>
     *                         ͂ݕFftHglȊO)<br>
     *                         o͑Ώۂ̃tB[hPꍇA͂ݕɈ͂܂ꂽo͑ΏۃtB[h̏񂪏o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine07() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub27> clazz = AbstractFileLineWriter_Stub27.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub27> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub27>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub27 t = new AbstractFileLineWriter_Stub27();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine07_column1");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    1, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtument = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtument.size());
            assertSame(t, getColumnArtument.get(0));
            assertEquals(0, getColumnArtument.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "\"testPrintDataLine07_column1\""
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine08() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine08.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF'\"'<br>
     * - ̑FftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine08_column1"<br>
     *                         - 2ځF"testPrintDataLine08_column2"<br>
     *                         - 3ځF"testPrintDataLine08_column3"<br>
     *                         - 4ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():3Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF
     *                         "\"testPrintDataLine08_column1\"<؂蕶>\"testPrintDataLine08_column2\"<؂蕶>\"testPrintDataLine08_column3\"<s؂蕶>"
     * <br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF3A؂蕶FftHglA<br>
     *                         ͂ݕFftHglȊO)<br>
     *                         o͑Ώۂ̃tB[h3ꍇA͂ݕɈ͂܂ꂽSo͑ΏۃtB[h̏Ƃ̊Ԃɋ؂蕶o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine08() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub28> clazz = AbstractFileLineWriter_Stub28.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub28> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub28>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub28 t = new AbstractFileLineWriter_Stub28();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine08_column1");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 1, "testPrintDataLine08_column2");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 2, "testPrintDataLine08_column3");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    3, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(3, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtuments1 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtuments1.size());
            assertSame(t, getColumnArtuments1.get(0));
            assertEquals(0, getColumnArtuments1.get(1));
            List getColumnArtuments2 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 1);
            assertEquals(2, getColumnArtuments2.size());
            assertSame(t, getColumnArtuments2.get(0));
            assertEquals(1, getColumnArtuments2.get(1));
            List getColumnArtuments3 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 2);
            assertEquals(2, getColumnArtuments3.size());
            assertSame(t, getColumnArtuments3.get(0));
            assertEquals(2, getColumnArtuments3.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "\"testPrintDataLine08_column1\","
                    + "\"testPrintDataLine08_column2\",\"testPrintDataLine08_column3\""
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine09() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine09.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF'|'<br>
     * - ̑FftHgl<br>
     * EtB[hĂȂ<br>
     * () this.writeTrailer:false<br>
     * () this.currentLineCount:0<br>
     * () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     * () #getColumn():ُI<br>
     * Eȉ̗OԂB<br>
     * - ArrayIndexOutOfBoundException<br>
     * () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     * () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     * () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * Ee͂Ȃ(Obyte)<br>
     * <br>
     * ҒlF(ԕω) this.currentLineCount:1<br>
     * (ԕω) #getColumn():Ă΂Ȃ<br>
     * (ԕω) #getWriter().write():1Ă΂<br>
     * mFB<br>
     * (ԕω) #setWriteData():1Ă΂<br>
     * mFB<br>
     * (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * EeFs؂蕶P̂<br>
     * <br>
     * P[X<br>
     * (o͑ΏۃtB[hFȂA͂ݕFftHglA<br>
     * ؂蕶FCharacter.MIN_VALUE)<br>
     * o͑Ώۂ̃tB[hȂꍇAs؂蕶̂݃t@Cɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine09() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub29> clazz = AbstractFileLineWriter_Stub29.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub29> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub29>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub29 t = new AbstractFileLineWriter_Stub29();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineWriter.class,
                    "getColumn", new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "getColumn"));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine10() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine10.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF'|'<br>
     * - ̑FftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine10_column1"<br>
     *                         - 2ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"testPrintDataLine10_column1<s؂蕶>"<br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF1A͂ݕFftHglA<br>
     *                         ؂蕶FCharacter.MIN_VALUE)<br>
     *                         o͑Ώۂ̃tB[hPꍇAo͑ΏۃtB[h̏񂪏o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine10() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub30> clazz = AbstractFileLineWriter_Stub30.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub30> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub30>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub30 t = new AbstractFileLineWriter_Stub30();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine10_column1");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    1, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtument = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtument.size());
            assertSame(t, getColumnArtument.get(0));
            assertEquals(0, getColumnArtument.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "testPrintDataLine10_column1"
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine11() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine11.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterF'|'<br>
     * - ̑FftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine11_column1"<br>
     *                         - 2ځF"testPrintDataLine11_column2"<br>
     *                         - 3ځF"testPrintDataLine11_column3"<br>
     *                         - 4ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():3Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"testPrintDataLine11_column1|testPrintDataLine11_column2|testPrintDataLine11_column3<s؂蕶>"<br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF3A͂ݕFftHglA<br>
     *                         ؂蕶FCharacter.MIN_VALUE)<br>
     *                         o͑Ώۂ̃tB[h3ꍇASo͑ΏۃtB[h̏Ƃ̊Ԃɋ؂蕶o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine11() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub31> clazz = AbstractFileLineWriter_Stub31.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub31> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub31>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub31 t = new AbstractFileLineWriter_Stub31();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine11_column1");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 1, "testPrintDataLine11_column2");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 2, "testPrintDataLine11_column3");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    3, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(3, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtuments1 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtuments1.size());
            assertSame(t, getColumnArtuments1.get(0));
            assertEquals(0, getColumnArtuments1.get(1));
            List getColumnArtuments2 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 1);
            assertEquals(2, getColumnArtuments2.size());
            assertSame(t, getColumnArtuments2.get(0));
            assertEquals(1, getColumnArtuments2.get(1));
            List getColumnArtuments3 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 2);
            assertEquals(2, getColumnArtuments3.size());
            assertSame(t, getColumnArtuments3.get(0));
            assertEquals(2, getColumnArtuments3.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "testPrintDataLine11_column1|"
                    + "testPrintDataLine11_column2|testPrintDataLine11_column3"
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine12() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine12.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():null<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine12_column1"<br>
     *                         - 2ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:0<br>
     *                         (ԕω) #getColumn():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():Ă΂Ȃ<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ωȂ<br>
     *                         (ԕω) O:NullPointerException<br>
     * <br>
     *                         ُP[X<br>
     *                         getWriter()̌ʂnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine12() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;

        // O()
        AbstractFileLineWriter_Stub10 t = new AbstractFileLineWriter_Stub10();

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = null;

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine12_column1");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    1, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // (O)
            assertTrue(NullPointerException.class
                    .isAssignableFrom(e.getClass()));

            // (ԕωAtB[h)
            assertEquals(0, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtument = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtument.size());
            assertSame(t, getColumnArtument.get(0));
            assertEquals(0, getColumnArtument.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "testPrintDataLine12_column1"
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "setWriteData"));

            // (t@C)
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine13() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine13.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterFCharacter.MIN_VALUE<br>
     * - encloseCharF'\"'<br>
     * - ̑FftHgl<br>
     * EtB[hĂȂ<br>
     * () this.writeTrailer:false<br>
     * () this.currentLineCount:0<br>
     * () #getWriter():not null<br>
     * () #getColumn():ُI<br>
     * Eȉ̗OԂB<br>
     * - ArrayIndexOutOfBoundException<br>
     * () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     * () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     * () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * Ee͂Ȃ(Obyte)<br>
     * <br>
     * ҒlF(ԕω) this.currentLineCount:1<br>
     * (ԕω) #getColumn():Ă΂Ȃ<br>
     * (ԕω) #getWriter().write():1Ă΂<br>
     * mFB<br>
     * (ԕω) #setWriteData():1Ă΂<br>
     * mFB<br>
     * (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * EeFs؂蕶P̂<br>
     * <br>
     * P[X<br>
     * (o͑ΏۃtB[hFȂA͂ݕFftHglȊOA<br>
     * ؂蕶FCharacter.MIN_VALUE)<br>
     * o͑Ώۂ̃tB[hȂꍇAs؂蕶̂݃t@Cɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine13() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub32> clazz = AbstractFileLineWriter_Stub32.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub32> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub32>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub32 t = new AbstractFileLineWriter_Stub32();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineWriter.class,
                    "getColumn", new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "getColumn"));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine14() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine14.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterFCharacter.MIN_VALUE<br>
     * - encloseCharF'\"'<br>
     * - ̑FftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine14_column1"<br>
     *                         - 2ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"\"testPrintDataLine14_column1\"<s؂蕶>"<br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF1A؂蕶FftHglA<br>
     *                         ͂ݕFftHglȊO)<br>
     *                         o͑Ώۂ̃tB[hPꍇA͂ݕɈ͂܂ꂽo͑ΏۃtB[h̏̂ݏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine14() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub33> clazz = AbstractFileLineWriter_Stub33.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub33> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub33>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub33 t = new AbstractFileLineWriter_Stub33();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine14_column1");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    1, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtument = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtument.size());
            assertSame(t, getColumnArtument.get(0));
            assertEquals(0, getColumnArtument.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "\"testPrintDataLine14_column1\""
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine15() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine15.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - delimiterFCharacter.MIN_VALUE<br>
     * - encloseCharF'\"'<br>
     * - ̑FftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine15_column1"<br>
     *                         - 2ځF"testPrintDataLine15_column2"<br>
     *                         - 3ځF"testPrintDataLine15_column3"<br>
     *                         - 4ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():this.clazz̃tB[h`ɏ]B<br>
     *                         () #getEncloseChar():this.clazz̃tB[h`ɏ]B<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():3Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"\"testPrintDataLine15_column1\"\"testPrintDataLine15_column2\"\"testPrintDataLine15_column3\"<s؂蕶>"
     * <br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF3A؂蕶FftHglA<br>
     *                         ͂ݕFftHglȊO)<br>
     *                         o͑Ώۂ̃tB[h3ꍇA͂ݕɈ͂܂ꂽSo͑ΏۃtB[h̏񂪏o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine15() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub34> clazz = AbstractFileLineWriter_Stub34.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub34> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub34>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub34 t = new AbstractFileLineWriter_Stub34();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine15_column1");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 1, "testPrintDataLine15_column2");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 2, "testPrintDataLine15_column3");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    3, new ArrayIndexOutOfBoundsException("킴"));

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(3, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtuments1 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtuments1.size());
            assertSame(t, getColumnArtuments1.get(0));
            assertEquals(0, getColumnArtuments1.get(1));
            List getColumnArtuments2 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 1);
            assertEquals(2, getColumnArtuments2.size());
            assertSame(t, getColumnArtuments2.get(0));
            assertEquals(1, getColumnArtuments2.get(1));
            List getColumnArtuments3 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 2);
            assertEquals(2, getColumnArtuments3.size());
            assertSame(t, getColumnArtuments3.get(0));
            assertEquals(2, getColumnArtuments3.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "\"testPrintDataLine15_column1\""
                    + Character.MIN_VALUE + "\"testPrintDataLine15_column2\""
                    + Character.MIN_VALUE + "\"testPrintDataLine15_column3\""
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine16() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine16.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂ<br>
     * () this.writeTrailer:false<br>
     * () this.currentLineCount:0<br>
     * () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     * () #getColumn():ُI<br>
     * Eȉ̗OԂB<br>
     * - ArrayIndexOutOfBoundException<br>
     * () #getDelimiter():Character.MIN_VALUEԂ<br>
     * () #getEncloseChar():Character.MIN_VALUEԂ<br>
     * () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * Ee͂Ȃ(Obyte)<br>
     * <br>
     * ҒlF(ԕω) this.currentLineCount:1<br>
     * (ԕω) #getColumn():Ă΂Ȃ<br>
     * (ԕω) #getWriter().write():1Ă΂<br>
     * mFB<br>
     * (ԕω) #setWriteData():1Ă΂<br>
     * mFB<br>
     * (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     * EeFs؂蕶P̂<br>
     * <br>
     * P[X<br>
     * (o͑ΏۃtB[hFȂA<br>
     * ͂ݕFCharacter.MIN_VALUEA<br>
     * ؂蕶FCharacter.MIN_VALUE)<br>
     * o͑Ώۂ̃tB[hȂꍇAs؂蕶̂݃t@Cɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine16() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub08> clazz = AbstractFileLineWriter_Stub08.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub08> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub08>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub08 t = new AbstractFileLineWriter_Stub08();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineWriter.class,
                    "getColumn", new ArrayIndexOutOfBoundsException("킴"));

            VMOUTUtil.setReturnValueAtAllTimes(
                    AbstractFileLineWriterImpl01.class, "getDelimiter",
                    Character.MIN_VALUE);

            VMOUTUtil.setReturnValueAtAllTimes(
                    AbstractFileLineWriterImpl01.class, "getEncloseChar",
                    Character.MIN_VALUE);

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "getColumn"));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine17() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine17.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine10_column1"<br>
     *                         - 2ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():Character.MIN_VALUEԂ<br>
     *                         () #getEncloseChar():Character.MIN_VALUEԂ<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"testPrintDataLine17_column1<s؂蕶>"<br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF1A<br>
     *                         ͂ݕFCharacter.MIN_VALUEA<br>
     *                         ؂蕶FCharacter.MIN_VALUE)<br>
     *                         o͑Ώۂ̃tB[hPꍇAo͑ΏۃtB[h̏񂪏o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine17() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub10 t = new AbstractFileLineWriter_Stub10();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine17_column1");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    1, new ArrayIndexOutOfBoundsException("킴"));

            VMOUTUtil.setReturnValueAtAllTimes(
                    AbstractFileLineWriterImpl01.class, "getDelimiter",
                    Character.MIN_VALUE);

            VMOUTUtil.setReturnValueAtAllTimes(
                    AbstractFileLineWriterImpl01.class, "getEncloseChar",
                    Character.MIN_VALUE);

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtument = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtument.size());
            assertSame(t, getColumnArtument.get(0));
            assertEquals(0, getColumnArtument.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");
            String expectationResultData = "testPrintDataLine17_column1"
                    + systemLineSeparator;
            assertEquals(expectationResultData, writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintDataLine18() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() t:this.clazz̃CX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintDataLine18.txt"<br>
     * () this.fields:this.clazz̃tB[h`ɏ]B<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.writeTrailer:false<br>
     *                         () this.currentLineCount:0<br>
     *                         () #getWriter():this.fileNamet@Cɑ΂WriterCX^X<br>
     *                         () #getColumn():I<br>
     *                         Eȉ̌ʂԂB<br>
     *                         - 1ځF"testPrintDataLine11_column1"<br>
     *                         - 2ځF"testPrintDataLine11_column2"<br>
     *                         - 3ځF"testPrintDataLine11_column3"<br>
     *                         - 4ڈȌFArrayIndexOutOfBoundException<br>
     *                         () #getDelimiter():Character.MIN_VALUEԂ<br>
     *                         () #getEncloseChar():Character.MIN_VALUEԂ<br>
     *                         () t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         Ee͂Ȃ(Obyte)<br>
     * <br>
     *                         ҒlF(ԕω) this.currentLineCount:1<br>
     *                         (ԕω) #getColumn():3Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #getWriter().write():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #setWriteData():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) t@C:NXpXthis.fileNameɑ΂t@C݂B<br>
     *                         EeF"testPrintDataLine18_column1testPrintDataLine18_column2testPrintDataLine18_column3<s؂蕶>"<br>
     * <br>
     *                         P[X<br>
     *                         (o͑ΏۃtB[hF3A<br>
     *                         ͂ݕFCharacter.MIN_VALUEA<br>
     *                         ؂蕶FCharacter.MIN_VALUE)<br>
     *                         o͑Ώۂ̃tB[h3ꍇASo͑ΏۃtB[h̏񂪏o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintDataLine18() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub13> clazz = AbstractFileLineWriter_Stub13.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub13> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub13>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            AbstractFileLineWriter_Stub13 t = new AbstractFileLineWriter_Stub13();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "getWriter", writer);

            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 0, "testPrintDataLine18_column1");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 1, "testPrintDataLine18_column2");
            VMOUTUtil.setReturnValueAt(AbstractFileLineWriter.class,
                    "getColumn", 2, "testPrintDataLine18_column3");
            VMOUTUtil.setExceptionAt(AbstractFileLineWriter.class, "getColumn",
                    3, new ArrayIndexOutOfBoundsException("킴"));

            VMOUTUtil.setReturnValueAtAllTimes(
                    AbstractFileLineWriterImpl01.class, "getDelimiter",
                    Character.MIN_VALUE);

            VMOUTUtil.setReturnValueAtAllTimes(
                    AbstractFileLineWriterImpl01.class, "getEncloseChar",
                    Character.MIN_VALUE);

            // eXg{
            fileLineWriter.printDataLine(t);

            // (ԕωAtB[h)
            assertEquals(1, UTUtil.getPrivateField(fileLineWriter,
                    "currentLineCount"));

            // (ԕωA\bh)
            assertEquals(3, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List getColumnArtuments1 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, getColumnArtuments1.size());
            assertSame(t, getColumnArtuments1.get(0));
            assertEquals(0, getColumnArtuments1.get(1));
            List getColumnArtuments2 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 1);
            assertEquals(2, getColumnArtuments2.size());
            assertSame(t, getColumnArtuments2.get(0));
            assertEquals(1, getColumnArtuments2.get(1));
            List getColumnArtuments3 = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 2);
            assertEquals(2, getColumnArtuments3.size());
            assertSame(t, getColumnArtuments3.get(0));
            assertEquals(2, getColumnArtuments3.get(1));

            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals(1, writeArguments.size());
            String systemLineSeparator = System.getProperty("line.separator");

            String expectationResultData = null;

            // mavenNƂȂʂقȂ邽߁AmavenN͑zlύX
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                expectationResultData = "testPrintDataLine18_column1"
                        + "testPrintDataLine18_column2testPrintDataLine18_column3"
                        + systemLineSeparator;
            } else {
                expectationResultData = "testPrintDataLine18_column1,"
                        + "testPrintDataLine18_column2,testPrintDataLine18_column3"
                        + systemLineSeparator;
            }

            // System.out.println("========");
            // System.out.println(expectationResultData);
            // System.out.println("----");
            // System.out.println(writeArguments.get(0));
            // System.out.println("========");
            assertEquals("writeArguments.get(0)", expectationResultData,
                    writeArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));
            List setWriteDataArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "setWriteData", 0);
            assertEquals(1, setWriteDataArguments.size());
            assertTrue(Boolean.class.cast(setWriteDataArguments.get(0)));

            // (t@C)
            writer.flush();
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintTrailerLine01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() trailerLine:vfȂListCX^X<br>
     * () writeTailer:false<br>
     * <br>
     * ҒlF(ԕω) writeTrailer:true<br>
     * (ԕω) #printList():1Ă΂<br>
     * mFB<br>
     * <br>
     * P[X<br>
     * Ώۃf[^̏o͏s邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintTrailerLine01() throws Exception {
        // O(Ώ)
        String fileName = TEMP_FILE_NAME;

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);
        try {
            fileLineWriter.init();

            // O()
            List<String> trailerLine = new ArrayList<String>();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "writeTrailer",
                    Boolean.FALSE);

            // eXg{
            fileLineWriter.printTrailerLine(trailerLine);

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "printList"));
            List printListArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "printList", 0);
            assertSame(trailerLine, printListArguments.get(0));
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");
            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintList01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() stringList:ȉ̗vfListCX^X<br>
     * E"testPrintList01_data1"<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintList01.txt"<br>
     * () this.lineFeedChar:VXeftHgl<br>
     * () this.writer:this.fileNamet@Cɑ΂WriterCX^X<br>
     * ɃN[YĂB<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList01.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ҒlF(ԕω) writer#write():1Ă΂B<br>
     * mFB<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList01.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ωȂ<br>
     * (ԕω) -:ȉ̏FileException<br>
     * EbZ[WF"Processing of writer was failed."<br>
     * EOFIOException<br>
     * Et@CFfileNameƓCX^X<br>
     * <br>
     * ُP[X<br>
     * writerɃN[YĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintList01() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            List<String> stringList = new ArrayList<String>();
            stringList.add("testPrintList01_data1");

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", System
                    .getProperty("line.separator"));

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "printList",
                    new Class[] { List.class }, new Object[] { stringList });
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Processing of writer was failed.", e.getMessage());
            assertTrue(IOException.class.isAssignableFrom(e.getCause()
                    .getClass()));
            assertEquals(fileName, e.getFileName());

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments = VMOUTUtil.getArguments(Writer.class, "write",
                    0);
            assertEquals("testPrintList01_data1", writeArguments.get(0));

            // (t@C)
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintList02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() stringList:vfȂListCX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintList02.txt"<br>
     * () this.lineFeedChar:VXeftHgl<br>
     * () this.writer:this.fileNamet@Cɑ΂WriterCX^X<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList02.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ҒlF(ԕω) writer#write():Ă΂ȂB<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList02.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ωȂ<br>
     * <br>
     * P[XB<br>
     * o͑Ώۃf[^ȂꍇAo͂ȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintList02() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            List<String> stringList = new ArrayList<String>();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", System
                    .getProperty("line.separator"));

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "printList",
                    new Class[] { List.class }, new Object[] { stringList });

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(Writer.class, "write"));

            // (t@C)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.flush();

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintList03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() stringList:ȉ̗vfListCX^X<br>
     * E"testPrintList03_data1"<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintList03.txt"<br>
     * () this.lineFeedChar:VXeftHgl<br>
     * () this.writer:this.fileNamet@Cɑ΂WriterCX^X<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList03.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ҒlF(ԕω) writer#write():2Ă΂B<br>
     * mFB<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList03.txt"<br>
     * EeF"testPrintList03_data1<s؂蕶>"<br>
     * <br>
     * P[XB<br>
     * o͑Ώۃf[^PꍇÃf[^ƍs؂蕶o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintList03() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            List<String> stringList = new ArrayList<String>();
            stringList.add("testPrintList03_data1");

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", System
                    .getProperty("line.separator"));

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "printList",
                    new Class[] { List.class }, new Object[] { stringList });

            // (ԕωA\bh)
            assertEquals(2, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments1 = VMOUTUtil.getArguments(Writer.class,
                    "write", 0);
            assertEquals(1, writeArguments1.size());
            assertEquals("testPrintList03_data1", writeArguments1.get(0));
            List writeArguments2 = VMOUTUtil.getArguments(Writer.class,
                    "write", 1);
            assertEquals(1, writeArguments2.size());
            String systemLineSeparator = System.getProperty("line.separator");
            assertEquals(systemLineSeparator, writeArguments2.get(0));

            // (t@C)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.flush();

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String expectationResultData = "testPrintList03_data1"
                    + systemLineSeparator;
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintList04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD <br>
     * <br>
     * ͒lF() stringList:ȉ̗vfListCX^X<br>
     * E"testPrintList04_data1"<br>
     * E"testPrintList04_data2"<br>
     * E"testPrintList04_data3"<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintList04.txt"<br>
     * () this.lineFeedChar:VXeftHgl<br>
     * () this.writer:this.fileNamet@Cɑ΂WriterCX^X<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList04.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ҒlF(ԕω) writer#write():6Ă΂B<br>
     * mFB<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList03.txt"<br>
     * EeF"testPrintList04_data1<s؂蕶>testPrintList04_data2<s؂蕶>testPrintList04_data3<s؂蕶>"<br>
     * <br>
     * P[XB<br>
     * o͑Ώۃf[^3ꍇÃf[^ƍs؂蕶o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintList04() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            List<String> stringList = new ArrayList<String>();
            stringList.add("testPrintList04_data1");
            stringList.add("testPrintList04_data2");
            stringList.add("testPrintList04_data3");

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", System
                    .getProperty("line.separator"));

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "printList",
                    new Class[] { List.class }, new Object[] { stringList });

            // (ԕωA\bh)
            assertEquals(6, VMOUTUtil.getCallCount(Writer.class, "write"));
            List writeArguments1 = VMOUTUtil.getArguments(Writer.class,
                    "write", 0);
            assertEquals(1, writeArguments1.size());
            assertEquals("testPrintList04_data1", writeArguments1.get(0));
            List writeArguments2 = VMOUTUtil.getArguments(Writer.class,
                    "write", 1);
            assertEquals(1, writeArguments2.size());
            String systemLineSeparator = System.getProperty("line.separator");
            assertEquals(systemLineSeparator, writeArguments2.get(0));
            List writeArguments3 = VMOUTUtil.getArguments(Writer.class,
                    "write", 2);
            assertEquals(1, writeArguments3.size());
            assertEquals("testPrintList04_data2", writeArguments3.get(0));
            List writeArguments4 = VMOUTUtil.getArguments(Writer.class,
                    "write", 3);
            assertEquals(1, writeArguments4.size());
            assertEquals(systemLineSeparator, writeArguments4.get(0));
            List writeArguments5 = VMOUTUtil.getArguments(Writer.class,
                    "write", 4);
            assertEquals(1, writeArguments5.size());
            assertEquals("testPrintList04_data3", writeArguments5.get(0));
            List writeArguments6 = VMOUTUtil.getArguments(Writer.class,
                    "write", 5);
            assertEquals(1, writeArguments6.size());
            assertEquals(systemLineSeparator, writeArguments6.get(0));

            // (t@C)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.flush();

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String expectationResultData = "testPrintList04_data1"
                    + systemLineSeparator + "testPrintList04_data2"
                    + systemLineSeparator + "testPrintList04_data3"
                    + systemLineSeparator;
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testPrintList05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() stringList:null<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testPrintList05.txt"<br>
     * () this.lineFeedChar:VXeftHgl<br>
     * () this.writer:this.fileNamet@Cɑ΂WriterCX^X<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList05.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ҒlF(ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testPrintList02.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ωȂ<br>
     * (ԕω) -:NullPointerException<br>
     * <br>
     * ُP[X<br>
     * null̏ꍇ͗O邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPrintList05() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O()
            List<String> stringList = null;

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", System
                    .getProperty("line.separator"));

            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // eXg{
            UTUtil.invokePrivate(fileLineWriter, "printList",
                    new Class[] { List.class }, new Object[] { stringList });
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // (O)
            assertTrue(NullPointerException.class
                    .isAssignableFrom(e.getClass()));

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(Writer.class, "write"));

            // (t@C)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.flush();

            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testCloseFile01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testCloseFile01.txt"<br>
     * () this.writer:this.fileNamet@Cɑ΂WriterCX^X<br>
     * ɃN[YĂB<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testCloseFile01.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ҒlF(ԕω) writer#flush():1Ă΂B<br>
     * (ԕω) writer#close():Ă΂ȂB<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testCloseFile01.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ωȂ<br>
     * (ԕω) FileException:ȉ̏FileException<br>
     * EbZ[WF"Closing of writer was failed."<br>
     * EOFIOException<br>
     * Et@CFfileNameƓCX^X<br>
     * <br>
     * ُP[X<br>
     * writerɃN[YĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testCloseFile01() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O(tB[h)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.close();

            // eXg{
            fileLineWriter.closeFile();
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Closing of writer was failed.", e.getMessage());
            assertTrue(IOException.class.isAssignableFrom(e.getCause()
                    .getClass()));
            assertEquals(fileName, e.getFileName());

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "flush"));

            assertFalse(VMOUTUtil.isCalled(Writer.class, "write"));

            // (t@C)
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertFalse(postReader.ready());
        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testCloseFile02() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testCloseFile02.txt"<br>
     * () this.writer:this.fileNamet@Cɑ΂WriterCX^X<br>
     * o̓f[^ƂĈȉ̃f[^ĂB<br>
     * E"testCloseFile02_data1"<br>
     * () t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testCloseFile02.txt"<br>
     * EeȂ(0Byte)<br>
     * <br>
     * ҒlF(ԕω) writer#flush():1Ă΂B<br>
     * (ԕω) writer#close():1Ă΂B<br>
     * (ԕω) t@C:NXpXɈȉ̃t@C݂B<br>
     * "AbstractFileLineWriter_testCloseFile02.txt"<br>
     * EeF"testCloseFile02_data1"<br>
     * <br>
     * P[X<br>
     * writerɐݒ肳ꂽSĂ̏񂪃t@Cɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testCloseFile02() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub10> clazz = AbstractFileLineWriter_Stub10.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub10> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub10>(
                fileName, clazz, columnFormatterMap);

        Reader postReader = null;
        Writer writer = null;
        try {
            fileLineWriter.init();

            // O(tB[h)
            writer = (Writer) UTUtil.getPrivateField(fileLineWriter, "writer");
            writer.write("testCloseFile02_data1");

            // eXg{
            fileLineWriter.closeFile();

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "flush"));

            assertFalse(VMOUTUtil.isCalled(Writer.class, "write"));

            // (t@C)
            postReader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertTrue(postReader.ready());

            String expectationResultData = "testCloseFile02_data1";
            String data = "";
            for (int i = 0; i < expectationResultData.length(); i++) {
                assertTrue(i + "ڂ̔Ŏs܂B", postReader.ready());
                data += (char) postReader.read();
            }
            assertEquals(expectationResultData, data);
            assertFalse(postReader.ready());

        } finally {
            if (writer != null) {
                writer.close();
            }

            if (postReader != null) {
                postReader.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn01_data1"<br>
     * Ecolumn2F"testGetColumn01_data2"<br>
     * Ecolumn3F"testGetColumn01_data3"<br>
     * () index:1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn01.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():false<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():ُI<br>
     *                         IllegalAccessExceptionB<br>
     * <br>
     *                         ҒlF(ԕω) FileDAOUtility#trim():Ă΂Ȃ<br>
     *                         (ԕω) FileDAOUtility#padding():Ă΂Ȃ<br>
     *                         (ԕω) StringConverter#convert():Ă΂Ȃ<br>
     *                         (ԕω) #isCheckByte():Ă΂Ȃ<br>
     *                         (ԕω) -:ȉ̏FileLineException<br>
     *                         EbZ[WF"Failed in column data formatting."<br>
     *                         EOFIllegalAccessException<br>
     *                         Et@CFthis.fileNameƓCX^X<br>
     *                         EsF1<br>
     *                         EJFcolumn2<br>
     *                         EJԍ:1<br>
     * <br>
     *                         ُP[X<br>
     *                         t@CsIuWFNgf[^擾鏈IlleageAccessExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn01() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn01_data1");
        t.setColumn2("testGetColumn01_data2");
        t.setColumn3("testGetColumn01_data3");

        int index = 1;
        IllegalAccessException illegalAccessException = new IllegalAccessException(
                "testGetColumn01O");
        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.FALSE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn01_data2_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn01_data2_trim()_padding()");

            VMOUTUtil.setExceptionAtAllTimes(NullColumnFormatter.class,
                    "format", illegalAccessException);

            // eXg{
            fileLineWriter.getColumn(t, index);
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals("Failed in column data formatting.", e.getMessage());
            assertSame(illegalAccessException, e.getCause());
            assertEquals(fileName, e.getFileName());
            assertEquals(1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals(1, e.getColumnIndex());

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(FileDAOUtility.class, "trim"));

            assertFalse(VMOUTUtil.isCalled(FileDAOUtility.class, "padding"));

            assertFalse(VMOUTUtil.isCalled(
                    AbstractFileLineWriter_StringConverterStub03.class,
                    "convert"));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "isCheckByte"));
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn02_data1"<br>
     * Ecolumn2F"testGetColumn02_data2"<br>
     * Ecolumn3F"testGetColumn02_data3"<br>
     * () index:1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn02.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():false<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():ُI<br>
     *                         llegalArgumentExceptionB<br>
     * <br>
     *                         ҒlF(ԕω) FileDAOUtility#trim():Ă΂Ȃ<br>
     *                         (ԕω) FileDAOUtility#padding():Ă΂Ȃ<br>
     *                         (ԕω) StringConverter#convert():Ă΂Ȃ<br>
     *                         (ԕω) #isCheckByte():Ă΂Ȃ<br>
     *                         (ԕω) -:ȉ̏FileLineException<br>
     *                         EbZ[WF"Failed in column data formatting."<br>
     *                         EOFIllegalArgumentException<br>
     *                         Et@CFthis.fileNameƓCX^X<br>
     *                         EsF1<br>
     *                         EJFcolumn2<br>
     *                         EJԍ:1<br>
     * <br>
     *                         ُP[X<br>
     *                         t@CsIuWFNgf[^擾鏈illegalArgumentExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn02() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn02_data1");
        t.setColumn2("testGetColumn02_data2");
        t.setColumn3("testGetColumn02_data3");

        int index = 1;
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(
                "testGetColumn02O");
        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.FALSE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn02_data2_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn02_data2_trim()_padding()");

            VMOUTUtil.setExceptionAtAllTimes(NullColumnFormatter.class,
                    "format", illegalArgumentException);

            // eXg{
            fileLineWriter.getColumn(t, index);
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals("Failed in column data formatting.", e.getMessage());
            assertSame(illegalArgumentException, e.getCause());
            assertEquals(fileName, e.getFileName());
            assertEquals(1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals(1, e.getColumnIndex());

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(FileDAOUtility.class, "trim"));

            assertFalse(VMOUTUtil.isCalled(FileDAOUtility.class, "padding"));

            assertFalse(VMOUTUtil.isCalled(
                    AbstractFileLineWriter_StringConverterStub03.class,
                    "convert"));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "isCheckByte"));
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn03_data1"<br>
     * Ecolumn2F"testGetColumn03_data2"<br>
     * Ecolumn3F"testGetColumn03_data3"<br>
     * () index:1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn03.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():false<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():ُI<br>
     *                         InvocationTargetExceptionB<br>
     * <br>
     *                         ҒlF(ԕω) FileDAOUtility#trim():Ă΂Ȃ<br>
     *                         (ԕω) FileDAOUtility#padding():Ă΂Ȃ<br>
     *                         (ԕω) StringConverter#convert():Ă΂Ȃ<br>
     *                         (ԕω) #isCheckByte():Ă΂Ȃ<br>
     *                         (ԕω) -:ȉ̏FileLineException<br>
     *                         EbZ[WF"Failed in column data formatting."<br>
     *                         EOFInvocationTargetException<br>
     *                         Et@CFthis.fileNameƓCX^X<br>
     *                         EsF1<br>
     *                         EJFcolumn2<br>
     *                         EJԍ:1<br>
     * <br>
     *                         ُP[X<br>
     *                         t@CsIuWFNgf[^擾鏈InvocationTargetExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn03() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn03_data1");
        t.setColumn2("testGetColumn03_data2");
        t.setColumn3("testGetColumn03_data3");

        int index = 1;
        InvocationTargetException invocationTargetException = new InvocationTargetException(
                new Exception("testGetColumn03O"));
        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.FALSE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn03_data2_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn03_data2_trim()_padding()");

            VMOUTUtil.setExceptionAtAllTimes(NullColumnFormatter.class,
                    "format", invocationTargetException);

            // eXg{
            fileLineWriter.getColumn(t, index);
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals("Failed in column data formatting.", e.getMessage());
            assertSame(invocationTargetException, e.getCause());
            assertEquals(fileName, e.getFileName());
            assertEquals(1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals(1, e.getColumnIndex());

            // (ԕωA\bh)
            assertFalse(VMOUTUtil.isCalled(FileDAOUtility.class, "trim"));

            assertFalse(VMOUTUtil.isCalled(FileDAOUtility.class, "padding"));

            assertFalse(VMOUTUtil.isCalled(
                    AbstractFileLineWriter_StringConverterStub03.class,
                    "convert"));

            assertFalse(VMOUTUtil.isCalled(AbstractFileLineWriter.class,
                    "isCheckByte"));
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn04_data1"<br>
     * Ecolumn2F"testGetColumn04_data2XX"(bytesݒƍȂf[^)<br>
     * Ecolumn3F"testGetColumn04_data3"<br>
     * () index:1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn04.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():true<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():I<br>
     *                         tB[h̏ԂB<br>
     * <br>
     *                         ҒlF(ԕω) FileDAOUtility#trim():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) FileDAOUtility#padding():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) StringConverter#convert():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #isCheckByte():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) -:ȉ̏FileLineException<br>
     *                         EbZ[WF"The data size is different from bytes value of the set value of the column ."<br>
     *                         EOFIllegalStateException<br>
     *                         Et@CFthis.fileNameƓCX^X<br>
     *                         EsF1<br>
     *                         EJFcolumn2<br>
     *                         EJԍ:1<br>
     * <br>
     *                         ُP[X<br>
     *                         (oCg`FbN)<br>
     *                         擾ΏۃtB[hl̃oCgAme[V̐ݒlƈقȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn04() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn04_data1");
        t.setColumn2("testGetColumn04_data2XX");
        t.setColumn3("testGetColumn04_data3");

        int index = 1;

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.TRUE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn04_data2XX_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn04_data2XX_trim()_padding()");

            // eXg{
            fileLineWriter.getColumn(t, index);
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals("The data size is different from bytes value of the "
                    + "set value of the column .", e.getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals("getColumnIndex", 1, e.getColumnIndex());

            // (ԕωA\bh)
            assertEquals("FileDAOUtility", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "trim"));
            List trimArguments = VMOUTUtil.getArguments(FileDAOUtility.class,
                    "trim", 0);
            assertEquals(4, trimArguments.size());
            assertEquals("testGetColumn04_data2XX", trimArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), trimArguments
                    .get(1));
            assertEquals(' ', trimArguments.get(2));
            assertEquals(TrimType.NONE, trimArguments.get(3));

            assertEquals("FileDAOUtility", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "padding"));
            List paddingArguments = VMOUTUtil.getArguments(
                    FileDAOUtility.class, "padding", 0);
            assertEquals(5, paddingArguments.size());
            assertEquals("testGetColumn04_data2XX_trim()", paddingArguments
                    .get(0));
            assertEquals(System.getProperty("file.encoding"), paddingArguments
                    .get(1));
            assertEquals(48, paddingArguments.get(2));
            assertEquals(' ', paddingArguments.get(3));
            assertEquals(PaddingType.NONE, paddingArguments.get(4));

            // mavenNƂȂconvert擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals(
                        "AbstractFileLineWriter_StringConverterStub03",
                        1,
                        VMOUTUtil
                                .getCallCount(
                                        AbstractFileLineWriter_StringConverterStub03.class,
                                        "convert"));
                List convertArguments = VMOUTUtil.getArguments(
                        AbstractFileLineWriter_StringConverterStub03.class,
                        "convert", 0);
                assertEquals("convertArguments", 1, convertArguments.size());
                assertEquals("testGetColumn04_data2XX_trim()_padding()",
                        convertArguments.get(0));
            }

            assertEquals("isCheckByte", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "isCheckByte"));
            List isCheckByteArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "isCheckByte", 0);
            assertEquals("isCheckByteArguments", 1, isCheckByteArguments.size());

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn05_data1"<br>
     * Ecolumn2F"testGetColumn05_data2"<br>
     * Ecolumn3F"testGetColumn05_data3"<br>
     * () index:1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn05.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():true<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():I<br>
     *                         tB[h̏ԂB<br>
     *                         () String#getBytes():ُI<br>
     *                         UnsupportedEncodingExceptionB<br>
     * <br>
     *                         ҒlF(ԕω) FileDAOUtility#trim():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) FileDAOUtility#padding():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) StringConverter#convert():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #isCheckByte():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) -:ȉ̏FileException<br>
     *                         EbZ[WF"fileEncoding which isn't supported was set."<br>
     *                         EOFUnsupportedEncodingException<br>
     *                         Et@CFthis.fileNameƓCX^X<br>
     * <br>
     *                         ُP[X<br>
     *                         (oCg`FbN)<br>
     *                         擾ΏۃtB[hl̃oCg`FbNUnsupportedEncodingExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn05() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn05_data1");
        t.setColumn2("testGetColumn05_data2");
        t.setColumn3("testGetColumn05_data3");

        int index = 1;

        UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(
                "testGetColumn05O");

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.TRUE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn05_data2_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn05_data2_trim()_padding()");

            VMOUTUtil.setExceptionAt(String.class, "getBytes", 0,
                    unsupportedEncodingException);

            // eXg{
            fileLineWriter.getColumn(t, index);
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("fileEncoding which isn't supported was set.", e
                    .getMessage());
            assertSame(unsupportedEncodingException, e.getCause());
            assertEquals(fileName, e.getFileName());

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            List trimArguments = VMOUTUtil.getArguments(FileDAOUtility.class,
                    "trim", 0);
            assertEquals(4, trimArguments.size());
            assertEquals("testGetColumn05_data2", trimArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), trimArguments
                    .get(1));
            assertEquals(' ', trimArguments.get(2));
            assertEquals(TrimType.NONE, trimArguments.get(3));

            assertEquals(1, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            List paddingArguments = VMOUTUtil.getArguments(
                    FileDAOUtility.class, "padding", 0);
            assertEquals(5, paddingArguments.size());
            assertEquals("testGetColumn05_data2_trim()", paddingArguments
                    .get(0));
            assertEquals(System.getProperty("file.encoding"), paddingArguments
                    .get(1));
            assertEquals(48, paddingArguments.get(2));
            assertEquals(' ', paddingArguments.get(3));
            assertEquals(PaddingType.NONE, paddingArguments.get(4));

            // mavenNƂȂconvert擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals(
                        "AbstractFileLineWriter_StringConverterStub03",
                        1,
                        VMOUTUtil
                                .getCallCount(
                                        AbstractFileLineWriter_StringConverterStub03.class,
                                        "convert"));
                List convertArguments = VMOUTUtil.getArguments(
                        AbstractFileLineWriter_StringConverterStub03.class,
                        "convert", 0);
                assertEquals(1, convertArguments.size());
                assertEquals("testGetColumn05_data2_trim()_padding()",
                        convertArguments.get(0));
            }

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "isCheckByte"));
            List isCheckByteArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "isCheckByte", 0);
            assertEquals(1, isCheckByteArguments.size());

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn06() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn06_data1"<br>
     * Ecolumn2Fnull<br>
     * Ecolumn3F"testGetColumn06_data3"<br>
     * () index:1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn06.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=ȉ̏ColumnFormatter̃NXCX^X<br>
     *                         - KnullԂB<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():false<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():I<br>
     *                         nullԂB<br>
     * <br>
     *                         ҒlF(߂l) String:"_trim()_padding()_convert()"<br>
     *                         (ԕω) FileDAOUtility#trim():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) FileDAOUtility#padding():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) StringConverter#convert():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #isCheckByte():1Ă΂<br>
     *                         mFB<br>
     * <br>
     *                         P[X<br>
     *                         (oCg`FbNȂ)<br>
     *                         ColumnFormmater#format()̌ʁAtB[hlnull̏ꍇA󕶎Ƃď邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn06() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String",
                new AbstractFileLineWriter_ColumnFormatterStub01());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn06_data1");
        t.setColumn2(null);
        t.setColumn3("testGetColumn06_data3");

        int index = 1;

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.FALSE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "_trim()_padding()");

            // eXg{
            String result = fileLineWriter.getColumn(t, index);

            // (߂l)
            assertNotNull(result);
            assertEquals("_trim()_padding()_convert()", result);

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            List trimArguments = VMOUTUtil.getArguments(FileDAOUtility.class,
                    "trim", 0);
            assertEquals(4, trimArguments.size());
            assertEquals("", trimArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), trimArguments
                    .get(1));
            assertEquals(' ', trimArguments.get(2));
            assertEquals(TrimType.NONE, trimArguments.get(3));

            assertEquals(1, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            List paddingArguments = VMOUTUtil.getArguments(
                    FileDAOUtility.class, "padding", 0);
            assertEquals(5, paddingArguments.size());
            assertEquals("_trim()", paddingArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), paddingArguments
                    .get(1));
            assertEquals(48, paddingArguments.get(2));
            assertEquals(' ', paddingArguments.get(3));
            assertEquals(PaddingType.NONE, paddingArguments.get(4));

            // mavenNƂȂconvert擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals(
                        "AbstractFileLineWriter_StringConverterStub03",
                        1,
                        VMOUTUtil
                                .getCallCount(
                                        AbstractFileLineWriter_StringConverterStub03.class,
                                        "convert"));
                List convertArguments = VMOUTUtil.getArguments(
                        AbstractFileLineWriter_StringConverterStub03.class,
                        "convert", 0);
                assertEquals(1, convertArguments.size());
                assertEquals("_trim()_padding()", convertArguments.get(0));
            }

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "isCheckByte"));
            List isCheckByteArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "isCheckByte", 0);
            assertEquals(1, isCheckByteArguments.size());

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn07() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn07_data1"<br>
     * Ecolumn2F""(󕶎)<br>
     * Ecolumn3F"testGetColumn07_data3"<br>
     * () index:0<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn07.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():false<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():I<br>
     *                         tB[h̏ԂB<br>
     * <br>
     *                         ҒlF(߂l) String:"_trim()_padding()_convert()"<br>
     *                         (ԕω) FileDAOUtility#trim():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) FileDAOUtility#padding():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) StringConverter#convert():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #isCheckByte():1Ă΂<br>
     *                         mFB<br>
     * <br>
     *                         P[X<br>
     *                         (oCg`FbNȂ)<br>
     *                         ColumnFormmater#format()̌ʁAtB[hl󕶎̏ꍇÂ܂܏邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn07() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String",
                new AbstractFileLineWriter_ColumnFormatterStub01());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn07_data1");
        t.setColumn2("");
        t.setColumn3("testGetColumn07_data3");

        int index = 1;

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.FALSE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "_trim()_padding()");

            // eXg{
            String result = fileLineWriter.getColumn(t, index);

            // (߂l)
            assertNotNull(result);
            assertEquals("_trim()_padding()_convert()", result);

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            List trimArguments = VMOUTUtil.getArguments(FileDAOUtility.class,
                    "trim", 0);
            assertEquals(4, trimArguments.size());
            assertEquals("", trimArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), trimArguments
                    .get(1));
            assertEquals(' ', trimArguments.get(2));
            assertEquals(TrimType.NONE, trimArguments.get(3));

            assertEquals(1, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            List paddingArguments = VMOUTUtil.getArguments(
                    FileDAOUtility.class, "padding", 0);
            assertEquals(5, paddingArguments.size());
            assertEquals("_trim()", paddingArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), paddingArguments
                    .get(1));
            assertEquals(48, paddingArguments.get(2));
            assertEquals(' ', paddingArguments.get(3));
            assertEquals(PaddingType.NONE, paddingArguments.get(4));

            // mavenNƂȂconvert擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals(
                        "AbstractFileLineWriter_StringConverterStub03",
                        1,
                        VMOUTUtil
                                .getCallCount(
                                        AbstractFileLineWriter_StringConverterStub03.class,
                                        "convert"));
                List convertArguments = VMOUTUtil.getArguments(
                        AbstractFileLineWriter_StringConverterStub03.class,
                        "convert", 0);
                assertEquals(1, convertArguments.size());
                assertEquals("_trim()_padding()", convertArguments.get(0));
            }

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "isCheckByte"));
            List isCheckByteArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "isCheckByte", 0);
            assertEquals(1, isCheckByteArguments.size());

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn09() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,F <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn09_data1"<br>
     * Ecolumn2F"testGetColumn09_data2"<br>
     * Ecolumn3F"testGetColumn09_data3"<br>
     * () index:0<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn09.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF48<br>
     *                         > stringConverterFȉ̏StringConverter̃NXCX^X<br>
     *                         - ͂ꂽf[^"_convert()"ǉʂԂB<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > bytesF48<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():false<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():I<br>
     *                         tB[h̏ԂB<br>
     * <br>
     *                         ҒlF(߂l) String:"testGetColumn09_data2_trim()_padding()_convert()"<br>
     *                         (ԕω) FileDAOUtility#trim():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) FileDAOUtility#padding():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) StringConverter#convert():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #isCheckByte():1Ă΂<br>
     *                         mFB<br>
     * <br>
     *                         P[X<br>
     *                         (oCg`FbN)<br>
     *                         擾ΏۃtB[hl̃oCgAme[V̐ݒlƈvꍇAȂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn09() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub35> clazz = AbstractFileLineWriter_Stub35.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub35> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub35>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub35 t = new AbstractFileLineWriter_Stub35();
        t.setColumn1("testGetColumn09_data1");
        t.setColumn2("testGetColumn09_data2");
        t.setColumn3("testGetColumn09_data3");

        int index = 1;

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.TRUE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn09_data2_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn09_data2_trim()_padding()");

            // eXg{
            String result = fileLineWriter.getColumn(t, index);

            // (߂l)
            assertNotNull(result);
            assertEquals("testGetColumn09_data2_trim()_padding()_convert()",
                    result);

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            List trimArguments = VMOUTUtil.getArguments(FileDAOUtility.class,
                    "trim", 0);
            assertEquals(4, trimArguments.size());
            assertEquals("testGetColumn09_data2", trimArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), trimArguments
                    .get(1));
            assertEquals(' ', trimArguments.get(2));
            assertEquals(TrimType.NONE, trimArguments.get(3));

            assertEquals(1, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            List paddingArguments = VMOUTUtil.getArguments(
                    FileDAOUtility.class, "padding", 0);
            assertEquals(5, paddingArguments.size());
            assertEquals("testGetColumn09_data2_trim()", paddingArguments
                    .get(0));
            assertEquals(System.getProperty("file.encoding"), paddingArguments
                    .get(1));
            assertEquals(48, paddingArguments.get(2));
            assertEquals(' ', paddingArguments.get(3));
            assertEquals(PaddingType.NONE, paddingArguments.get(4));

            // mavenNƂȂconvert擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals(
                        "AbstractFileLineWriter_StringConverterStub03",
                        1,
                        VMOUTUtil
                                .getCallCount(
                                        AbstractFileLineWriter_StringConverterStub03.class,
                                        "convert"));
                List convertArguments = VMOUTUtil.getArguments(
                        AbstractFileLineWriter_StringConverterStub03.class,
                        "convert", 0);
                assertEquals(1, convertArguments.size());
                assertEquals("testGetColumn09_data2_trim()_padding()",
                        convertArguments.get(0));
            }

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "isCheckByte"));
            List isCheckByteArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "isCheckByte", 0);
            assertEquals(1, isCheckByteArguments.size());

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn10_data1"<br>
     * Ecolumn2F"testGetColumn10_data2"<br>
     * Ecolumn3F"testGetColumn10_data3"<br>
     * () index:0<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn10.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():true<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():I<br>
     *                         tB[h̏ԂB<br>
     * <br>
     *                         ҒlF(ԕω) FileDAOUtility#trim():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) FileDAOUtility#padding():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) StringConverter#convert():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #isCheckByte():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) -:ȉ̏FileLineException<br>
     *                         EbZ[WF"bytes is not set or a number equal to or less than 0 is set."<br>
     *                         EOFIllegalStateException<br>
     *                         Et@CFthis.fileNameƓCX^X<br>
     *                         EsF1<br>
     *                         EJFcolumn2<br>
     *                         EJԍ:1<br>
     * <br>
     *                         ُP[X<br>
     *                         (oCg`FbN)<br>
     *                         ΏۃtB[hɑ΂ăoCg}CiXl(ftHglȂ)Őݒ肳ĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn10() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub13> clazz = AbstractFileLineWriter_Stub13.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub13> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub13>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub13 t = new AbstractFileLineWriter_Stub13();
        t.setColumn1("testGetColumn10_data1");
        t.setColumn2("testGetColumn10_data2");
        t.setColumn3("testGetColumn10_data3");

        int index = 1;

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.TRUE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn10_data2_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn10_data2_trim()_padding()");

            // eXg{
            fileLineWriter.getColumn(t, index);
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals(
                    "bytes is not set or a number equal to or less than 0 "
                            + "is set.", e.getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
            assertEquals(1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals(1, e.getColumnIndex());

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            List trimArguments = VMOUTUtil.getArguments(FileDAOUtility.class,
                    "trim", 0);
            assertEquals(4, trimArguments.size());
            assertEquals("testGetColumn10_data2", trimArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), trimArguments
                    .get(1));
            assertEquals(' ', trimArguments.get(2));
            assertEquals(TrimType.NONE, trimArguments.get(3));

            assertEquals(1, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            List paddingArguments = VMOUTUtil.getArguments(
                    FileDAOUtility.class, "padding", 0);
            assertEquals(5, paddingArguments.size());
            assertEquals("testGetColumn10_data2_trim()", paddingArguments
                    .get(0));
            assertEquals(System.getProperty("file.encoding"), paddingArguments
                    .get(1));
            assertEquals(-1, paddingArguments.get(2));
            assertEquals(' ', paddingArguments.get(3));
            assertEquals(PaddingType.NONE, paddingArguments.get(4));

            assertEquals(1, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            List convertArguments = VMOUTUtil.getArguments(
                    NullStringConverter.class, "convert", 0);
            assertEquals(1, convertArguments.size());
            assertEquals("testGetColumn10_data2_trim()_padding()",
                    convertArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "isCheckByte"));
            List isCheckByteArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "isCheckByte", 0);
            assertEquals(1, isCheckByteArguments.size());

        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetColumn11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏this.clazz̃CX^X<br>
     * Ecolumn1F"testGetColumn11_data1"<br>
     * Ecolumn2F"testGetColumn11_data2"<br>
     * Ecolumn3F"testGetColumn11_data3"<br>
     * () index:0<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineWriter_testGetColumn11.txt"<br>
     * () this.clazz:ȉ̐ݒClassCX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@OutputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @OutputFileColumnݒ<br> > columnIndexF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column2<br>
     * @OutputFileColumnݒ<br> > columnIndexF1<br>
     *                         > bytesF0<br>
     *                         > ̑ځFftHgl<br>
     *                         - tB[hFString column3<br>
     * @OutputFileColumnݒ<br> > columnIndexF2<br>
     *                         > ̑ځFftHgl<br>
     *                         EetB[hgetter/setter\bhB<br>
     *                         () this.fields:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.methods:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.stringConverters:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     *                         E"int"=IntColumnFormatter<br>
     *                         E"java.lang.String"=NullColumnFormatter<br>
     *                         E"java.util.Date"=DateColumnFormatter<br>
     *                         E"java.math.BigDecimal"=DecimalColumnFormatter<br>
     *                         () this.fileEncoding:this.clazz̃tB[h`ɏ]B<br>
     *                         () this.currentLineCount:0<br>
     *                         () #isCheckByte():true<br>
     *                         () FileDAOUtility#trim():I<br>
     *                         ͂ꂽf[^"_trim()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () FileDAOUtility#padding():I<br>
     *                         ͂ꂽf[^"_padding()"ǉʂԂB<br>
     * <br>
     *                         mF̂<br>
     *                         () ColumnFormatter#format():I<br>
     *                         tB[h̏ԂB<br>
     * <br>
     *                         ҒlF(ԕω) FileDAOUtility#trim():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) FileDAOUtility#padding():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) StringConverter#convert():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) #isCheckByte():1Ă΂<br>
     *                         mFB<br>
     *                         (ԕω) -:ȉ̏FileLineException<br>
     *                         EbZ[WF"bytes is not set or a number equal to or less than 0 is set."<br>
     *                         EOFIllegalStateException<br>
     *                         Et@CFthis.fileNameƓCX^X<br>
     *                         EsF1<br>
     *                         EJFcolumn2<br>
     *                         EJԍ:1<br>
     * <br>
     *                         ُP[X<br>
     *                         (oCg`FbN)<br>
     *                         ΏۃtB[hɑ΂ăoCg0Őݒ肳ĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn11() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;
        // O(Ώ)
        Class<AbstractFileLineWriter_Stub36> clazz = AbstractFileLineWriter_Stub36.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        columnFormatterMap.put("java.util.Date", new DateColumnFormatter());
        columnFormatterMap.put("java.math.BigDecimal",
                new DecimalColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub36> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub36>(
                fileName, clazz, columnFormatterMap);

        // O()
        AbstractFileLineWriter_Stub36 t = new AbstractFileLineWriter_Stub36();
        t.setColumn1("testGetColumn11_data1");
        t.setColumn2("testGetColumn11_data2");
        t.setColumn3("testGetColumn11_data3");

        int index = 1;

        try {
            fileLineWriter.init();

            // O(tB[h)
            UTUtil.setPrivateField(fileLineWriter, "currentLineCount", 0);

            // O(\bh)
            VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineWriter.class,
                    "isCheckByte", Boolean.TRUE);

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "trim", 0,
                    "testGetColumn11_data2_trim()");

            VMOUTUtil.setReturnValueAt(FileDAOUtility.class, "padding", 0,
                    "testGetColumn11_data2_trim()_padding()");

            // eXg{
            fileLineWriter.getColumn(t, index);
            fail("FileLineException܂łB");
        } catch (FileLineException e) {
            // (O)
            assertTrue(FileLineException.class.isAssignableFrom(e.getClass()));
            assertEquals(
                    "bytes is not set or a number equal to or less than 0 "
                            + "is set.", e.getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
            assertEquals(1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals(1, e.getColumnIndex());

            // (ԕωA\bh)
            assertEquals(1, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            List trimArguments = VMOUTUtil.getArguments(FileDAOUtility.class,
                    "trim", 0);
            assertEquals(4, trimArguments.size());
            assertEquals("testGetColumn11_data2", trimArguments.get(0));
            assertEquals(System.getProperty("file.encoding"), trimArguments
                    .get(1));
            assertEquals(' ', trimArguments.get(2));
            assertEquals(TrimType.NONE, trimArguments.get(3));

            assertEquals(1, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            List paddingArguments = VMOUTUtil.getArguments(
                    FileDAOUtility.class, "padding", 0);
            assertEquals(5, paddingArguments.size());
            assertEquals("testGetColumn11_data2_trim()", paddingArguments
                    .get(0));
            assertEquals(System.getProperty("file.encoding"), paddingArguments
                    .get(1));
            assertEquals(0, paddingArguments.get(2));
            assertEquals(' ', paddingArguments.get(3));
            assertEquals(PaddingType.NONE, paddingArguments.get(4));

            assertEquals(1, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            List convertArguments = VMOUTUtil.getArguments(
                    NullStringConverter.class, "convert", 0);
            assertEquals(1, convertArguments.size());
            assertEquals("testGetColumn11_data2_trim()_padding()",
                    convertArguments.get(0));

            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "isCheckByte"));
            List isCheckByteArguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "isCheckByte", 0);
            assertEquals(1, isCheckByteArguments.size());
        } finally {
            Writer writer = (Writer) UTUtil.getPrivateField(fileLineWriter,
                    "writer");

            if (writer != null) {
                writer.close();
            }

            UTUtil.setPrivateField(AbstractFileLineWriter.class,
                    "stringConverterCacheMap",
                    new HashMap<Class, StringConverter>());
        }
    }

    /**
     * testGetFileName01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() fileName:not null<br>
     * <br>
     * ҒlF(߂l) fileName:not null<br>
     * <br>
     * fileNamegetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetFileName01() throws Exception {
        // O()
        String fileName = "fileName";

        // O(Ώ)
        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "fileName", fileName);

        // eXg{
        String result = fileLineWriter.getFileName();

        // (߂l)
        assertNotNull(result);
        assertSame(fileName, result);
    }

    /**
     * testGetLineFeedChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.lineFeedChar:not null<br>
     * <br>
     * ҒlF(߂l) lineFeedChar:not null<br>
     * <br>
     * lineFeedChargetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testGetLineFeedChar01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);
        // O()
        String lineFeedChar = "testGetLineFeedChar01_lineFeedChar";

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", lineFeedChar);

        // eXg{
        String result = fileLineWriter.getLineFeedChar();

        // (߂l)
        assertNotNull(result);
        assertSame(lineFeedChar, result);
    }

    /**
     * testSetColumnFormatterMap01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() columnFormatterMap:not null<br>
     * <br>
     * ҒlF(ԕω) columnFormatterMap:not null<br>
     * <br>
     * columnFormatterMapsetter\bh̒lݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testSetColumnFormatterMap01() throws Exception {
        // O()
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "columnFormatterMap", null);

        // eXg{
        fileLineWriter.setColumnFormatterMap(columnFormatterMap);

        // (ԕωAtB[h)
        Map<String, ColumnFormatter> resultMap = (Map<String, ColumnFormatter>) UTUtil
                .getPrivateField(fileLineWriter, "columnFormatterMap");
        assertNotNull(resultMap);
        assertSame(columnFormatterMap, resultMap);
    }

    /**
     * testGetWriter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.writer:not null<br>
     * <br>
     * ҒlF(߂l) writer:not null<br>
     * <br>
     * writergetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testGetWriter01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(
                    (new FileOutputStream(fileName, true)), System
                            .getProperty("file.encoding")));

            UTUtil.setPrivateField(fileLineWriter, "writer", writer);
            // eXg{
            Writer result = fileLineWriter.getWriter();

            // (߂l)
            assertNotNull(result);
            assertSame(writer, result);
        } finally {
            if (writer != null) {
                writer.close();
            }
            // 㐶t@C̍폜
            File file = new File(fileName);
            file.delete();
        }
    }

    /**
     * testGetFields01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.fields:not null<br>
     * <br>
     * ҒlF(߂l) fields:not null<br>
     * <br>
     * fieldsgetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    @Test
    public void testGetFields01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        Field[] fields = new Field[] { null, null, null };
        UTUtil.setPrivateField(fileLineWriter, "fields", fields);

        // eXg{
        Field[] result = fileLineWriter.getFields();

        // (߂l)
        assertNotNull(result);
        assertSame(fields, result);
    }

    /**
     * testGetMethods01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.getMethods:not null<br>
     * <br>
     * ҒlF(߂l) methods:not null<br>
     * <br>
     * methodsgetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetMethods01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        Method[] methods = new Method[] { null, null, null };
        UTUtil.setPrivateField(fileLineWriter, "methods", methods);

        // eXg{
        Method[] result = fileLineWriter.getMethods();

        // (߂l)
        assertNotNull(result);
        assertSame(methods, result);
    }

    /**
     * testSetWriteData01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() writeData:true<br>
     * () this.writeData:false<br>
     * <br>
     * ҒlF(ԕω) writeData:true<br>
     * <br>
     * writeDatasetter\bh̒lݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testSetWriteData01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "writeData", Boolean.FALSE);

        // eXg{
        fileLineWriter.setWriteData(true);

        // (ԕωAtB[h)
        boolean resultBoolean = Boolean.class.cast(UTUtil.getPrivateField(
                fileLineWriter, "writeData"));
        assertNotNull(resultBoolean);
        assertTrue(resultBoolean);
    }

    /**
     * testCheckWriteTrailer01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() this.isWriteTrailer:false<br>
     * <br>
     * ҒlF <br>
     * gCo͂ĂȂƂ͉Ȃ <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testCheckWriteTrailer01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "writeTrailer", Boolean.FALSE);

        // eXg{
        try {
            fileLineWriter.checkWriteTrailer();
        } catch (FileException e) {
            // 
            fail("FileExceptionO܂B");

        }
    }

    /**
     * testCheckWriteTrailer02() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() this.isWriteTrailer:true<br>
     * <br>
     * ҒlF(ԕω) -:FileException<br>
     * OFIllegalStateException<br>
     * t@C͒lfileNameɈv邱ƂmFB<br>
     * Header part or data part should be called before TrailerPart",<br>
     * <br>
     * gC̏o͂ĂꍇAOX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testCheckWriteTrailer02() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub01> clazz = AbstractFileLineWriter_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub01> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O(tB[h)
        UTUtil.setPrivateField(fileLineWriter, "writeTrailer", Boolean.TRUE);

        // eXg{
        try {
            fileLineWriter.checkWriteTrailer();
            fail("FileExceptionO܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(FileException.class.isAssignableFrom(e.getClass()));
            assertEquals("Header part or data part should be called before "
                    + "TrailerPart", e.getMessage());
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testIsCheckByte01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() outputFileColumn:not null<br>
     * () outputFileColumn#bytes():0<br>
     * <br>
     * ҒlF(߂l) boolean:false<br>
     * <br>
     * oCg0̏ꍇAfalseԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testIsCheckByte01() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Class<AbstractFileLineWriter_Stub13> clazz = AbstractFileLineWriter_Stub13.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub13> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub13>(
                fileName, clazz, columnFormatterMap);

        // O()
        Field column2 = AbstractFileLineWriter_Stub13.class.getDeclaredFields()[1];
        OutputFileColumn outputFileColumn = column2
                .getAnnotation(OutputFileColumn.class);

        // eXg{
        boolean result = fileLineWriter.isCheckByte(outputFileColumn);

        // (߂l)
        assertFalse(result);
    }

    /**
     * testIsCheckByte02() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() outputFileColumn:not null<br>
     * () outputFileColumn#bytes():1<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * <br>
     * oCg48̏ꍇAtrueԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testIsCheckByte02() throws Exception {
        // O(Ώ)
        String fileName = "fileName";
        Class<AbstractFileLineWriter_Stub37> clazz = AbstractFileLineWriter_Stub37.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<AbstractFileLineWriter_Stub37> fileLineWriter = new AbstractFileLineWriterImpl01<AbstractFileLineWriter_Stub37>(
                fileName, clazz, columnFormatterMap);

        // O()
        Field column2 = AbstractFileLineWriter_Stub37.class.getDeclaredFields()[1];
        OutputFileColumn outputFileColumn = column2
                .getAnnotation(OutputFileColumn.class);

        // eXg{
        boolean result = fileLineWriter.isCheckByte(outputFileColumn);

        // (߂l)
        assertTrue(result);
    }

    /**
     * testIsCheckByte03() <br>
     * <br>
     * (n) <br>
     * <br>
     * ͒lF() int:-1<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * <br>
     * oCg-1̏ꍇAfalseԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testIsCheckByte03() throws Exception {
        // O(Ώ)
        String fileName = "fileName";

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        AbstractFileLineWriter<FileLineObject_Empty> fileLineWriter = new AbstractFileLineWriterImpl01<FileLineObject_Empty>(
                fileName, FileLineObject_Empty.class, columnFormatterMap);

        // eXg{
        boolean result = fileLineWriter.isCheckByte(1);

        // (߂l)
        assertTrue(result);
    }
}
