/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib.exception;

import com.mockrunner.mock.web.MockPageContext;

import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.PageContext;

/**
 */
public class Exception_PageContextImpl extends MockPageContext {

    /* G[o͔^Ul */
    private boolean NPEx = false;
    private boolean IAEx = false;

    /* ^C~O */
    private int timing = 1;
    private int count = 1;

    /* RXgN^ */
    public Exception_PageContextImpl(ServletConfig config,
                            ServletRequest request,
                            ServletResponse response){
        super(config, request, response);
    } /*  End */

    /*
     * NullPointerException^UlZbg
     */
    public void setNullPointerEx(){
        if(NPEx){
            NPEx = false;
        }else{
            NPEx = true;
        }
        System.out.println("setNullPointerEx:"+NPEx);
    } /* setNullPointerEx End */

    /*
     * IllegalArgumentException^UlZbg
     */
    public void setIllegalArgumentEx(){
        if(IAEx){
            IAEx = false;
        }else{
            IAEx = true;
        }
        System.out.println("setIllegalArgumentEx:"+IAEx);
    } /* setIllegalArgumentEx End */

    /*
     * O𔭐^C~Oݒ肷B
     */
    public void setTiming(int i){
        timing = i;
    } /* setTiming End */

    @Override
    public Object getAttribute(String name) {
        return getAttribute(name,PageContext.PAGE_SCOPE);
    } /* getAttribute End */

    @Override
    public Object getAttribute(String name, int scope) {
        if(NPEx && timing == count){
            throw new NullPointerException();
        }else if(IAEx && timing == count){
            throw new IllegalArgumentException();
        }
        count++;
        return super.getAttribute(name,scope);
    } /* getAttribute End */

    @Override
    public void setAttribute(String name, Object value) {
        setAttribute(name, value,PageContext.PAGE_SCOPE);
    } /* setAttribute End */

    @Override
    public void setAttribute(String name, Object value, int scope) {
        if(NPEx && timing == count){
            throw new NullPointerException();
        }else if(IAEx && timing == count){
            throw new IllegalArgumentException();
        }
        count++;
        super.setAttribute(name, value,scope);
    } /* setAttribute End */

} /* Exception_PageContextImpl Class End */
