/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.struts;

import com.mockrunner.util.common.MethodUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class DynamicMockProxyGenerator {
    private Class proxiedClass;
    private Object delegate;
    private Class additionalInterface;
    private Set methodsToIntercept;
    private Set methodsToDuplicate;

    public DynamicMockProxyGenerator(Class clazz, Object object, Method[] methodArray, Method[] methodArray2) {
        this(clazz, object, methodArray, methodArray2, null);
    }

    public DynamicMockProxyGenerator(Class clazz, Object object, Method[] methodArray, Method[] methodArray2, Class clazz2) {
        this.proxiedClass = clazz;
        this.delegate = object;
        this.additionalInterface = clazz2;
        this.methodsToIntercept = new HashSet();
        this.methodsToIntercept.addAll(Arrays.asList(methodArray));
        this.methodsToDuplicate = new HashSet();
        this.methodsToDuplicate.addAll(Arrays.asList(methodArray2));
    }

    public Object createProxy() {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(this.proxiedClass);
        if (null != this.additionalInterface) {
            enhancer.setInterfaces(new Class[]{this.additionalInterface});
        }
        Method[] methodArray = this.getActualTargetMethods(this.delegate, this.methodsToIntercept);
        Method[] methodArray2 = this.getActualTargetMethods(this.delegate, this.methodsToDuplicate);
        enhancer.setCallback((Callback)new DelegatingInterceptor(this.delegate, methodArray, methodArray2));
        return enhancer.create();
    }

    private Method[] getActualTargetMethods(Object object, Set set) {
        Method[] methodArray = object.getClass().getMethods();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet(set);
        for (int i = 0; i < methodArray.length; ++i) {
            this.findAndAddMethod(hashSet2, methodArray[i], hashSet);
        }
        return hashSet.toArray(new Method[hashSet.size()]);
    }

    private void findAndAddMethod(Set set, Method method, Set set2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Method method2 = (Method)iterator.next();
            if (!MethodUtil.areMethodsEqual(method, method2)) continue;
            set2.add(method);
            iterator.remove();
            return;
        }
    }

    private static class DelegatingInterceptor
    implements MethodInterceptor {
        private Object delegate;
        private Method[] methodsToIntercept;
        private Method[] methodsToDuplicate;

        public DelegatingInterceptor(Object object, Method[] methodArray, Method[] methodArray2) {
            this.delegate = object;
            this.methodsToIntercept = methodArray;
            this.methodsToDuplicate = methodArray2;
        }

        public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
            int n;
            for (n = 0; n < this.methodsToIntercept.length; ++n) {
                if (!MethodUtil.areMethodsEqual(method, this.methodsToIntercept[n])) continue;
                return this.methodsToIntercept[n].invoke(this.delegate, objectArray);
            }
            for (n = 0; n < this.methodsToDuplicate.length; ++n) {
                if (!MethodUtil.areMethodsEqual(method, this.methodsToDuplicate[n])) continue;
                this.methodsToDuplicate[n].invoke(this.delegate, objectArray);
            }
            return methodProxy.invokeSuper(object, objectArray);
        }
    }
}

