package jp.terasoluna.batch.functionsample.b009;

import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupportImpl;
import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.db.DBValidateCollector;
import jp.terasoluna.fw.collector.util.CollectorUtility;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.UpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.validation.Validator;

/**
 * ̓f[^擾@\gpۂ̊gOnhÕTv<br>
 * <p>
 * OFC:\tmpzinputB009001.csvt@Czu邱(DBp)<br>
 * </p>
 * <p>
 * TveFEMPLOYEE3e[uǂݎAEMPLOYEE2e[uɏo͂B<br>
 * gOnhOgpAXe[^XɂENDԋpB<br>
 * (G[ValidationErrorException悤ɎĂ)<br>
 * ̓`FbNG[_ŏI邪AIXe[^X100ZbgB<br>
 * (^C~OɂāAEMPLOYEE2e[uɑ}錏͕ϓ)
 *</p>
 */
@Component
public class B009002BLogic extends AbstractTransactionBLogic {

    private Log log = LogFactory.getLog(B009002BLogic.class);

    private static final int BATCH_NORMAL_END = 0;

    @Autowired
    @Qualifier("queryRowHandleDAO")
    private QueryRowHandleDAO queryRowHandleDAO = null;

    @Autowired
    @Qualifier("updateDAO")
    private UpdateDAO updateDAO = null;

    @Autowired
    @Qualifier("beanValidator")
    private Validator beanValidator = null;

    public int doMain(BLogicParam arg0) {

        int returnCode = BATCH_NORMAL_END;

        int insertCount = 0;

        if (log.isInfoEnabled()) {
            log.info("EMPLOYEE3e[uǂݍ:Jn");
        }

        BatchUpdateSupport bus = new BatchUpdateSupportImpl();

        CustomCollectorExceptionHandler cceHandler = new CustomCollectorExceptionHandler();

        Collector<CsvRecord> collector = new DBValidateCollector<CsvRecord>(
                queryRowHandleDAO, "B009002.selectEmployees", CsvRecord.class,
                20, cceHandler, beanValidator);

        try {

            while (collector.hasNext()) {
                CsvRecord csvRecord = collector.next();
                if (csvRecord != null) {
                    log.info("NAME:" + csvRecord.getFamilyName());
                    // ob`XVɒǉ
                    bus.addBatch("B009002.insertEmployee2", csvRecord);
                }
            }

            // ob`XVs
            insertCount = bus.executeBatch(updateDAO);

        } catch (Exception e) {
            throw new BatchException(e);
        } finally {
            // RN^̃N[Y
            CollectorUtility.closeQuietly(collector);
        }

        if (log.isInfoEnabled()) {
            log.info("EMPLOYEE2e[u:" + insertCount + "}܂B");
        }

        // PłG[ꍇ́A"100"ԋpB
        if (cceHandler.getErrorFieldCount() > 0) {
            return 100;
        }

        // I
        return returnCode;
    }
}
