package jp.terasoluna.batch.functionsample.b006;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupportImpl;
import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.file.FileCollector;
import jp.terasoluna.fw.collector.util.CollectorUtility;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

/**
 * ob`XVœK@\̃Tv<br>
 * <p>
 * OFPERSONAL_INFORMATIONe[u݂A101`300܂ł̃f[^݂鎖<br>
 * </p>
 * <p>
 * TveFinsert,delete,update,insert...̏Ɋi[SQL<br>
 * ob`XVsinsert100,delete100,update100̏<br>
 * œKĂ邱ƂmFTv<br>
 * </p>
 */
@Component
public class B006001BLogic implements BLogic {

    private Log log = LogFactory.getLog(B006001BLogic.class);

    @Autowired
    private UpdateDAO updateDAO;

    @Autowired
    @Qualifier(value = "csvFileQueryDAO")
    private FileQueryDAO csvFileQueryDAO = null;

    @Autowired
    private PlatformTransactionManager transactionManager = null;

    public int execute(BLogicParam param) {

        TransactionStatus stat = null;

        // 
        int count = 0;

        // delete&updatepcode̒l
        int i = 101;

        BatchUpdateSupport bus = new BatchUpdateSupportImpl(updateDAO);

        // t@C͗pRN^̎擾
        Collector<SampleFileLineObject> collector = new FileCollector<SampleFileLineObject>(
                csvFileQueryDAO, "C:\\tmp\\inputB006.csv",
                SampleFileLineObject.class);

        try {
            // gUNVJn
            stat = BatchUtil.startTransaction(transactionManager);
            while (collector.hasNext()) {
                // f[^̓ǂݍ
                SampleFileLineObject insertData = collector.next();

                // insert(00001`00100)
                bus.addBatch("B006001.insertData01", insertData);

                // delete(00101`00200)
                SampleFileLineObject deleteData = new SampleFileLineObject();
                deleteData.setCode(String.valueOf(i));
                bus.addBatch("B006001.deleteData01", deleteData);

                // update(00301`00300)
                SampleFileLineObject updateData = new SampleFileLineObject(
                        String.valueOf((i + 100)), "hoge", "hoge", "hoge",
                        "hoge", "hoge", "hoge", "hoge", "hoge", "hoge");
                bus.addBatch("B006001.updateData01", updateData);

                i++;

            }

            // ob`XV̎s
            count = bus.executeBatch();
            if (log.isInfoEnabled()) {
                log.info("F" + count + "");
                log.info("ob`XV");
            }
            // gUNVR~bg
            BatchUtil.commitTransaction(transactionManager, stat);
        } catch (Exception e) {
            throw new BatchException(e);
        } finally {
            // RN^̃N[Y
            CollectorUtility.closeQuietly(collector);
            // gUNVI
            BatchUtil.endTransaction(transactionManager, stat);
        }

        return 0;
    }
}
