/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.batch.tutorial.sample002;

import jp.terasoluna.batch.tutorial.common.NyusyukkinData;
import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.file.FileCollector;
import jp.terasoluna.fw.collector.util.CollectorUtility;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

/**
 * rWlXWbNNXBiCSVt@Cǂݍ݁ADBɃf[^}j
 */
@Component
public class SMP002BLogic extends AbstractTransactionBLogic {

	private static final Log log = LogFactory.getLog(SMP002BLogic.class);

	@Autowired
	protected UpdateDAO updateDAO;

	@Autowired
	@Qualifier(value = "csvFileQueryDAO")
	protected FileQueryDAO csvFileQueryDAO;

	public int doMain(BLogicParam param) {

		// WuIR[hi0:IA-1:ُIj
		int returnCode = 0;

		// RN^
		Collector<NyusyukkinData> collector = new FileCollector<NyusyukkinData>(
				this.csvFileQueryDAO, "inputFile/SMP002_input.csv",
				NyusyukkinData.class);

		try {
			// t@C擾f[^i[IuWFNg
			NyusyukkinData inputData = null;

			while (collector.hasNext()) {
				// t@Cf[^擾
				inputData = collector.next();

				if (updateDAO != null && inputData != null) {
					// DBXV
					updateDAO.execute("SMP002.insertNyusyukkinData", inputData);
				}

			}

		} catch (DataAccessException e) {
			if (log.isErrorEnabled()) {
				log.error("f[^ANZXG[܂", e);
			}

			returnCode = -1;
		} catch (Exception e) {
			if (log.isErrorEnabled()) {
				log.error("G[܂", e);
			}

			returnCode = -1;
		} finally {
			// RN^̃N[Y
			CollectorUtility.closeQuietly(collector);

			// IɃOc
			if (returnCode == 0 && log.isInfoEnabled()) {
				log.info("DB̍XVɏI܂B");
			}
		}

		return returnCode;
	}
}
