/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_01.blogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.toursample.common.blogic.PriceCalculateBLogic;
import jp.terasoluna.toursample.common.blogic.TourDetailAcquireBLogic;
import jp.terasoluna.toursample.common.dto.PriceCalculateOutput;
import jp.terasoluna.toursample.common.dto.TourDetailAcquireOutput;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_01_03Input;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_01_03Output;

/**
 * <p>
 * cA[ڍ׏擾rWlXWbNB<br>
 * ʋ@\𗘗păcA[ڍ׏񓙂擾AcA[ڍ׉ʂ\邽߂̏sB
 * </p>
 * 
 * 
 * 
 */
public class RP_A01_01_01_03BLogicImpl
        implements BLogic<RP_A01_01_01_03Input> {

    /**
     * ʏsNullԋpꂽꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_TOURCODE = "error.UC_A01_01.00002";

    /**
     * ONXB
     */
    private static final Log log =
        LogFactory.getLog(RP_A01_01_01_03BLogicImpl.class);

    /**
     * ڍ׏擾WbN(ʏ)
     */
    protected TourDetailAcquireBLogic tourDetailAcquireBLogic = null;

    /**
     * ڍ׏擾WbN̏
     * 
     * @param tourDetailAcquireBLogic ڍ׏擾WbN
     */
    public void setTourDetailAcquireBLogic(
            TourDetailAcquireBLogic tourDetailAcquireBLogic) {

        this.tourDetailAcquireBLogic = tourDetailAcquireBLogic;
    }

    /**
     * ZoWbN (ʏ)
     */
    protected PriceCalculateBLogic priceCalculateBLogic = null;

    /**
     * ZoWbN̏B
     * 
     * @param priceCalculateBLogic ZoWbN
     */
    public void setPriceCalculateBLogic(
            PriceCalculateBLogic priceCalculateBLogic) {

        this.priceCalculateBLogic = priceCalculateBLogic;
    }

    /**
     * RP_A01_01_01_03 ڍ׏擾
     * 
     * cA[ڍ׏̎擾sAw肳ꂽcA[ڍ׏̎擾Ɏsꍇ͗OsB<br>
     *
     * @exception RecordNotFoundException f[^x[X擾ʂȂꍇɔONX
     * @param input 
     * @return rWlXWbN̎sʁABLogicResultCX^X
     *          ResultObject RP_A01_01_01_03Output cA[ڍ׏
     */
    public BLogicResult execute(RP_A01_01_01_03Input input) {

        // ԋpl̏
        BLogicResult result = new BLogicResult();
        RP_A01_01_01_03Output output = new RP_A01_01_01_03Output();
        BLogicMessages messages = new BLogicMessages();


        // cA[ڍ׏̎擾
        TourDetailAcquireOutput tourDetail = tourDetailAcquireBLogic
            .execute(input.getTourCode());

        // cA[ڍ׏񂪎擾łȂꍇAOsB
        if (tourDetail == null) {
            if (log.isErrorEnabled()) {
                log.error(ERROR_NOT_TOURCODE
                          + ":cA[ڍ׏񂪎擾ł܂łB");
            }
            throw new RecordNotFoundException(ERROR_NOT_TOURCODE);
        }

        // ̌vZ ʏ𗘗păcA[{AlPAȂǂ擾
        PriceCalculateOutput priceOutput = priceCalculateBLogic
            .execute(tourDetail.getBasePrice(), (Integer.parseInt(input.getAdultCountCondition())),
            		 Integer.parseInt(input.getChildCountCondition()));

        // ԋpl̐ݒ
        output.setTourDetail(tourDetail);
        output.setPriceOutput(priceOutput);

        // \ҏ擾 \ҏ񂪑݂Ă邩mFs
        if (input.getUSER_VALUE_OBJECT() == null) {

            messages.add(this.getClass().getName(),
                         new BLogicMessage("info.UC_A01_01.00002"));
            result.setMessages(messages);
        } else {
            messages.add(this.getClass().getName(),
                         new BLogicMessage("info.UC_A01_01.00001"));
            result.setMessages(messages);
        }
        
        // ӌEv]
        output.setRemarks(null);

        result.setResultObject(output);
        result.setResultString("success");
        return result;
    }
}
