/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.common.blogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.toursample.common.dto.PriceCalculateOutput;
import jp.terasoluna.toursample.common.exception.TourSystemException;

/**
 * PZorWlXWbNNXB<br>
 * f[^x[XlAqǂ̔Nߋ敪ʊ擾APAyї ZoB<br>
 * f[^x[Xɂ͢lɑ΂颔Nߋ敪R[hƂĢ0Aqǂࣂɑ΂ Nߋ敪R[hƂĢ1ݒ肳ĂB<br>
 * 0Ƣ1̃f[^݂Ȃ{@link TourSystemException}B<br>
 * 
 * <br>
 * EʏCP0009FPZo <br>
 * <br>
 * EvZ<br>
 * &nbsp;&nbsp;- {F10,000~<br>
 * &nbsp;&nbsp;- lF3<br>
 * &nbsp;&nbsp;- qǂF1<br>
 * &nbsp;&nbsp;- l̔Nߋ敪ʊF100<br>
 * &nbsp;&nbsp;- qǂ̔Nߋ敪ʊF60<br>
 * 
 * E<br>
 * &nbsp;&nbsp;- l̒PF{~l̔Nߋ敪ʊ^10010,000~ <br>
 * &nbsp;&nbsp;- qǂ̒PF{~qǂ̔Nߋ敪ʊ^1006,000~ <br>
 * &nbsp;&nbsp;- l̗Fl̒P~l30,000~<br>
 * &nbsp;&nbsp;- qǂ̗Fqǂ̒P~qǂ6,000~<br>
 * &nbsp;&nbsp;- vFl̗{qǂ̗36,000~<br>
 * <br>
 * 
 * 
 */
public class PriceCalculateBLogicImpl implements PriceCalculateBLogic {

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(PriceCalculateBLogicImpl.class);

    /**
     * f[^x[X̔Nߋ敪ʊ擾Ɏsꍇ G[bZ[WR[hB
     */
    private static final String GET_RATE_ERROR = "error.common.00007";

    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B
     */
    protected QueryDAO queryDAO = null;

    /**
     * QueryDAOݒ肷B
     * 
     * @param queryDAO
     *            QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {

        this.queryDAO = queryDAO;
    }

    /**
     * PA̎ZosȂB
     * 
     * @param basePrice
     *            {
     * @param adultCount
     *            l(l)
     * @param childCount
     *            l(qǂ)
     * @return PZo
     * @exception TourSystemException
     *                Nߋ敪ʊ̎擾s
     */
    public PriceCalculateOutput execute(Integer basePrice, Integer adultCount,
            Integer childCount) {

        // ʂi[IuWFNg
        PriceCalculateOutput result = new PriceCalculateOutput();

        Integer adultRate = null;
        Integer childRate = null;

        // l̔Nߋ敪ʊ擾B
        // 0͢lɑ΂颔Nߋ敪R[hłB
        adultRate = queryDAO.executeForObject("common.selectAgeRate", "0",
                                              Integer.class);

        // qǂ̔Nߋ敪ʊ擾B
        // 1͢qǂࣂɑ΂颔Nߋ敪R[hłB
        childRate = queryDAO.executeForObject("common.selectAgeRate", "1",
                                              Integer.class);

        // Nߋ敪ʊ擾ȂꍇAG[𔭐B
        if (adultRate == null || childRate == null) {

            if (log.isErrorEnabled()) {
                log
                    .error(GET_RATE_ERROR + ": f[^x[XNߋ敪ʊ"
                            + "̎擾s܂B");
            }

            throw new TourSystemException(GET_RATE_ERROR);
        }

        // l̒PvZAʂɊi[B
        // vZʂɏ_oꍇ͐؂̂ĂB
        int adultUnitPrice = basePrice * adultRate / 100;

        result.setAdultUnitPrice(adultUnitPrice);

        // l̗vZAʂɊi[B
        int adultPrice = adultCount * adultUnitPrice;
        result.setAdultPrice(adultPrice);

        // qǂ̒PvZAʂɊi[B
        // vZʂɏ_oꍇ͐؂̂ĂB
        int childUnitPrice = basePrice * childRate / 100;

        result.setChildUnitPrice(childUnitPrice);

        // qǂ̗vZAʂɊi[B
        int childPrice = childCount * childUnitPrice;
        result.setChildPrice(childPrice);

        // ʂɐl(l)i[B
        result.setAdultCount(adultCount);

        // ʂɐl(qǂ)i[B
        result.setChildCount(childCount);

        // vvZAʂɊi[B
        result.setSumPrice(adultPrice + childPrice);

        return result;

    }

}
