/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_02.blogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.toursample.common.Constants;
import jp.terasoluna.toursample.common.blogic.PriceCalculateBLogic;
import jp.terasoluna.toursample.common.blogic.ReserveDetailAcquireBLogic;
import jp.terasoluna.toursample.common.dto.PriceCalculateOutput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireInput;
import jp.terasoluna.toursample.common.dto.ReserveDetailAcquireOutput;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.uc_a01_02.dto.RP_A01_02_01_02Input;
import jp.terasoluna.toursample.uc_a01_02.dto.RP_A01_02_01_02Output;

/**
 * cA[\ڍ׏擾rWlXWbNB
 * <p>
 * E\ڍ׏擾(ʏCP0006)B<br>
 * E\񂪂ȂꍇAOsB<br>
 * ONXFRecordNotFoundException<BR>
 * EvZ(ʏFCP0009)B
 * </p>
 * 
 * 
 * 
 */

public class RP_A01_02_01_02BLogicImpl implements BLogic<RP_A01_02_01_02Input> {

    /**
     * ʏsNullԋpꂽꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_RESERVED = "error.common.00008";

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_02_01_02BLogicImpl.class);

    /**
     * \ڍ׏擾NX(ʏCP0006)B SpringɂCX^Xݒ肳B
     */
    protected ReserveDetailAcquireBLogic reserveDetailAcquireBLogic = null;

    /**
     * vZNX(ʏCP0009)B SpringɂCX^Xݒ肳B
     */
    protected PriceCalculateBLogic priceCalculateBLogic = null;

    /**
     * vZNXԂB
     * 
     * @return vZNX
     */
    public PriceCalculateBLogic getPriceCalculateBLogic() {

        return priceCalculateBLogic;
    }

    /**
     * vZNXݒ肷B
     * 
     * @param priceCalculateBLogic
     *            vZNX
     */
    public void setPriceCalculateBLogic(
            PriceCalculateBLogic priceCalculateBLogic) {

        this.priceCalculateBLogic = priceCalculateBLogic;
    }

    /**
     * \ڍ׏擾NXԂB
     * 
     * @return \ڍ׏擾NX
     */
    public ReserveDetailAcquireBLogic getReserveDetailAcquireBLogic() {

        return reserveDetailAcquireBLogic;
    }

    /**
     * \ڍ׏擾NXݒ肷B
     * 
     * @param reserveDetailAcquireBLogic
     *            \ڍ׏擾NX
     */
    public void setReserveDetailAcquireBLogic(
            ReserveDetailAcquireBLogic reserveDetailAcquireBLogic) {

        this.reserveDetailAcquireBLogic = reserveDetailAcquireBLogic;
    }

    /**
     * \ڍ׏擾B <BR>
     * \ڍ׏̎擾Ɉv\ڍ׏ԋpB
     * 
     * @param param
     *            \ڍ׏擾
     * @return \ڍ׏񃊃Xg
     * 
     * @exception
     * jp.terasoluna.toursample.common.exception.RecordNotFoundException
     * f[^x[X擾ʂȂꍇɔ
     */
    public BLogicResult execute(RP_A01_02_01_02Input param) {

        // sʂi[B
        BLogicResult result = new BLogicResult();

        // o͏i[NX𐶐B
        RP_A01_02_01_02Output rp_a01_02_01_02BLogicOutput = 
            new RP_A01_02_01_02Output();

        // \ڍ׏擾̈̃NX𐶐B
        ReserveDetailAcquireInput reserveDetailAcquireInput = 
            new ReserveDetailAcquireInput();

        // \ڍ׏擾̈ݒ肷B
        reserveDetailAcquireInput.setReserveNo(param.getReserveNo());
        reserveDetailAcquireInput.setCustomerCode(param.getUSER_VALUE_OBJECT()
            .getCustomerCode());

        // \ڍ׏擾(ʏCP0006)B
        ReserveDetailAcquireOutput reserveDetail = 
            reserveDetailAcquireBLogic.execute(reserveDetailAcquireInput);

        // \񂪂ȂꍇAOsB
        // ONXFRecordNotFoundException
        if (reserveDetail == null) {

            if (log.isErrorEnabled()) {
                log.error(ERROR_NOT_RESERVED + ":\񂪌܂B");
            }

            throw new RecordNotFoundException(ERROR_NOT_RESERVED);
        }

        // vZ(ʏFCP0009)B
        PriceCalculateOutput price = priceCalculateBLogic.execute(reserveDetail
            .getBasePrice(), reserveDetail.getAdultCount(), reserveDetail
            .getChildCount());

        // cA[\ڍ׏o͒lɃZbgB
        rp_a01_02_01_02BLogicOutput.setReserveDetail(reserveDetail);
        rp_a01_02_01_02BLogicOutput.setPrice(price);
        rp_a01_02_01_02BLogicOutput.setPaymentMethod(PropertyUtil
            .getProperty(Constants.PAYMENT_METHOD));
        rp_a01_02_01_02BLogicOutput.setPaymentCompanyName(PropertyUtil
            .getProperty(Constants.PAYMENT_COMPANY_NAME));
        rp_a01_02_01_02BLogicOutput.setPaymentAccount(PropertyUtil
            .getProperty(Constants.PAYMENT_ACCOUNT));
        rp_a01_02_01_02BLogicOutput.setReferenceName(PropertyUtil
            .getProperty(Constants.COMPANY_NAME));
        rp_a01_02_01_02BLogicOutput.setReferenceEmail(PropertyUtil
            .getProperty(Constants.COMPANY_MAIL));
        rp_a01_02_01_02BLogicOutput.setReferenceTel(PropertyUtil
            .getProperty(Constants.COMPANY_TEL));

        // ʂZbgB
        result.setResultObject(rp_a01_02_01_02BLogicOutput);
        result.setResultString("success");

        return result;
    }

}
