/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.common.exception;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.struts.action.ExceptionConfigEx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;
import org.springframework.dao.DataAccessException;

/**
 * DataAccessExceptionONXB
 *
 * <p>
 * DataAccessExceptioñOo͂ G[ʂւ̑JڂsB<br>
 * ANVsDataAccessExceptionƂ́A
 * G[Oo͂ŁAYANV}bsOɒ`Ă
 * G[ʂɑJڂB
 * {@\𗘗p邽߂ɂ́AStrutsݒt@C(struts-config.xml)
 * O[oOA܂̓ANVxOnhNXƂĎw肷B<br>
 * O[oOƁAANVxOՓ˂ĂꍇA
 * Struts̎dlɂANVxOD悳B
 * </p>
 * <h5>O[oOƂĂ̐ݒ</h5>
 * Strutsݒt@C(struts-config.xml)Ɉȉ̂悤ɏB
 * <pre><code>
 * &lt;struts-config&gt;
 *   c
 *   &lt;global-exceptions&gt;
 *     &lt;exception key="some.key"
 *                path="/dataAccess-error"
 *                type="org.springframework.dao.DataAccessException"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.toursample.common.exception.DataAccessExceptionHandler"&gt;
 *       &lt;set-property property="module" value="/exp"/&gt;
 *     &lt;/exception&gt;
 *   &lt;/global-exceptions&gt;
 *   c
 * &lt;struts-config&gt;
 * </code></pre>
 * </p>
 * <h5>ANVxOƂĂ̐ݒ</h5>
 * <pre><code>
 * &lt;struts-config&gt;
 *   c
 *   &lt;action path="/start"
 *           type="jp.terasoluna.xxx.SampleAction"
 *           name="_sampleForm"
 *           scope="session"&gt;
 *     &lt;exception key="some.key"
 *                type="org.springframework.dao.DataAccessException"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.toursample.common.exception.DataAccessExceptionHandler"
 *                path="/sub-forward.do"&gt;
 *       &lt;set-property property="module" value="/sub"/&gt;
 *     &lt;/exception&gt;
 *     &lt;forward name="success" path="/index.jsp"/&gt;
 *   &lt;/action&gt;
 *   c
 * &lt;struts-config&gt;
 * </code></pre>
 * ȂA&lt;exception&gt;vfpathőJڐpXw
 * Ȃꍇ́AANV}bsOinput
 * ]惊\[XƂB
 *
 * @see org.springframework.dao.DataAccessException
 * @see jp.terasoluna.fw.web.struts.action.ExceptionConfigEx
 *
 * 
 * 
 */
public class DataAccessExceptionHandler extends ExceptionHandler {

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(DataAccessExceptionHandler.class);

    /**
     * DataAccessExceptionOnh̃Gg|CgB
     * 
     * @param ex O
     * @param eConfig ORtBO
     * @param mapping ANV}bsO
     * @param formInstance ANVtH[
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * 
     * @return G[bZ[W
     * 
     * @throws ServletException T[ubgO
     */
    @Override
    public ActionForward execute(Exception ex,
                                 ExceptionConfig eConfig,
                                 ActionMapping mapping,
                                 ActionForm formInstance,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
            throws ServletException {
        // ytH[hݒ肷z
        // pathɂtH[h悪w肳Ȃꍇ́A
        // ANV}bsOinputftHgƂB
        String path = null;
        if (eConfig.getPath() != null) {
            path = eConfig.getPath();
        } else {
            path = mapping.getInput();
        }
        ActionForward forward = new ActionForward(path);
        
        
        // yJڐݒ肷z
        if (eConfig instanceof ExceptionConfigEx) {
            // Jڐ惂W[ݒ肳ĂƂAW[ݒ肷
            forward.setModule(((ExceptionConfigEx) eConfig).getModule());
        }
        
        if (ex instanceof DataAccessException) {
            DataAccessException dae = (DataAccessException) ex;

            // yNGXg烁bZ[W\[X擾Bz
            MessageResources resources = null;
            
            // XR[v烁bZ[W\[X擾ۂ̃ohL[擾B
            String bundle = eConfig.getBundle();
            if (bundle == null) {
                // struts-config.xmlmessage-resources
                // bundlew肳ĂȂꍇA
                // ftHg̃ohL[ݒ肷
                bundle = Globals.MESSAGES_KEY;
            }

            // NGXg̎擾݂B
            resources = (MessageResources) request
                .getAttribute(bundle);
            if (resources == null) {
                // NGXgɂȂ΃AvP[V̎擾݂B
                resources = (MessageResources) RequestUtil
                    .getServletContext(request).getAttribute(bundle);
            }
            
            // yʕ\pActionMessageݒ肷z
            String key = eConfig.getKey();
            ActionMessage error = null;
            if (resources != null) {
                error = new ActionMessage(key);
            } else {
                // ʂłĂbZ[W\[Xꍇ̓G[L[bZ[Wɂ
                error = new ActionMessage(key, false);
            }
            super.storeException(request,
                    key,
                    error,
                    forward,
                    eConfig.getScope());
            
            // X^bNg[XƃZbVnbVlOɏo
            String sessionHash = RequestUtil.getSessionHash(request);
            log.error("sessionHash = " + sessionHash);
            log.error(ExceptionUtil.getStackTrace(dae));

            // yDataAccessExceptionݒ肷z
            // OJSPG[y[W exception Ƃ
            // 擾ł悤 request ɐݒ肷
            request.setAttribute(PageContext.EXCEPTION, dae);
        }

        // G[́AANV}bsO̐ݒɉđJڂB
        return forward;
    }
}
