/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.thin;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>NGXgp[^̃GR[fBOݒsB</p>
 * <p>
 * gp@
 * </p>
 * <p>
 * NCAg̃NGXgɎIɕGR[hwsꍇA
 * WebAvP[Vݒt@Ciweb.xmlj
 * p̃T[ubgtB^iSetCharacterEncodingFilterjo^B<br>
 * ̍ہAp[^ƂāA
 * NGXg̕GR[hʁEtB^̕񏈗tOEtB^[tOw肷B<br>
 * GR[hʂ̒ĺAȒl̏ꍇwarnx̃Oo͂AGR[fBOݒ͍sȂB<br>
 * ȉ́ANGXgɎIɕGR[hwsꍇencoding̎włB<br>
 * <br>
 * WebAvP[Vݒt@Ciweb.xmlj<br>
 * <code>
 * &lt;filter&gt;<br>
 * &nbsp;&lt;filter-name&gt;encodingFilter&lt;/filter-name&gt;<br>
 * &nbsp;&nbsp;&lt;filter-class&gt;<br>
 * &nbsp;&nbsp;&nbsp;jp.terasoluna.fw.ex.web.thin.SetCharacterEncodingFilter<br>
 * &nbsp;&nbsp;&lt;/filter-class&gt;<br>
 * &nbsp;&nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&nbsp;&lt;param-name&gt;encoding&lt;/param-name&gt;<br>
 * &nbsp;&nbsp;&nbsp;&lt;param-value&gt;Windows-31J&lt;/param-value&gt;<br>
 * &nbsp;&nbsp;&lt;/init-param&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&lt;param-name&gt;more&lt;/param-name&gt;<br>
 * &nbsp;&nbsp;&lt;param-value&gt;false&lt;/param-value&gt;<br>
 * &nbsp;&lt;/init-param&gt;<br>
 * &nbsp;&lt;init-param&gt;<br>
 * &nbsp;&nbsp;&lt;param-name&gt;ignore&lt;/param-name&gt;<br>
 * &nbsp;&nbsp;&lt;param-value&gt;false&lt;/param-value&gt;<br>
 * &nbsp;&lt;/init-param&gt;<br>
 * &lt;/filter&gt;<br>
 * <br>
 * &lt;filter-mapping&gt;<br>
 * &nbsp;&lt;filter-name&gt;encodingFilter&lt;/filter-name&gt;<br>
 * &nbsp;&lt;url-pattern&gt;/*&lt;/url-pattern&gt;<br>
 * &lt;/filter-mapping&gt;<br>
 * </code>
 */
public class SetCharacterEncodingFilter implements Filter {

    /**
     * ONXB
     */
    private static Log log = LogFactory
            .getLog(SetCharacterEncodingFilter.class);

    /**
     * tB^ς݃tOB
     */
    private static final String THRU_FILTER_KEY = "THRU_FILTER_ENCODING";

    /**
     * tB^̕񏈗tOB
     */
    private boolean moreFlag = false;

    /**
     * GR[fBOB
     */
    private String encoding = null;

    /**
     * ̃tB^[𖳌tOB
     */
    private boolean ignoreFlag = false;

    /**
     * B
     * 
     * @param filterConfig
     *            tB^[ݒ
     * 
     * @throws ServletException
     *                O
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        
        // Log
        if (log.isDebugEnabled()) {
            log.debug("init() called.");
        }

        String encode = filterConfig.getInitParameter("encoding");

        try {
            if (!Charset.isSupported(encode)) {
                log.warn(encode + " is unsupported encoding.");
            } else {
                this.encoding = encode;
            }
        } catch (IllegalCharsetNameException e) {
            log.warn("The format of encoding is not correct.");
        } catch (IllegalArgumentException e) {
            log.warn("encoding can not be null.");
        }

        if (log.isDebugEnabled()) {
            log.debug("this.encoding = " + this.encoding);
        }

        String ignoreValue = filterConfig.getInitParameter("ignore");
        if (ignoreValue != null) {
            this.ignoreFlag = this.createFlag(ignoreValue);
        }

        String moreValue = filterConfig.getInitParameter("more");
        if (moreValue != null) {
            this.moreFlag = this.createFlag(moreValue);
        }
    }

    /**
     * tB^[B
     * 
     * <p>
     * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
     * </p>
     * 
     * @param request
     *            NGXg
     * @param response
     *            X|X
     * @param chain
     *            tB^[`F[
     * 
     * @throws IOException
     *                O
     * @throws ServletException
     *                O
     */
    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, 
            ServletException {

        if (!this.moreFlag && request.getAttribute(THRU_FILTER_KEY) != null) {
            chain.doFilter(request, response);
            return;
        }

        if (!ignoreFlag && encoding != null) {
            // Log
            if (log.isDebugEnabled()) {
                log.debug("set encoding(" + encoding + ") to request.");
            }
            request.setCharacterEncoding(encoding);
        }

        // σtOi[
        request.setAttribute(THRU_FILTER_KEY, THRU_FILTER_KEY);

        chain.doFilter(request, response);
    }

    /**
     * IB
     */
    public void destroy() {
        this.encoding = null;
    }

    /**
     * AtO𐶐B
     * 
     * @param value
     *            ΏەB
     * @return ꂽtOB
     */
    private boolean createFlag(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        } else if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        return false;
    }
}

