/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;

public class TagUtil {
    private static final Map<String, Integer> SCOPES = new HashMap<String, Integer>();

    public static int getScope(String scopeName) throws JspException {
        if (scopeName == null) {
            throw new JspException();
        }
        Integer scope = SCOPES.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new JspException();
        }
        return scope;
    }

    public static Object lookup(PageContext pageContext, String name, String scopeName) throws JspException {
        if (scopeName == null) {
            return pageContext.findAttribute(name);
        }
        return pageContext.getAttribute(name, TagUtil.getScope(scopeName));
    }

    public static Object lookup(PageContext pageContext, String name, String property, String scopeName) throws JspException {
        Object bean = TagUtil.lookup(pageContext, name, scopeName);
        if (bean == null) {
            throw new JspException();
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (IllegalAccessException e) {
            throw new JspException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new JspException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JspException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new JspException((Throwable)e);
        }
    }

    public static void write(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.print(text);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public static void writeln(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.println(text);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public static String filter(String value) {
        if (value == null) {
            return null;
        }
        char[] content = new char[value.length()];
        value.getChars(0, value.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block7: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block7;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    static {
        SCOPES.put("application", 4);
        SCOPES.put("session", 3);
        SCOPES.put("request", 2);
        SCOPES.put("page", 1);
    }
}

