/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.web.rich.springmvc.Constants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;

/**
 * ExceptionResolveDelegator̃ftHgNXB
 * <p>
 * {NX́A{@link jp.terasoluna.fw.web.rich.springmvc.servlet.handler.SimpleMappingExceptionResolverEx}Ŏgp邱ƂOƂĂB
 * </p>
 * 
 * <p>
 * G[ʂX|Xwb_ɁAG[R[hModelCX^Xɐݒ肷B<br>
 * {NXgpꍇASimpleMappingExceptionResolverExlinkedExceptionMappings̒lɁA
 * r[ƃG[J}ŋ؂ݒiBean`jKvB
 * iBean`t@C̋Lq@ɊւẮASimpleMappingExceptionResolverExjavadocQƂ邱Ɓj<br>
 * J}ŋ؂̂PԖڂɃr[AQԖڂɃG[ʁARԖڂɃG[R[hLq邱ƁB<br>
 * r[ƃG[ʂ̐ݒ͕K{łB<br>
 * G[R[h̐ݒ͔CӂłAȗ邱ƂłB<br>
 * fɃr[i"bindException"jƃG[R[hi"8004C002"jAX|Xwb_ɃG[ʁi"kind01"jݒ肷ꍇAȉ̕ݒiBean`jB
 * ubindException,kind01,8004C002v<br>
 * fɃr[i"bindException"jAX|Xwb_ɃG[ʁi"kind01"jݒ肷ꍇAȉ̕ݒiBean`jB
 * ubindException,kind01v
 * </p>
 * 
 */
public class ExceptionResolveDelegatorImpl implements ExceptionResolveDelegator {
    /**
     * ONXB
     */
    private static Log log = LogFactory
            .getLog(ExceptionResolveDelegatorImpl.class);

    /**
     * OꍇɃX|Xwb_ɐݒ肷L[̃ftHglB
     */
    protected static final String EXCEPTION_KEY = "exception";
    
    /**
     * ݒt@CɃX|Xwb_̃G[^CṽL[̃L[B
     */
    protected static final String ERROR_TYPE_HEADER_NAME_KEY = "errorTypeHeaderName";

    /**
     * Ǒ^B
     */
    protected String mappingKey = null;

    /**
     * r[ƃG[񂪊i[ꂽB
     */
    protected Object mappingValues = null;

    /**
     * r[B
     */
    protected String viewName = null;
    
    /**
     * G[ʁB
     */
    protected String errorType = null;

    /**
     * G[R[hB
     */
    protected String errorCode = null;
    
    /**
     * X|Xwb_̃G[^CṽL[(ftHglFEXCEPTION_KEY)
     */
    protected String errorTypeHeaderName = EXCEPTION_KEY;

    /**
     * Ǒ^ƃr[iG[j𑮐Ɋi[B
     * i[OɁAr[iG[j̐`FbNA
     * X|Xwb_Ƀwb_̃G[^CṽL[̗L`FbNB
     * paramsɃL[ERROR_TYPE_HEADER_NAME_KEY݂A̒lnullƋ󕶎ȊȌꍇ́A
     * errorTypeHeaderNameɂ̒lݒ肷B
     * 
     * @param mappingKey Ǒ^
     * @param mappingValues r[ƃG[iJ}؂̕j
     * @param params wb_̃G[^CṽL[ȂǏ̃L[ƒli[Map
     */
    public void initMapping(String mappingKey, Object mappingValues, 
            Map<String,String> params) {

        // mappingValuesnull̏ꍇAOX[B
        if (mappingValues == null) {
            String message = "linkedExceptionMappings[" + mappingKey
                    + "] value is null. "
                    + "Check Spring Bean definition file.";
            log.error(message);
            throw new IllegalStateException(message);
        }

        // mappingValuesString^łȂꍇAOX[B
        if (!(mappingValues instanceof String)) {
            String message = "linkedExceptionMappings[" + mappingKey
            + "] value is not String type. "
            + "Check Spring Bean definition file.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        
        // paramsɃL[ERROR_TYPE_HEADER_NAME_KEY݂A̒l󕶎ȊȌꍇ
        if (params != null){
            String errorTypeName = params.get(ERROR_TYPE_HEADER_NAME_KEY);
            if(errorTypeName != null && errorTypeName.length() != 0){
                // errorTypeHeaderNameɂ̒lݒ肷B
                this.errorTypeHeaderName = errorTypeName;
            }
        }
        
        String[] mappingValueArray = StringUtils
                .commaDelimitedListToStringArray((String) mappingValues);

        // mappingValuesJ}ŕlQȉ̏ꍇAOX[
        if (mappingValueArray.length < 2) {
            String message = "linkedExceptionMappings[" + mappingKey
                    + "] value is insufficient. Two values are necessary. "
                    + "Check Spring Bean definition file.";
            log.error(message);
            throw new IllegalStateException(message);
        }

        // mappingValuesJ}ŕl󔒂̏ꍇAOX[
        for (int i = 0; i < mappingValueArray.length; i++) {
            mappingValueArray[i] = mappingValueArray[i].trim();
            if ("".equals(mappingValueArray[i])) {
                String message = "linkedExceptionMappings[" + mappingKey
                        + "] value[" + i + "] is empty. "
                        + "Check Spring Bean definition file.";
                log.error(message);
                throw new IllegalStateException(message);
            }
        }

        this.mappingKey = mappingKey;
        this.mappingValues = mappingValues;

        // mappingValuesJ}ŕl𑮐Ɋi[
        this.viewName = mappingValueArray[0];
        this.errorType = mappingValueArray[1];
        if (mappingValueArray.length > 2) {
            this.errorCode = mappingValueArray[2];
        }

    }

    /**
     * X|Xwb_ɃG[ʂݒ肷B
     * 
     * @param response HTTPX|X
     */
    public void setHeader(HttpServletResponse response) {
        response.setHeader(errorTypeHeaderName, this.errorType);
    }

    /**
     * ModelAndViewɃG[R[hݒ肷B
     * 
     * @param mv ModelAndView ModelAndViewIuWFNg
     */
    public void addObjectToModel(ModelAndView mv) {
        if (this.errorCode != null) {
            mv.addObject(Constants.ERRORCODE_KEY, this.errorCode);
        }
    }

    /**
     * r[擾B
     * @return r[
     */
    public String getViewName() {
        return this.viewName;
    }

}
