/*
 *
 *
 * Copyright (c) 2007, 2010 NTT DATA Corporation
 *
 */
package jp.terasoluna.toursample.uc_a01_01.blogic;

import java.util.Calendar;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.toursample.common.Constants;
import jp.terasoluna.toursample.common.blogic.PriceCalculateBLogic;
import jp.terasoluna.toursample.common.blogic.TourDetailAcquireBLogic;
import jp.terasoluna.toursample.common.dto.PriceCalculateOutput;
import jp.terasoluna.toursample.common.dto.TourDetailAcquireOutput;
import jp.terasoluna.toursample.common.exception.RecordNotFoundException;
import jp.terasoluna.toursample.common.util.DateUtil;
import jp.terasoluna.toursample.uc_a01_01.dto.InsertReserveInput;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_03_01Input;
import jp.terasoluna.toursample.uc_a01_01.dto.RP_A01_01_03_01Output;
import jp.terasoluna.toursample.uc_a01_01.exception.ReservationDeadlinePassedException;
import jp.terasoluna.toursample.uc_a01_01.exception.TourMemberOverException;

/**
 * 
 * cA[\̓o^sNXB
 * 
 * 
 * 
 * 
 */
public class RP_A01_01_03_01BLogicImpl implements BLogic<RP_A01_01_03_01Input> {

    /**
     * ʏsNullԋpꂽꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_TOURCODE = "error.UC_A01_01.00002";
	
    /**
     * cȐȂꍇ̃G[bZ[WB
     */
    public static final String ERROR_NOT_ENOUGH_SEAT = "warn.UC_A01_01.00001";

    /**
     * ONXB
     */
    private static final Log log = 
        LogFactory.getLog(RP_A01_01_03_01BLogicImpl.class);

    /**
     * ڍ׏擾WbN(ʏ)
     */
    protected TourDetailAcquireBLogic tourDetailAcquireBLogic = null;
    
    /**
     * ڍ׏擾WbN̏
     * 
     * @param tourDetailAcquireBLogic ڍ׏擾WbN
     */
    public void setTourDetailAcquireBLogic(
            TourDetailAcquireBLogic tourDetailAcquireBLogic) {

        this.tourDetailAcquireBLogic = tourDetailAcquireBLogic;
    }
    
    /**
     * ZoWbN (ʏ)
     */
    protected PriceCalculateBLogic priceCalculateBLogic = null;
    
    /**
     * ZoWbN̏B
     * 
     * @param priceCalculateBLogic ZoWbN
     */
    public void setPriceCalculateBLogic(
            PriceCalculateBLogic priceCalculateBLogic) {

        this.priceCalculateBLogic = priceCalculateBLogic;
    }
    
    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B queryDAO B
     */
    private QueryDAO queryDAO = null;

    /**
     * DAONXB<br>
     * SpringɂCX^Xݒ肳B updateDAO B
     */
    private UpdateDAO updateDAO = null;

    /**
     * queryDAO擾B
     * 
     * @return queryDAO
     */
    public QueryDAO getQueryDAO() {

        return queryDAO;
    }

    /**
     * queryDAOݒ肷B
     * 
     * @param queryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {

        this.queryDAO = queryDAO;
    }

    /**
     * updateDAO擾B
     * 
     * @return updateDAO
     */
    public UpdateDAO getUpdateDAO() {

        return updateDAO;
    }

    /**
     * updateDAOݒ肷B
     * 
     * @param updateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {

        this.updateDAO = updateDAO;
    }

    /**
     * cȐ̊mFAȂΗOsB<br>
     * cA[̗\sB<br>
     * 
     * @exception TourMemberOverException
     * @param rp_a01_01_03_01Input
     * @return rWlXWbN̎sʁABLogicResultCX^XB
     */
    public BLogicResult execute(RP_A01_01_03_01Input rp_a01_01_03_01Input) {

        //͒l擾
    	int adultCount = rp_a01_01_03_01Input.getPriceOutput().getAdultCount();
    	int childCount = rp_a01_01_03_01Input.getPriceOutput().getChildCount();
    	
    	// ʂi[B
        BLogicResult result = new BLogicResult();

        // cA[ڍ׏̎擾
        TourDetailAcquireOutput tourDetail = tourDetailAcquireBLogic
            .execute(rp_a01_01_03_01Input.getTourCode());

        // cA[ڍ׏񂪎擾łȂꍇAOsB       
        if (tourDetail == null) {
            if (log.isErrorEnabled()) {
                log.error(ERROR_NOT_TOURCODE
                          + ":cA[ڍ׏񂪎擾ł܂łB");
            }
            throw new RecordNotFoundException(ERROR_NOT_TOURCODE);
        }
        
        //݂̓t擾B
        Date today = DateUtil.getTodayDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        
        calendar.set(Calendar.HOUR_OF_DAY, 0); 
        calendar.clear(Calendar.MINUTE);
        calendar.clear(Calendar.SECOND);
        calendar.clear(Calendar.MILLISECOND);
        
        //o擾B
        Date depDay = tourDetail.getDepDay();
        
        //o݂̓t7ȓ̏ꍇ̓G[ʂ֑Jڂ
        if(calendar.getTime().after(DateUtil.getChangedByDaysDate(depDay, -7))){
            if (log.isWarnEnabled()) {
                log.warn("warn.UC_A01_01.00002:o݂̓t7ȏł͂܂B");
            }
            throw new ReservationDeadlinePassedException("warn.UC_A01_01.00002");
        }
        
        // ̌vZ ʏ𗘗păcA[{AlPAȂǂ擾
        PriceCalculateOutput priceOutput = priceCalculateBLogic
            .execute(tourDetail.getBasePrice(), adultCount, childCount);
        
        // \lB
        int reserveMember = 0;

        // \lݒ肷B
        reserveMember = adultCount + childCount;

        // cA[̍őÍsl擾B
        Integer aveRecMax = queryDAO.executeForObject(
                "UC_A01_01.selectAveRecMaxForUpdate", rp_a01_01_03_01Input,
                Integer.class);

        // cA[̍őÍslnull̏ꍇB
        if (aveRecMax == null) {

            if (log.isErrorEnabled()) {
                log.error("error.UC_A01_01.00002:cA[őÍsl擾ł܂B");
            }

            throw new RecordNotFoundException(ERROR_NOT_TOURCODE);
        }

        // ݂̗\l̍v擾B
        Integer sumCount = 
            queryDAO.executeForObject("UC_A01_01.selectSumCount", 
                                      rp_a01_01_03_01Input, 
                                      Integer.class);

        // cA[ɗ\񂪂ȂB
        if (sumCount == null) {

            sumCount = 0;

        }

        // ݂̗\\lB
        int vacantCount = aveRecMax - sumCount;

        // \\l\lƂOsB
        if (vacantCount < reserveMember) {

            if (log.isWarnEnabled()) {
                log.warn(ERROR_NOT_ENOUGH_SEAT + ":cȐ܂B");
            }

            throw new TourMemberOverException(ERROR_NOT_ENOUGH_SEAT);

        }

        // \擾B
        Date reservedDay = DateUtil.getTodayDate();

        // \ԍ擾B
        String reserveNo = 
            queryDAO.executeForObject("UC_A01_01.selectReserveNo", 
                                      rp_a01_01_03_01Input, 
                                      String.class);

        // \邽߂̃NX̐B
        InsertReserveInput input = new InsertReserveInput();

        // }ڂZbgB
        input.setReserveNo(reserveNo);
        input.setReservedDay(reservedDay);
        input.setUSER_VALUE_OBJECT(rp_a01_01_03_01Input.getUSER_VALUE_OBJECT());
        input.setAdultCount(adultCount);
        input.setChildCount(childCount);
        input.setRemarks(rp_a01_01_03_01Input.getRemarks());
        input.setTourCode(rp_a01_01_03_01Input.getTourCode());
        input.setSumPrice(priceOutput.getSumPrice());

        // \sB
        updateDAO.execute("UC_A01_01.insertReserve", input);

        // o̓NX𐶐B
        RP_A01_01_03_01Output rp_a01_01_03_01Output = new RP_A01_01_03_01Output();

        // xZoB
        Date paymentTimeLimit = DateUtil
                .getOneWeekBeforeDate(depDay);

        // o͒l̐ݒB
        rp_a01_01_03_01Output.setTourDetail(tourDetail);
        rp_a01_01_03_01Output.setPriceOutput(priceOutput);
        rp_a01_01_03_01Output.setReserveNo(reserveNo);
        rp_a01_01_03_01Output.setReservedDay(reservedDay);
        rp_a01_01_03_01Output.setPaymentMethod(PropertyUtil
                .getProperty(Constants.PAYMENT_METHOD));
        rp_a01_01_03_01Output.setPaymentAccount(PropertyUtil
                .getProperty(Constants.PAYMENT_ACCOUNT));
        rp_a01_01_03_01Output.setPaymentCompanyName(PropertyUtil
                .getProperty(Constants.PAYMENT_COMPANY_NAME));
        rp_a01_01_03_01Output.setReferenceName(PropertyUtil
                .getProperty(Constants.COMPANY_NAME));
        rp_a01_01_03_01Output.setReferenceTel(PropertyUtil
                .getProperty(Constants.COMPANY_TEL));
        rp_a01_01_03_01Output.setReferenceEmail(PropertyUtil
                .getProperty(Constants.COMPANY_MAIL));
        rp_a01_01_03_01Output.setPaymentTimeLimit(paymentTimeLimit);

        // ʂZbgB
        result.setResultObject(rp_a01_01_03_01Output);
        result.setResultString("success");

        return result;
    }

}
