/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import java.util.concurrent.ConcurrentHashMap;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ContextLoaderPlugIn;

/**
 * GeneralActionResolver
 * <p>
 * ANVpX{@link Action}тANV]oB
 * </p>
 * <p>
 * т{@link Action}Bean`̃XR[v prototype Œ`ĂƁB
 * </p>
 * <p>
 * W[sꍇ́A{@link ContextLoaderListener} ǂݍ܂Bean`t@CiapplicationContext.xmlȂǁjɂ͒`A<br>
 * {@link ContextLoaderPlugIn} ǂݍ܂Bean`t@CimoduleContext.xmlȂǁjɃW[Ƃɒ`邱ƁB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.action.handler.DefaultDelegateActionHandler
 * @see jp.terasoluna.fw.web.struts.action.resolver.ActionResolver
 * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver
 */
public class GeneralActionResolver extends AbstractActionResolver {

    /** ActionLbV */
    protected ConcurrentHashMap<String, Action> actionMap = new ConcurrentHashMap<String, Action>();

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#isBeanExist(java.lang.String,
     * org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.web.context.WebApplicationContext)
     */
    @Override
    protected boolean isBeanExist(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac) {
        if (wac == null) {
            return false;
        }
        // ANVpXɑΉBean݂ȂƂmF
        if (wac.containsBean(beanName)) {
            return false;
        }

        // ActionBeanɑΉBean݂邱ƂmF
        if (!wac.containsBean(actionName)) {
            return false;
        }
        return true;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#getActionCacheKey(java.lang.String,
     * org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.web.context.WebApplicationContext)
     */
    @Override
    protected Object getActionCacheKey(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac) {
        return beanName;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#getActionCache(java.lang.Object)
     */
    @Override
    protected Action getActionCache(Object cacheKey) {
        if (cacheKey instanceof String) {
            return this.actionMap.get(cacheKey);
        }
        return null;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#putActionCache(java.lang.Object,
     * org.apache.struts.action.Action)
     */
    @Override
    protected void putActionCache(Object cacheKey, Action action) {
        if (cacheKey instanceof String) {
            this.actionMap.put((String) cacheKey, action);
        }
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#extensionProcess(java.lang.Object,
     * org.apache.struts.action.Action, java.lang.String, org.apache.struts.action.ActionMapping,
     * org.apache.struts.action.ActionServlet, org.springframework.web.context.WebApplicationContext)
     */
    @Override
    protected Action extensionProcess(Object key, Action action,
            String beanName, ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac) {
        return action;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#isCacheEnabled(java.lang.Object,
     * org.apache.struts.action.Action, java.lang.String, org.apache.struts.action.ActionMapping,
     * org.apache.struts.action.ActionServlet, org.springframework.web.context.WebApplicationContext)
     */
    @Override
    protected boolean isCacheEnabled(Object key, Action resultAction,
            String beanName, ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac) {
        return true;
    }
}
