/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.core.Ordered;
import org.springframework.web.context.WebApplicationContext;

/**
 * ActionResolverC^tF[XB
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.action.handler.DefaultDelegateActionHandler
 */
public interface ActionResolver extends Ordered {
    /**
     * ΉANV擾
     * @param beanName Bean
     * @param mapping ActionMapping
     * @param servlet ActionServlet
     * @param wac WebApplicationContext
     * @return Action
     */
    Action getDelegateAction(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac);

    /**
     * Ώۂ̃ANVpXǂ𔻒肷
     * @param beanName Bean
     * @param mapping ActionMapping
     * @param servlet ActionServlet
     * @param wac WebApplicationContext
     * @return true:Ή false:Ή
     */
    boolean supports(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac);
}
