/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.handler;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.config.ModuleConfig;
import org.springframework.web.context.WebApplicationContext;

/**
 * ProcessValidateHandler
 * <p>
 * processValidategۂɗpB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 */
public interface ProcessValidateHandler {

    /**
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param form ANVtH[
     * @param mapping ANV}bsO
     * @param moduleConfig ModuleConfig
     * @param servlet ANVT[ubg
     * @param wac WebApplicationContext
     * @return validate(trueȂ珈pAfalseȂ璆fj
     * @throws IOException
     * @throws ServletException
     * @throws InvalidCancelException
     */
    boolean processValidate(HttpServletRequest request,
            HttpServletResponse response, ActionForm form,
            ActionMapping mapping, ModuleConfig moduleConfig,
            ActionServlet servlet, WebApplicationContext wac)
                                                             throws IOException,
                                                             ServletException,
                                                             InvalidCancelException;
}
