/*
 * Copyright (c) 2007-2008 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.fw.web.RequestUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

/**
 * SystemExceptionp̗OnhB
 *
 * <p>
 * VXeÕOo͂ƃG[ʂւ̑JڂsB<br>
 * ANVsɃVXeOƂ́A
 * G[Oo͂ŁAYANV}bsOɒ`Ă
 * VXeG[ʂɑJڂB<br>
 * {@\𗘗p邽߂ɂ́AStrutsݒt@C(struts-config.xml)
 * O[oOA܂̓ANVxOnhNXƂĎw肷B<br>
 * O[oOƁAANVxOՓ˂ĂꍇA
 * Struts̎dlɂANVxOD悳B<br>
 * uSystemExceptionɎw肳Ăꍇ́AG[bZ[Wւ̖ߍ݂sB
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>Ox̎w</legend>
 * vpeB<strong><u>logLevel</u></strong>ɉL6ނ̃Ox
 * w肷邱Ƃ\B
 * <p>
 * <ol>
 *   <li>trace</li>
 *   <li>debug</li>
 *   <li>info</li>
 *   <li>warn</li>
 *   <li>error</li>
 *   <li>fatal</li>
 * </ol>
 * </p>
 * w肵Ȃꍇ́AftHgerrorƂȂB<br>
 * logLevelw肷ꍇ́A&lt;exception&gt;^OclassName
 * <strong><u>ExceptionConfigEx</u></strong>w肷邱ƁB
 * </fieldset>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>O[oOnhOݒ</legend>
 *
 * Strutsݒt@C(struts-config.xml)Ɉȉ̂悤ɋLqB
 * <pre><code>
 * &lt;struts-config&gt;
 *   c
 *   &lt;global-exceptions&gt;
 *     &lt;exception key="some.key"
 *                path="/system-error"
 *                type="jp.terasoluna.fw.exception.SystemException"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.fw.web.struts.action.SystemExceptionHandler"&gt;
 *       &lt;set-property property="module" value="/exp"/&gt;
 *       &lt;set-property property="logLevel" value="fatal"/&gt;
 *     &lt;/exception&gt;
 *   &lt;/global-exceptions&gt;
 *   c
 * &lt;struts-config&gt;
 * </code></pre>
 * </fieldset>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>ANVxOnhOݒ</legend>
 *
 * Strutsݒt@C(struts-config.xml)Ɉȉ̂悤ɋLqB
 * <pre><code>
 * &lt;struts-config&gt;
 *   c
 *   &lt;action path="/start"
 *           type="jp.terasoluna.sample.xxx.SampleAction"
 *           name="_sampleForm"
 *           scope="session"&gt;
 *     &lt;exception key="some.key"
 *                type="jp.terasoluna.fw.exception.SystemException"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.fw.web.struts.action.SystemExceptionHandler"
 *                path="/sub-forward.do"&gt;
 *       &lt;set-property property="module" value="/sub"/&gt;
 *     &lt;/exception&gt;
 *     &lt;forward name="success" path="/system-error"/&gt;
 *   &lt;/action&gt;
 *   c
 * &lt;struts-config&gt;
 * </code></pre>
 * </fieldset>
 * </p>
 *
 * <p>
 * ȂA&lt;exception&gt;vfpathőJڐpXw
 * ĂȂꍇ́AANV}bsOinput
 * ]惊\[XƂB
 * </p>
 *
 * <p>
 * OCX^X́Areuqest<strong>PageContext.EXCEPTION</strong>̃L[Ŋi[B
 * ɂJڐJSPɂāAÖكIuWFNg exception ƂĎ擾łB
 * </p>
 *
 * @see jp.terasoluna.fw.exception.SystemException
 * @see jp.terasoluna.fw.web.struts.action.ExceptionConfigEx
 * @see jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler
 * @see javax.servlet.jsp.PageContext
 *
 */
public class SystemExceptionHandler extends DefaultExceptionHandler {

    /**
     * ONXB
     */
    @SuppressWarnings("unused")
    private static Log log
    = LogFactory.getLog(SystemExceptionHandler.class);

    /**
     * SystemExceptionOnh̃Gg|CgB
     *
     * @param ex O
     * @param eConfig ORtBO
     * @param mapping ANV}bsO
     * @param formInstance ANVtH[
     * @param request HTTPNGXg
     * @param response HTTPX|X
     *
     * @return Jڏ
     *
     * @throws ServletException T[ubgO
     *
     * @see jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler#execute(
     *  java.lang.Exception,
     *  org.apache.struts.config.ExceptionConfig,
     *  org.apache.struts.action.ActionMapping,
     *  org.apache.struts.action.ActionForm,
     *  javax.servlet.http.HttpServletRequest,
     *  javax.servlet.http.HttpServletResponse
     *  )
     */
    @Override
    public ActionForward execute(Exception ex,
                                 ExceptionConfig eConfig,
                                 ActionMapping mapping,
                                 ActionForm formInstance,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
            throws ServletException {
        // ytH[hݒ肷z
        // pathɂtH[h悪w肳Ȃꍇ́A
        // ANV}bsOinputftHgƂB
        String path = null;
        if (eConfig.getPath() != null) {
            path = eConfig.getPath();
        } else {
            path = mapping.getInput();
        }
        ActionForward forward = new ActionForward(path);
        String logLevel = null;

        // yJڐݒ肷z
        if (eConfig instanceof ExceptionConfigEx) {
            //Jڐ惂W[ݒ肳ĂƂAW[ݒ肷
            forward.setModule(((ExceptionConfigEx) eConfig).getModule());
            // Ox擾
            logLevel = ((ExceptionConfigEx) eConfig).getLogLevel();
        }

        // ySystemException̏ꍇAG[L[ƃG[bZ[W̒usz
        if (ex instanceof SystemException) {
            SystemException se = (SystemException) ex;

            // yNGXg烁bZ[W\[X擾Bz
            MessageResources resources = null;

            // XR[v烁bZ[W\[X擾ۂ̃ohL[擾B
            String bundle = eConfig.getBundle();
            if (bundle == null) {
                // struts-config.xmlmessage-resources
                // bundlew肳ĂȂꍇA
                // ftHg̃ohL[ݒ肷
                bundle = Globals.MESSAGES_KEY;
            }

            // NGXg̎擾݂B
            resources = (MessageResources) request.getAttribute(bundle);
            if (resources == null) {
                // NGXgɂȂ΃AvP[V̎擾݂B
                resources = (MessageResources) RequestUtil.getServletContext(
                        request).getAttribute(bundle);
            }

            // yG[L[ƃG[bZ[W̒usz
            // SystemExceptioñG[L[G[bZ[WɒuB
            String message = null;
            if (resources == null) {
                // \[X擾łȂꍇ̓G[L[bZ[WƂ
                message = se.getErrorCode();
            } else {
                message = getErrorMessage(request, se, resources);
            }
            se.setMessage(message);

            // yʕ\pActionMessageݒ肷z
            String key = eConfig.getKey();
            ActionMessage error = null;
            if (resources != null) {
                // G[bZ[W̒u擾
                String[] options = se.getOptions();

                if (options != null && options.length > 0) {
                    error = new ActionMessage(key, options);
                } else {
                    error = new ActionMessage(key);
                }
            } else {
                // ʂłĂbZ[W\[Xꍇ̓G[L[bZ[Wɂ
                error = new ActionMessage(key, false);
            }
            super.storeException(request,
                    key,
                    error,
                    forward,
                    eConfig.getScope());

            // ϊꂽObZ[WAX^bNg[X
            // ZbVnbVlOɏo
            String sessionHash = RequestUtil.getSessionHash(request);
            logException(logLevel, "sessionHash = " + sessionHash);
            logException(logLevel, ExceptionUtil.getStackTrace(se));

            // yuςSystemExceptionݒ肷z
            // VXeOJSPG[y[W exception Ƃ
            // 擾ł悤 request ɐݒ肷
            request.setAttribute(PageContext.EXCEPTION, se);
        }

        // VXeG[́AANV}bsO̐ݒɉđJڂB
        return forward;
    }

    /**
     * bZ[W\[Xɑ΂ăbZ[WL[w肷邱Ƃ
     * G[bZ[W擾B
     *
     * @param req HTTPNGXg
     * @param se SystemException
     * @param resources bZ[W\[X
     *
     * @return G[bZ[W
     */
    private String getErrorMessage(HttpServletRequest req,
                                    SystemException se,
            MessageResources resources) {
        String errorCode = se.getErrorCode();
        // bZ[WL[w肳ĂȂƂAnullԋpB
        if (errorCode == null) {
            return null;
        }

        String[] options = se.getOptions();
        if (options == null) {
            return resources.getMessage(req.getLocale(), errorCode);
        }
        return resources.getMessage(req.getLocale(), errorCode, options);
    }

    /**
     * nh̃K[擾B
     *
     * @return K[
     */
    @Override
    protected Log getLogger() {
        return log;
    }
}
