/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;

import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;


/**
 * ServletResponse ̃bNAbvNXB
 * <BR><BR>
 * ɁATERASOLUNA t[[N̊g̒P̃eXgp̃NXŁA
 * ƖAvP[ṼeXgŕKvɂȂ邱Ƃ͂قƂǂȂƎvB
 * 
 */
public class MockServletResponse implements ServletResponse {

    /**
     * GR[fBO
     */
    private String characterEncoding = null;

    /**
     * o̓Xg[
     */
    private OutputStream outputStream = null;

    /**
     * PrintWriter
     */
    private PrintWriter printWriter = null;

    /**
     * ContentLength
     */
    private int contentLength = -1;

    /**
     * ContentType
     */
    private String contentType = null;

    /**
     * BufferSize
     */
    private int bufferSize = 0;

    /**
     * Commitꂽǂ
     */
    private boolean isCommitted = false;

    /**
     * Locale
     */
    private Locale locale = Locale.getDefault();

    /**
     * @see javax.servlet.ServletResponse#getCharacterEncoding()
     */
    public String getCharacterEncoding() {
        return characterEncoding;
    }

    /**
     * őMMIMEbZ[W{fBɎgp
     * GR[fBO̖Oݒ肷B
     *
     * @param characterEncoding GR[fBO
     */
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    /**
     * @see javax.servlet.ServletResponse#getOutputStream()
     */
    public ServletOutputStream getOutputStream() throws IOException {
        return (ServletOutputStream) outputStream;
    }

    /**
     * ɑ΂āAoCif[^ôɓKOutputStreamݒ
     * B
     *
     * @param outputStream oCif[^opo̓Xg[
     */
    public void setOutputStream(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
    }

    /**
     * @see javax.servlet.ServletResponse#getOutputStream()
     */
    public java.io.PrintWriter getWriter() throws IOException {
        return this.printWriter;
    }

    /**
     * eLXgNCAg֑M̂Ɏgp
     * @param printWriter IuWFNgݒ肷B
     */
    public void setWriter(PrintWriter printWriter) throws IOException {
        this.printWriter = printWriter;
    }
    
    /**
     * @see javax.servlet.ServletResponse#setContentLength(int)
     */
    public void setContentLength(int len) {
        this.contentLength = len;
    }

    /**
     * @see javax.servlet.ServletResponse#setContentType(String)
     */
    public void setContentType(String type) {
        contentType = type;
    }

    /**
     * @see javax.servlet.ServletResponse#setBufferSize(int)
     */
    public void setBufferSize(int size) {
        bufferSize = size;
    }

    /**
     * @see javax.servlet.ServletResponse#getBufferSize()
     */
    public int getBufferSize() {
        return bufferSize;
    }

    /**
     * @see javax.servlet.ServletResponse#flushBuffer()
     */
    public void flushBuffer() throws IOException {
        this.isCommitted = true;
    }

    /**
     * @see javax.servlet.ServletResponse#resetBuffer()
     */
    public void resetBuffer() {
        if (isCommitted) {
            throw new IllegalStateException();
        }
    }

    /**
     * @see javax.servlet.ServletResponse#isCommitted()
     */
    public boolean isCommitted() {
        return this.isCommitted;
    }

    /**
     * @see javax.servlet.ServletResponse#reset()
     */
    public void reset() {
        if (isCommitted) {
            throw new IllegalStateException();
        }
    }
    
    /**
     * @see javax.servlet.ServletResponse#setLocale(Locale)
     */
    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    /**
     * @see javax.servlet.ServletResponse#getLocale(Locale)
     */
    public Locale getLocale() {
        return this.locale;
    }

}

