/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.testcase;

import jp.terasoluna.fw.ex.unit.util.JndiUtils;

/**
 * DAOsxeXgP[X(JNDIl[~OT[rXbNN)
 * 
 * <pre>
 * {@link DaoTestCase}̊geXgP[XłB
 * Bean`t@CǂݍݑOɂāAReLXg[gȉ
 * META-INF/context.xml(ftHg)ɐݒ肳Ăf[^\[Xf[^\[X쐬A
 * bNJNDIl[~OT[rXɓo^܂B
 * 
 * ɂBean`t@CJNDIoR̃f[^\[X`\ɂȂ܂B
 * ({@link org.springframework.jndi.JndiObjectFactoryBean})
 * 
 * ႦMETA-INF/context.xmlɈȉ̐ݒ肪LꍇA
 * HSQLDBp̃f[^\[X쐬܂B
 * f[^\[Xjava:comp/env/jdbc/dataSourcejdbc/dataSource
 * o^܂B
 * 
 * &lt;!-- HSQLDB̏ꍇ --&gt;
 * &lt;Context&gt;
 *   &lt;Resource
 *      name=&quot;jdbc/dataSource&quot; type=&quot;javax.sql.DataSource&quot;
 *      driverClassName=&quot;org.hsqldb.jdbcDriver&quot; username=&quot;sa&quot; password=&quot;&quot;
 *      url=&quot;jdbc:hsqldb:mem:terasoluna&quot;
 *      maxIdle=&quot;2&quot; maxWait=&quot;5000&quot; maxActive=&quot;4&quot;/&gt;
 * &lt;/Context&gt;
 * 
 * ɂAf[^\[Xȉ̗lɒ`܂ܒP̃eXg{ł܂B
 * 
 *  &lt;bean id=&quot;dataSource&quot; class=&quot;org.springframework.jndi.JndiObjectFactoryBean&quot;&gt;
 *       &lt;property name=&quot;jndiName&quot; value=&quot;java:comp/env/jdbc/dataSource&quot; /&gt;
 *  &lt;/bean&gt;
 * </pre>
 */
public abstract class JndiActivatedDaoTestCase extends DaoTestCase {

    /**
     * Bean`t@CpX擾OB
     * 
     * <pre>
     * Bean`t@CpX擾OɁA
     * JNDIl[~OT[rXbN(f[^\[Xo^)N܂B
     * </pre>
     */
    @Override
    protected final void beforeGetConfig() {
        JndiUtils.activateDefaultNamingContext();
        super.beforeGetConfig();
    }
}
