/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.mock;

import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.QueryDAO;

/**
 * {@link QueryDAO}̃bNNXłB
 * 
 * <p>
 * {@link QueryDAO}̊e\bh̕Ԃl{@link MockQueryDao#addResult(Object)}ɂĐݒł܂B
 * <code>addResult</code>̈{@link RuntimeException}pNXݒ肵ꍇA
 * {@link QueryDAO}̃\bhsɂX[܂B <br>
 * ȉɎgp܂B<br>
 * ̋Ɩɑ΂
 * </p>
 * 
 * <pre>
 * public class SampleBLogic1 implements BLogic&lt;SampleInput&gt; {
 *     private QueryDAO queryDAO;
 * 
 *     public BLogicResult execute(SampleInput params) {
 *         List&lt;String&gt; dataList = getQueryDAO().executeForObjectList(
 *                 &quot;selectData01&quot;, params);
 * 
 *         SampleOutput1 output = new SampleOutput1();
 *         output.setDataList(dataList);
 * 
 *         BLogicResult result = new BLogicResult();
 *         result.setResultString(&quot;success&quot;);
 *         result.setResultObject(output);
 * 
 *         return result;
 *     }
 * 
 *     public void setQueryDAO(QueryDAO queryDAO) {
 *         this.queryDAO = queryDAO;
 *     }
 * 
 *     public QueryDAO getQueryDAO() {
 *         return queryDAO;
 *     }
 * }
 * 
 * </pre>
 * <p>
 * eXgR[h͈ȉ̂悤ɋLq܂
 * </p>
 * 
 * <pre>
 * SampleBLogic1 blogic = new SampleBLogic1();
 * MockQueryDao queryDAO = new MockQueryDao();
 * // QueryDAO#executeForObjectList̕Ԃlݒ
 * queryDAO.addResult(Arrays.asList(&quot;AAA&quot;, &quot;BBB&quot;, &quot;CCC&quot;));
 * blogic.setQueryDAO(queryDAO);
 * 
 * // ͒lݒ
 * SampleInput input = new SampleInput();
 * input.setData1(&quot;A&quot;);
 * input.setData2(&quot;B&quot;);
 * 
 * // s
 * BLogicResult result = blogic.execute(input);
 * 
 * // Ɩʂ̊mF
 * AssertUtils.assertBLogicSuccess(result);
 * SampleOutput1 output = (SampleOutput1) result.getResultObject();
 * List&lt;String&gt; dataList = output.getDataList();
 * AssertUtils
 *         .assertCollectionEquals(Arrays.asList(&quot;AAA&quot;, &quot;BBB&quot;, &quot;CCC&quot;), dataList);
 * 
 * // DAOp[^̊mF
 * AssertUtils.assertCollectionSizeEquals(1, queryDAO.getParams());
 * DaoParam param = queryDAO.getParams().get(0);
 * assertEquals(input, param.getBindParams());
 * 
 * </pre>
 */
public class MockQueryDao extends AbstractMockDao implements QueryDAO {

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForMap(java.lang.String,
     * java.lang.Object)
     */
    public Map<String, Object> executeForMap(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollMap();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForMapArray(java.lang.String,
     * java.lang.Object)
     */
    public Map<String, Object>[] executeForMapArray(String sqlId,
            Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollMapArray();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForMapArray(java.lang.String,
     * java.lang.Object, int, int)
     */
    public Map<String, Object>[] executeForMapArray(String sqlId,
            Object bindParams, int beginIndex, int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, beginIndex, maxCount));
        return pollMapArray();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForMapList(java.lang.String,
     * java.lang.Object)
     */
    public List<Map<String, Object>> executeForMapList(String sqlId,
            Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return pollMapList();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForMapList(java.lang.String,
     * java.lang.Object, int, int)
     */
    public List<Map<String, Object>> executeForMapList(String sqlId,
            Object bindParams, int beginIndex, int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, beginIndex, maxCount));
        return pollMapList();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForObject(java.lang.String,
     * java.lang.Object, java.lang.Class)
     */
    @SuppressWarnings("unchecked")
    public <E> E executeForObject(String sqlId, Object bindParams,
            @SuppressWarnings("rawtypes") Class clazz) {
        addParam(new DaoParam(sqlId, bindParams, clazz));
        return (E) poll();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * jp.terasoluna.fw.dao.QueryDAO#executeForObjectArray(java.lang.String,
     * java.lang.Object, java.lang.Class)
     */
    @SuppressWarnings("unchecked")
    public <E> E[] executeForObjectArray(String sqlId, Object bindParams,
            @SuppressWarnings("rawtypes") Class clazz) {
        addParam(new DaoParam(sqlId, bindParams, clazz));

        return (E[]) pollArray();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * jp.terasoluna.fw.dao.QueryDAO#executeForObjectArray(java.lang.String,
     * java.lang.Object, java.lang.Class, int, int)
     */
    @SuppressWarnings("unchecked")
    public <E> E[] executeForObjectArray(String sqlId, Object bindParams,
            @SuppressWarnings("rawtypes") Class clazz, int beginIndex,
            int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, clazz, beginIndex, maxCount));
        return (E[]) pollArray();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForObjectList(java.lang.String,
     * java.lang.Object)
     */
    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlId, Object bindParams) {
        addParam(new DaoParam(sqlId, bindParams));
        return (List<E>) pollList();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.terasoluna.fw.dao.QueryDAO#executeForObjectList(java.lang.String,
     * java.lang.Object, int, int)
     */
    @SuppressWarnings("unchecked")
    public <E> List<E> executeForObjectList(String sqlId, Object bindParams,
            int beginIndex, int maxCount) {
        addParam(new DaoParam(sqlId, bindParams, beginIndex, maxCount));
        return (List<E>) pollList();
    }

}
