/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;

/**
 * {@link jp.terasoluna.fw.validation.springmodules.CommonsValidatorEx}
 * NX̃eXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Jakaruta-CommonsValidatorgNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.validation.springmodules.CommonsValidatorEx
 */
public class CommonsValidatorExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CommonsValidatorExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public CommonsValidatorExTest(String name) {
        super(name);
    }

    /**
     * testGetValidatorException01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA,C <br>
     * <br>
     * ͒lF(O) this.validatorException:ValidatorException<br>
     * 
     * <br>
     * ҒlF(߂l)
     * ValidatorException:this.validatorExceptionƓCX^XValidatorException<br>
     * 
     * <br>
     * ɐݒ肳ĂvalidatorExceptionԋp邱Ƃ̃eXgB <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testGetValidatorException01() throws Exception {
        // O
        ValidatorResources resources = new ValidatorResources();
        CommonsValidatorEx commonsValidatorEx = new CommonsValidatorEx(
                resources, null);
        ValidatorException validatorException = new ValidatorException();
        UTUtil.setPrivateField(commonsValidatorEx, "validatorException",
                validatorException);

        // eXg{
        ValidatorException resultValidatorException = commonsValidatorEx
                .getValidatorException();

        // 
        assertSame(validatorException, resultValidatorException);
    }

    /**
     * testValidate01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF(O) super.validate():OX[Ȃ<br>
     * 
     * <br>
     * ҒlF(߂l) ValidatorResults:super.validate()̌<br>
     * (ԕω) this.validatorException:null<br>
     * 
     * <br>
     * super.validate()OX[ȂꍇAsuper.validate()̌ʂԋp邱Ƃ̃eXgBB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testValidate01() throws Exception {
        // O
        CommonsValidatorEx_ValidatorResourcesStub01 resources = 
            new CommonsValidatorEx_ValidatorResourcesStub01();
        Form form = new Form();
        resources.setForm(form);

        // super.validate()̃I[o[Ch͂łȂ߁A
        // Field̃bNNX쐬āA
        // super.validate()ĂяoAfield.validate()
        // ʂ𑀍삷B
        // super.validate()́Afield.validate()̌ʂ}[WĕԋpĂB
        CommonsValidatorEx_FieldStub01 field =
            new CommonsValidatorEx_FieldStub01();
        List<Field> lFields = new ArrayList<Field>();
        lFields.add(field);
        UTUtil.setPrivateField(form, "lFields", lFields);

        ValidatorResults validatorResults = new ValidatorResults();
        Map<String, ValidatorResult> hResults
            = new HashMap<String, ValidatorResult>();
        ValidatorResult validatorResult = new ValidatorResult(field);
        hResults.put("test", validatorResult);
        UTUtil.setPrivateField(validatorResults, "hResults", hResults);
        
        field.validateReturn = validatorResults;
        
        CommonsValidatorEx commonsValidatorEx = new CommonsValidatorEx(
                resources, "formName");

        // eXg{
        ValidatorResults result = commonsValidatorEx.validate();

        // 
        // resultAfield.validate()̌ʂ܂ł邩mFB
        Map resultHResults = (Map) UTUtil.getPrivateField(result, "hResults");
        assertEquals(1, resultHResults.size());
        assertSame(validatorResult, resultHResults.get("test"));
    }

    /**
     * testValidate02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA,G <br>
     * <br>
     * ͒lF(O) super.validate():ValidatorExceptionX[<br>
     * 
     * <br>
     * ҒlF(ԕω) O:super.validate()X[ValidatorException<br>
     * (ԕω) this.validatorException:super.validate()X[ValidatorException<br>
     * 
     * <br>
     * super.validate()ValidatorExceptionX[ꍇA̗O𑮐ɐݒ肵Â܂܃X[邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testValidate02() throws Exception {
        // O
        CommonsValidatorEx_ValidatorResourcesStub01 resources = 
            new CommonsValidatorEx_ValidatorResourcesStub01();
        Form form = new Form();
        resources.setForm(form);

        // super.validate()̃I[o[Ch͂łȂ߁A
        // Field̃bNNX쐬āA
        // super.validate()ĂяoAfield.validate()
        // ʂ𑀍삷B
        // super.validate()́Afield.validate()X[validatorException
        // ̂܂܃X[ĂB
        CommonsValidatorEx_FieldStub01 field =
            new CommonsValidatorEx_FieldStub01();
        List<Field> lFields = new ArrayList<Field>();
        lFields.add(field);
        UTUtil.setPrivateField(form, "lFields", lFields);

        field.validatorException = new ValidatorException();
        
        CommonsValidatorEx commonsValidatorEx = new CommonsValidatorEx(
                resources, "formName");

        // eXg{
        try {
            commonsValidatorEx.validate();
            fail();
        } catch (ValidatorException e) {
            // 
            // field.validate()X[ValidatorExceptionƓCX^XmFB
            assertSame(field.validatorException, e);
            assertSame(e, commonsValidatorEx.getValidatorException());
        }
    }
    
    /**
     * testClear01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF(O) this.validatorException:ValidatorException<br>
     *         
     * <br>
     * ҒlF(ԕω) this.validatorException:null<br>
     *         
     * <br>
     * ɐݒ肳ĂvalidatorExceptionNA邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testClear01() throws Exception {
        // O
        ValidatorResources resources = new ValidatorResources();
        CommonsValidatorEx commonsValidatorEx = new CommonsValidatorEx(
                resources, null);
        ValidatorException validatorException = new ValidatorException();
        UTUtil.setPrivateField(commonsValidatorEx, "validatorException",
                validatorException);

        // eXg{
        commonsValidatorEx.clear();
        ValidatorException result = (ValidatorException)UTUtil
            .getPrivateField(commonsValidatorEx, "validatorException");

        // 
        assertNull(result);
    }
}
