/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.ex.unit.util.CaseInsensitiveMap;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTemplateUtils {
    public static void execute(JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        jdbcTemplate.execute(sql);
    }

    public static int update(JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.update(sql);
    }

    public static int update(JdbcTemplate jdbcTemplate, String sql, Object[] args) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.update(sql, args);
    }

    public static int[] batchUpdate(JdbcTemplate jdbcTemplate, String ... sqls) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        Assert.notEmpty((Object[])sqls);
        return jdbcTemplate.batchUpdate(sqls);
    }

    public static long queryForLong(JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.queryForLong(sql);
    }

    public static long queryForLong(JdbcTemplate jdbcTemplate, String sql, Object[] args) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.queryForLong(sql, args);
    }

    public static int queryForInt(JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.queryForInt(sql);
    }

    public static int queryForInt(JdbcTemplate jdbcTemplate, String sql, Object[] args) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.queryForInt(sql, args);
    }

    public static String queryForString(JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForObject(jdbcTemplate, sql, String.class);
    }

    public static String queryForString(JdbcTemplate jdbcTemplate, String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.queryForObject(jdbcTemplate, sql, args, String.class);
    }

    public static <T> T queryForObject(JdbcTemplate jdbcTemplate, String sql, Class<T> requiredType) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return (T)jdbcTemplate.queryForObject(sql, requiredType);
    }

    public static <T> T queryForObject(JdbcTemplate jdbcTemplate, String sql, Object[] args, Class<T> requiredType) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return (T)jdbcTemplate.queryForObject(sql, args, requiredType);
    }

    public static Map<String, ?> queryForRowMap(JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        Map result = jdbcTemplate.queryForMap(sql);
        return new CaseInsensitiveMap(result);
    }

    public static Map<String, ?> queryForRowMap(JdbcTemplate jdbcTemplate, String sql, Object[] args) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        Map result = jdbcTemplate.queryForMap(sql, args);
        return new CaseInsensitiveMap(result);
    }

    public static <T> T queryForRowObject(JdbcTemplate jdbcTemplate, String sql, Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return (T)jdbcTemplate.queryForObject(sql, (RowMapper)rowMapper);
    }

    public static <T> T queryForRowObject(JdbcTemplate jdbcTemplate, String sql, Object[] args, Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return (T)jdbcTemplate.queryForObject(sql, args, (RowMapper)rowMapper);
    }

    public static <T> List<T> queryForSingleColumnList(JdbcTemplate jdbcTemplate, String sql, Class<T> elementType) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.queryForList(sql, elementType);
    }

    public static <T> List<T> queryForSingleColumnList(JdbcTemplate jdbcTemplate, String sql, Object[] args, Class<T> elementType) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return jdbcTemplate.queryForList(sql, args, elementType);
    }

    private static List<Map<String, ?>> convertToCaseInsensitiveMapList(List<?> list) {
        ArrayList result = new ArrayList();
        if (list != null) {
            for (Object o : list) {
                result.add(new CaseInsensitiveMap((Map)o));
            }
        }
        return result;
    }

    public static List<Map<String, ?>> queryForRowMapList(JdbcTemplate jdbcTemplate, String sql) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return JdbcTemplateUtils.convertToCaseInsensitiveMapList(jdbcTemplate.queryForList(sql));
    }

    public static List<Map<String, ?>> queryForRowMapList(JdbcTemplate jdbcTemplate, String sql, Object[] args) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return JdbcTemplateUtils.convertToCaseInsensitiveMapList(jdbcTemplate.queryForList(sql, args));
    }

    public static List<Map<String, ?>> queryForRowMapList(JdbcTemplate jdbcTemplate, Class<?> clazz) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        return JdbcTemplateUtils.convertToCaseInsensitiveMapList(jdbcTemplate.queryForList(JdbcTemplateUtils.createSelectSql(clazz)));
    }

    public static <T> List<T> queryForRowObjectList(JdbcTemplate jdbcTemplate, String sql, Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return jdbcTemplate.query(sql, (RowMapper)rowMapper);
    }

    public static <T> List<T> queryForRowObjectList(JdbcTemplate jdbcTemplate, String sql, Object[] args, Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return jdbcTemplate.query(sql, args, (RowMapper)rowMapper);
    }

    public static <T> List<T> queryForRowObjectList(JdbcTemplate jdbcTemplate, Class<T> clazz) throws DataAccessException {
        Assert.notNull((Object)jdbcTemplate);
        Assert.notNull(clazz);
        String[] header = ReflectionUtils.createFiledNames(clazz);
        String sql = JdbcTemplateUtils.createSelectSql(clazz.getSimpleName(), header);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(clazz, false);
        return jdbcTemplate.query(sql, (RowMapper)rowMapper);
    }

    public static String createSelectSql(String tableName, String[] fieldNames) {
        Assert.notNull((Object)tableName);
        Assert.notNull((Object)fieldNames);
        String sql = "SELECT " + StringUtils.join((Object[])fieldNames, (String)",") + " FROM " + tableName;
        return sql;
    }

    public static String createSelectSql(String tableName, Class<?> clazz) {
        Assert.notNull(clazz);
        return JdbcTemplateUtils.createSelectSql(tableName, ReflectionUtils.createFiledNames(clazz));
    }

    public static String createSelectSql(Class<?> clazz) {
        Assert.notNull(clazz);
        return JdbcTemplateUtils.createSelectSql(clazz.getSimpleName(), clazz);
    }

    public static String createInsertSql(String tableName, String[] fieldNames) {
        Assert.notNull((Object)tableName);
        Assert.notNull((Object)fieldNames);
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableName);
        sb.append("(");
        sb.append(StringUtils.join((Object[])fieldNames, (String)","));
        sb.append(") VALUES (");
        for (int i = 0; i < fieldNames.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String createInsertSql(String tableName, Class<?> clazz) {
        return JdbcTemplateUtils.createInsertSql(tableName, ReflectionUtils.createFiledNames(clazz));
    }

    public static String createInsertSql(Class<?> clazz) {
        Assert.notNull(clazz);
        return JdbcTemplateUtils.createInsertSql(clazz.getSimpleName(), ReflectionUtils.createFiledNames(clazz));
    }
}

