/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.exceptionhandler.view;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.rich.functionsample.exceptionhandler.bean.ExceptionData;

import org.springframework.web.servlet.view.AbstractView;

/**
 * O𔭐r[NX
 *
 */
public class ExceptionHandlerView extends AbstractView {

    /** 
     * O𔭐B<br>
     * Oɖ肪ĔO͏ȂB
     * @param model Ɩ̌
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @throws Exception O
     */
    @Override
    protected void renderMergedOutputModel(Map model,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        //O擾
        ExceptionData data = (ExceptionData) model.get(Constants.RESULT_KEY);
        String className = data.getClassName();
        throw (Exception) Class.forName(className).newInstance();
    }
}
