/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.rich.tutorial.service.validation;

import java.util.Calendar;
import java.util.Date;
import org.springframework.validation.Errors;
import jp.terasoluna.fw.util.DateUtil;
import jp.terasoluna.fw.validation.springmodules.BaseMultiFieldValidator;
import jp.terasoluna.rich.tutorial.service.bean.UserBean;

/**
 * ͂ꂽNƁAN̑֓̓`FbNsB
 *
 */
public class AgeValidator extends BaseMultiFieldValidator {
    /**
     * ͂ꂽNƁAN̑֓̓`FbNsB
     *
     * @param obj ΏۂJavaBeaniUserBeanj
     * @param errors G[
     */
    @Override
    protected void validateMultiField(Object obj, Errors errors) {
        
    	// LXg\̃`FbN
        if (!(obj instanceof UserBean)) {
            errors.reject("error.common.00001");
            return;
        }
        
        // LXg
        UserBean userBean = (UserBean) obj;
        
        // NƓt̎擾
        int age = userBean.getAge();
        Date birth = userBean.getBirth();
        
        // ͂ꂽNƁAN̑֓̓`FbN
        if (!validate(birth, age)) {
            String[] msg = { "age", "birth" };
            errors.rejectValue("birth", "error.multiField", msg, null);
        }
    }

    /**
     * ͂ꂽNƁAN̑֓̓`FbNsB
     *
     * @param birth N
     * @param age N
     * @return `FbN
     */
    private boolean validate(Date birth, int age) {
        // N{NCalendar𐶐
        Calendar calendarBirth = Calendar.getInstance();
        calendarBirth.setTime(birth);
        calendarBirth.add(Calendar.YEAR, age);
        
        // N{N{PNCalendar𐶐
        Calendar calendarNextYear = Calendar.getInstance();
        calendarNextYear.setTime(birth);
        calendarNextYear.add(Calendar.YEAR, age + 1);
        
        // ݓtCalendar𐶐
        Calendar calendarSystemTime = Calendar.getInstance();
        calendarSystemTime.setTime(DateUtil.getSystemTime());
       
        if (calendarBirth.before(calendarSystemTime)
                && calendarNextYear.after(calendarSystemTime)) {
            return true;
        } else {
            return false;
        }
    }
}
