/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ZENKAKU_LIST = "\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff3b\uffe5\uff3d\uff3e\uff3f\uff40\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\uff5b\uff5c\uff5d\uffe3\u3002\u300c\u300d\u3001\u30fb\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7\u30c3\u30fc\u30a2\u30a4\u30a8\u30aa\u30ca\u30cb\u30cc\u30cd\u30ce\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30f3\u309b\u309c\u3000";
    private static final String ZENKAKU_KASATAHA_LIST = "\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30cf\u30d2\u30d5\u30d8\u30db\u30a6";
    private static final String ZENKAKU_GAZADABA_LIST = "\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30f4";
    private static final Character ZENKAKU_WA_DAKUTEN = new Character('\u30f7');
    private static final Character ZENKAKU_WO_DAKUTEN = new Character('\u30fa');
    private static final String ZENKAKU_PA_LIST = "\u30d1\u30d4\u30d7\u30da\u30dd";
    private static final String HANKAKU_LIST = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\uff61\uff62\uff63\uff64\uff65\uff67\uff68\uff69\uff6a\uff6b\uff6c\uff6d\uff6e\uff6f\uff70\uff71\uff72\uff74\uff75\uff85\uff86\uff87\uff88\uff89\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9d\uff9e\uff9f ";
    private static final String HANKAKU_KASATAHA_LIST = "\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff8a\uff8b\uff8c\uff8d\uff8e\uff73";
    private static final String HANKAKU_HA_LIST = "\uff8a\uff8b\uff8c\uff8d\uff8e";
    public static final String LIKE_ESC_CHAR = "~";

    public static boolean isWhitespace(char c) {
        return c == ' ';
    }

    public static boolean isZenHankakuSpace(char c) {
        return c == '\u3000' || c == ' ';
    }

    public static String rtrim(String str) {
        int length;
        if (str == null) {
            return null;
        }
        for (length = str.length(); 0 < length && StringUtil.isWhitespace(str.charAt(length - 1)); --length) {
        }
        return length < str.length() ? str.substring(0, length) : str;
    }

    public static String ltrim(String str) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (start = 0; start < length && StringUtil.isWhitespace(str.charAt(start)); ++start) {
        }
        return start > 0 ? str.substring(start, length) : str;
    }

    public static String trim(String str) {
        return StringUtils.trim((String)str);
    }

    public static String rtrimZ(String str) {
        int length;
        if (str == null) {
            return null;
        }
        for (length = str.length(); 0 < length && StringUtil.isZenHankakuSpace(str.charAt(length - 1)); --length) {
        }
        return length < str.length() ? str.substring(0, length) : str;
    }

    public static String ltrimZ(String str) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (start = 0; start < length && StringUtil.isZenHankakuSpace(str.charAt(start)); ++start) {
        }
        return start > 0 ? str.substring(start, length) : str;
    }

    public static String trimZ(String str) {
        return StringUtil.ltrimZ(StringUtil.rtrimZ(str));
    }

    public static String toShortClassName(String longClassName) {
        return ClassUtils.getShortClassName((String)longClassName);
    }

    public static String getExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        return index < 0 ? "" : name.substring(index);
    }

    public static String toHexString(byte[] byteArray, String delim) {
        if (delim == null) {
            delim = "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            String hex;
            if (i > 0) {
                sb.append(delim);
            }
            if ((hex = Integer.toHexString(byteArray[i] & 0xFF).toUpperCase()).length() < 2) {
                sb.append("0");
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String capitalizeInitial(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String[] parseCSV(String csvString) {
        if (csvString == null) {
            return new String[0];
        }
        if ("".equals(csvString)) {
            return new String[]{csvString};
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] chars = csvString.toCharArray();
        int prevCommaIndex = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ',') {
                if (i == prevCommaIndex + 1) {
                    result.add("");
                } else {
                    result.add(new String(chars, prevCommaIndex + 1, i - (prevCommaIndex + 1)));
                }
                if (i == chars.length - 1) {
                    result.add("");
                }
                prevCommaIndex = i;
                continue;
            }
            if (i != chars.length - 1) continue;
            result.add(new String(chars, prevCommaIndex + 1, i - (prevCommaIndex + 1) + 1));
        }
        return result.toArray(new String[0]);
    }

    public static String[] parseCSV(String csvString, String escapeString) {
        if (csvString == null) {
            return new String[0];
        }
        if ("".equals(csvString)) {
            return new String[]{csvString};
        }
        ArrayList<String> result = new ArrayList<String>();
        char[] chars = csvString.toCharArray();
        StringBuilder str = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!escape && chars[i] == ',') {
                result.add(str.toString());
                str = new StringBuilder();
                escape = false;
                continue;
            }
            if (escapeString != null && escapeString.indexOf(chars[i]) >= 0) {
                if (escape) {
                    str.append(chars[i]);
                    escape = false;
                    continue;
                }
                escape = true;
                continue;
            }
            escape = false;
            str.append(chars[i]);
        }
        result.add(str.toString());
        return result.toArray(new String[0]);
    }

    public static String dump(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        for (Object key : map.keySet()) {
            String appendKey = null;
            appendKey = key == null ? "null" : key.toString();
            sb.append(appendKey);
            sb.append('=');
            Object valueObj = map.get(key);
            if (valueObj == null) {
                sb.append("null");
            } else if (valueObj.getClass().isArray()) {
                sb.append(StringUtil.getArraysStr((Object[])valueObj));
            } else {
                sb.append(valueObj.toString());
            }
            sb.append(LINE_SEP);
        }
        sb.append("}");
        return sb.toString();
    }

    public static String getArraysStr(Object[] arrayObj) {
        return ArrayUtils.toString((Object)arrayObj, null);
    }

    public static String hankakuToZenkaku(String value) {
        if (value == null || "".equals(value)) {
            return value;
        }
        char[] chars = value.toCharArray();
        StringBuilder returnValue = new StringBuilder();
        String getValue = null;
        Character nextvalue = null;
        for (int i = 0; i < chars.length; ++i) {
            getValue = StringUtil.getZenkakuMoji(chars[i]);
            if (getValue != null) {
                returnValue.append(getValue);
                continue;
            }
            if (i == chars.length - 1) {
                getValue = StringUtil.getZenkakuKasatahaMoji(chars[i]);
                if (getValue != null) {
                    returnValue.append(getValue);
                    continue;
                }
                if (new Character(chars[i]).equals(new Character('\uff9c'))) {
                    returnValue.append("\u30ef");
                    continue;
                }
                if (new Character(chars[i]).equals(new Character('\uff66'))) {
                    returnValue.append("\u30f2");
                    continue;
                }
                returnValue.append(String.valueOf(chars[i]));
                continue;
            }
            nextvalue = new Character(chars[i + 1]);
            if (nextvalue.equals(new Character('\uff9e'))) {
                getValue = StringUtil.getZenkakuDakuMoji(chars[i]);
                if (getValue != null) {
                    returnValue.append(getValue);
                    ++i;
                    continue;
                }
                if (new Character(chars[i]).equals(new Character('\uff9c'))) {
                    returnValue.append(ZENKAKU_WA_DAKUTEN);
                    ++i;
                    continue;
                }
                if (new Character(chars[i]).equals(new Character('\uff66'))) {
                    returnValue.append(ZENKAKU_WO_DAKUTEN);
                    ++i;
                    continue;
                }
                returnValue.append(String.valueOf(chars[i]) + "\u309b");
                ++i;
                continue;
            }
            if (nextvalue.equals(new Character('\uff9f'))) {
                getValue = StringUtil.getZenkakuHandakuMoji(chars[i]);
                if (getValue != null) {
                    returnValue.append(getValue);
                    ++i;
                    continue;
                }
                getValue = StringUtil.getZenkakuKasatahaMoji(chars[i]);
                returnValue.append(String.valueOf(getValue) + "\u309c");
                ++i;
                continue;
            }
            getValue = StringUtil.getZenkakuKasatahaMoji(chars[i]);
            if (getValue != null) {
                returnValue.append(getValue);
                continue;
            }
            if (new Character(chars[i]).equals(new Character('\uff9c'))) {
                returnValue.append("\u30ef");
                continue;
            }
            if (new Character(chars[i]).equals(new Character('\uff66'))) {
                returnValue.append("\u30f2");
                continue;
            }
            returnValue.append(String.valueOf(chars[i]));
        }
        return returnValue.toString();
    }

    public static String zenkakuToHankaku(String value) {
        if (value == null || "".equals(value)) {
            return value;
        }
        char[] chars = value.toCharArray();
        StringBuilder returnValue = new StringBuilder();
        String getValue = null;
        for (int i = 0; i < chars.length; ++i) {
            getValue = StringUtil.getHankakuMoji(chars[i]);
            if (getValue != null) {
                returnValue.append(getValue);
                continue;
            }
            returnValue.append(String.valueOf(chars[i]));
        }
        return returnValue.toString();
    }

    private static String getZenkakuMoji(char c) {
        int index = HANKAKU_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(ZENKAKU_LIST.charAt(index));
        }
        return null;
    }

    private static String getZenkakuDakuMoji(char c) {
        int index = HANKAKU_KASATAHA_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(ZENKAKU_GAZADABA_LIST.charAt(index));
        }
        return null;
    }

    private static String getZenkakuHandakuMoji(char c) {
        int index = HANKAKU_HA_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(ZENKAKU_PA_LIST.charAt(index));
        }
        return null;
    }

    private static String getZenkakuKasatahaMoji(char c) {
        int index = HANKAKU_KASATAHA_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(ZENKAKU_KASATAHA_LIST.charAt(index));
        }
        return null;
    }

    private static String getHankakuMoji(char c) {
        int index = 0;
        String value = null;
        index = ZENKAKU_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(HANKAKU_LIST.charAt(index));
        }
        index = ZENKAKU_KASATAHA_LIST.indexOf(c);
        if (index >= 0) {
            return String.valueOf(HANKAKU_KASATAHA_LIST.charAt(index));
        }
        index = ZENKAKU_GAZADABA_LIST.indexOf(c);
        if (index >= 0) {
            value = String.valueOf(HANKAKU_KASATAHA_LIST.charAt(index));
            return value + "\uff9e";
        }
        index = ZENKAKU_PA_LIST.indexOf(c);
        if (index >= 0) {
            value = String.valueOf(HANKAKU_HA_LIST.charAt(index));
            return value + "\uff9f";
        }
        if (new Character(c).equals(new Character('\u30ef'))) {
            return "\uff9c";
        }
        if (new Character(c).equals(new Character('\u30f2'))) {
            return "\uff66";
        }
        if (new Character(c).equals(ZENKAKU_WA_DAKUTEN)) {
            return "\uff9c\uff9e";
        }
        if (new Character(c).equals(ZENKAKU_WO_DAKUTEN)) {
            return "\uff66\uff9e";
        }
        return null;
    }

    public static String filter(String str) {
        if (str == null) {
            return null;
        }
        char[] cbuf = str.toCharArray();
        StringBuilder sbui = new StringBuilder();
        for (int i = 0; i < cbuf.length; ++i) {
            if (cbuf[i] == '&') {
                sbui.append("&amp;");
                continue;
            }
            if (cbuf[i] == '<') {
                sbui.append("&lt;");
                continue;
            }
            if (cbuf[i] == '>') {
                sbui.append("&gt;");
                continue;
            }
            if (cbuf[i] == '\"') {
                sbui.append("&quot;");
                continue;
            }
            if (cbuf[i] == '\'') {
                sbui.append("&#39;");
                continue;
            }
            sbui.append(cbuf[i]);
        }
        return sbui.toString();
    }

    public static String toLikeCondition(String condition) {
        if (condition == null) {
            return null;
        }
        char esc = LIKE_ESC_CHAR.toCharArray()[0];
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < condition.length(); ++i) {
            char c = condition.charAt(i);
            if (c == esc) {
                result.append(esc);
                result.append(esc);
                continue;
            }
            if (c == '%' || c == '_' || c == '\uff3f' || c == '\uff05') {
                result.append(esc);
                result.append(c);
                continue;
            }
            result.append(c);
        }
        result.append('%');
        return result.toString();
    }

    public static int getByteLength(String value, String encoding) throws UnsupportedEncodingException {
        if (value == null || "".equals(value)) {
            return 0;
        }
        byte[] bytes = null;
        if (encoding == null || "".equals(encoding)) {
            bytes = value.getBytes();
        } else {
            bytes = value.getBytes(encoding);
        }
        return bytes == null ? 0 : bytes.length;
    }
}

