/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertUtil {
    public static final String CLASS_FIELDNAME = "class";

    public static Object[] toArray(Object obj) {
        if (obj == null) {
            return new Object[0];
        }
        if (obj.getClass().isArray()) {
            return (Object[])obj;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).toArray();
        }
        return new Object[]{obj};
    }

    public static <E> List<E> toList(Object obj, Class<E> elementClass) throws IllegalArgumentException {
        if (elementClass == null) {
            throw new IllegalArgumentException("Argument 'elementClass' (" + Class.class.getName() + ") is null");
        }
        Object[] array = ConvertUtil.toArray(obj);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : array) {
            if (element != null && !elementClass.isAssignableFrom(element.getClass())) {
                String message = "Unable to cast '" + element.getClass().getName() + "' to '" + elementClass.getName() + "'";
                throw new IllegalArgumentException(message, new ClassCastException(message));
            }
            result.add(element);
        }
        return result;
    }

    public static <T> T convert(Object obj, Class<T> clazz) throws IllegalArgumentException {
        return ConvertUtil.convert(obj, clazz, true);
    }

    public static <T> T convertIfNotNull(Object obj, Class<T> clazz) throws IllegalArgumentException {
        return ConvertUtil.convert(obj, clazz, false);
    }

    public static <T> T convert(Object obj, Class<T> clazz, boolean allowsNull) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 'clazz' (" + Object.class.getName() + ") is null");
        }
        if (obj == null) {
            if (!allowsNull) {
                String message = "Unable to cast 'null' to '" + clazz.getName() + "'";
                throw new IllegalArgumentException(message, new ClassCastException(message));
            }
            return null;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        Object result = null;
        try {
            result = ConvertUtils.convert((String)obj.toString(), clazz);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)result;
    }

    public static Object convertPrimitiveArrayToList(Object value) {
        ArrayList<Object> list;
        block12: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block11: {
                                        if (value == null) {
                                            return value;
                                        }
                                        Class<?> type = value.getClass().getComponentType();
                                        if (type == null) {
                                            return value;
                                        }
                                        if (!type.isPrimitive()) {
                                            return value;
                                        }
                                        list = new ArrayList<Object>();
                                        if (!(value instanceof boolean[])) break block11;
                                        for (boolean data : (boolean[])value) {
                                            list.add(data);
                                        }
                                        break block12;
                                    }
                                    if (!(value instanceof byte[])) break block13;
                                    for (byte data : (byte[])value) {
                                        list.add(Byte.toString(data));
                                    }
                                    break block12;
                                }
                                if (!(value instanceof char[])) break block14;
                                for (char data : (char[])value) {
                                    list.add(Character.toString(data));
                                }
                                break block12;
                            }
                            if (!(value instanceof double[])) break block15;
                            for (double data : (double[])value) {
                                list.add(Double.toString(data));
                            }
                            break block12;
                        }
                        if (!(value instanceof float[])) break block16;
                        for (float data : (float[])value) {
                            list.add(Float.toString(data));
                        }
                        break block12;
                    }
                    if (!(value instanceof int[])) break block17;
                    for (int data : (int[])value) {
                        list.add(Integer.toString(data));
                    }
                    break block12;
                }
                if (!(value instanceof long[])) break block18;
                for (long data : (long[])value) {
                    list.add(Long.toString(data));
                }
                break block12;
            }
            if (!(value instanceof short[])) break block12;
            for (short data : (short[])value) {
                list.add(Short.toString(data));
            }
        }
        return list;
    }

    public static List<Map<String, Object>> toListOfMap(Object obj) throws IllegalArgumentException {
        Object[] array = ConvertUtil.toArray(obj);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Object object : array) {
            Map map = null;
            if (object instanceof Map) {
                map = (Map)object;
            } else {
                try {
                    map = PropertyUtils.describe((Object)object);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            map.remove(CLASS_FIELDNAME);
            result.add(map);
        }
        return result;
    }
}

