/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.beans.jxpath;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import jp.terasoluna.fw.beans.jxpath.HashMapForJXPathIntrospector;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JXPATH152PatchActivator {
    private static final Log log = LogFactory.getLog(JXPATH152PatchActivator.class);

    private static void activate() {
        try {
            Field byClassField = JXPathIntrospector.class.getDeclaredField("byClass");
            byClassField.setAccessible(true);
            Map byClass = (Map)byClassField.get(null);
            Field byInterfaceField = JXPathIntrospector.class.getDeclaredField("byInterface");
            byInterfaceField.setAccessible(true);
            Map byInterface = (Map)byInterfaceField.get(null);
            byClassField.set(null, new HashMapForJXPathIntrospector(byClass));
            byInterfaceField.set(null, new HashMapForJXPathIntrospector(byInterface));
            log.info((Object)"JXPATH-152 Patch activation succeeded.");
        }
        catch (Exception e) {
            log.fatal((Object)"JXPATH-152 Patch activation failed.", (Throwable)e);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JXPATH152PatchActivator.activate();
                return null;
            }
        });
    }
}

