/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.logger;

import java.util.Locale;
import jp.terasoluna.fw.message.MessageManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLogger
implements Log {
    private final Log logger;
    private static final String CONFIG_FILENAME = "META-INF/terasoluna-logger.properties";
    private static final MessageManager MESSAGE_MANAGER = new MessageManager("META-INF/terasoluna-logger.properties");
    private static final ThreadLocal<Locale> locale = new ThreadLocal();

    protected TLogger(Class<?> clazz) {
        this.logger = LogFactory.getLog(clazz);
    }

    protected TLogger(String name) {
        this.logger = LogFactory.getLog((String)name);
    }

    public static void setLocale(Locale locale) {
        TLogger.locale.set(locale);
    }

    protected String createMessage(boolean resource, String logIdOrPattern, Object ... args) {
        String message = MESSAGE_MANAGER.getMessage(resource, logIdOrPattern, locale.get(), args);
        return message;
    }

    public static TLogger getLogger(Class<?> clazz) {
        return new TLogger(clazz);
    }

    public static TLogger getLogger(String name) {
        return new TLogger(name);
    }

    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    public void fatal(boolean resource, String logIdOrPattern, Object ... args) {
        if (this.isFatalEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.fatal((Object)message);
        }
    }

    public void fatal(boolean resource, String logIdOrPattern, Throwable throwable, Object ... args) {
        if (this.isFatalEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.fatal((Object)message, throwable);
        }
    }

    public void fatal(String logId, Object ... args) {
        this.fatal(true, logId, args);
    }

    public void fatal(String logId, Throwable throwable, Object ... args) {
        this.fatal(true, logId, throwable, args);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(boolean resource, String logIdOrPattern, Object ... args) {
        if (this.isErrorEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.error((Object)message);
        }
    }

    public void error(boolean resource, String logIdOrPattern, Throwable throwable, Object ... args) {
        if (this.isErrorEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.error((Object)message, throwable);
        }
    }

    public void error(String logId, Object ... args) {
        this.error(true, logId, args);
    }

    public void error(String logId, Throwable throwable, Object ... args) {
        this.error(true, logId, throwable, args);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(boolean resource, String logIdOrPattern, Object ... args) {
        if (this.isWarnEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.warn((Object)message);
        }
    }

    public void warn(boolean resource, String logIdOrPattern, Throwable throwable, Object ... args) {
        if (this.isWarnEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.warn((Object)message, throwable);
        }
    }

    public void warn(String logId, Object ... args) {
        this.warn(true, logId, args);
    }

    public void warn(String logId, Throwable throwable, Object ... args) {
        this.warn(true, logId, throwable, args);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(boolean resource, String logIdOrPattern, Object ... args) {
        if (this.isInfoEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.info((Object)message);
        }
    }

    public void info(boolean resource, String logIdOrPattern, Throwable throwable, Object ... args) {
        if (this.isInfoEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.info((Object)message, throwable);
        }
    }

    public void info(String logId, Object ... args) {
        this.info(true, logId, args);
    }

    public void info(String logId, Throwable throwable, Object ... args) {
        this.info(true, logId, throwable, args);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(boolean resource, String logIdOrPattern, Object ... args) {
        if (this.isDebugEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.debug((Object)message);
        }
    }

    public void debug(boolean resource, String logIdOrPattern, Throwable throwable, Object ... args) {
        if (this.isDebugEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.debug((Object)message, throwable);
        }
    }

    public void debug(String logId, Object ... args) {
        this.debug(true, logId, args);
    }

    public void debug(String logId, Throwable throwable, Object ... args) {
        this.debug(true, logId, throwable, args);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(boolean resource, String logIdOrPattern, Object ... args) {
        if (this.isTraceEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.trace((Object)message);
        }
    }

    public void trace(boolean resource, String logIdOrPattern, Throwable throwable, Object ... args) {
        if (this.isTraceEnabled()) {
            String message = this.createMessage(resource, logIdOrPattern, args);
            this.logger.trace((Object)message, throwable);
        }
    }

    public void trace(String logId, Object ... args) {
        this.trace(true, logId, args);
    }

    public void trace(String logId, Throwable throwable, Object ... args) {
        this.trace(true, logId, throwable, args);
    }

    public void log(String logId, Object ... args) {
        if (logId != null && logId.length() > 0) {
            char messageType = logId.charAt(0);
            switch (messageType) {
                case 'T': {
                    this.trace(logId, args);
                    break;
                }
                case 'D': {
                    this.debug(logId, args);
                    break;
                }
                case 'I': {
                    this.info(logId, args);
                    break;
                }
                case 'W': {
                    this.warn(logId, args);
                    break;
                }
                case 'E': {
                    this.error(logId, args);
                    break;
                }
                case 'F': {
                    this.fatal(logId, args);
                    break;
                }
                default: {
                    this.debug(logId, args);
                }
            }
        }
    }

    public void log(String logId, Throwable throwable, Object ... args) {
        if (logId != null && logId.length() > 0) {
            char messageType = logId.charAt(0);
            switch (messageType) {
                case 'T': {
                    this.trace(logId, throwable, args);
                    break;
                }
                case 'D': {
                    this.debug(logId, throwable, args);
                    break;
                }
                case 'I': {
                    this.info(logId, throwable, args);
                    break;
                }
                case 'W': {
                    this.warn(logId, throwable, args);
                    break;
                }
                case 'E': {
                    this.error(logId, throwable, args);
                    break;
                }
                case 'F': {
                    this.fatal(logId, throwable, args);
                    break;
                }
                default: {
                    this.debug(logId, throwable, args);
                }
            }
        }
    }

    @Deprecated
    public void trace(Object message) {
        this.trace(false, "{0}", message);
    }

    @Deprecated
    public void trace(Object message, Throwable t) {
        this.trace(false, "{0}", t, message);
    }

    @Deprecated
    public void debug(Object message) {
        this.debug(false, "{0}", message);
    }

    @Deprecated
    public void debug(Object message, Throwable t) {
        this.debug(false, "{0}", t, message);
    }

    @Deprecated
    public void info(Object message) {
        this.info(false, "{0}", message);
    }

    @Deprecated
    public void info(Object message, Throwable t) {
        this.info(false, "{0}", t, message);
    }

    @Deprecated
    public void warn(Object message) {
        this.warn(false, "{0}", message);
    }

    @Deprecated
    public void warn(Object message, Throwable t) {
        this.warn(false, "{0}", t, message);
    }

    @Deprecated
    public void error(Object message) {
        this.error(false, "{0}", message);
    }

    @Deprecated
    public void error(Object message, Throwable t) {
        this.error(false, "{0}", t, message);
    }

    @Deprecated
    public void fatal(Object message) {
        this.fatal(false, "{0}", message);
    }

    @Deprecated
    public void fatal(Object message, Throwable t) {
        this.fatal(false, "{0}", t, message);
    }

    public String getLogMessage(String logId, Object ... args) {
        String message = this.createMessage(true, logId, args);
        return message;
    }

    public void trace(String logId) {
        this.trace(logId, (Object[])null);
    }

    public void trace(String logId, Throwable throwable) {
        this.trace(logId, throwable, (Object[])null);
    }

    public void debug(String logId) {
        this.debug(logId, (Object[])null);
    }

    public void debug(String logId, Throwable throwable) {
        this.debug(logId, throwable, (Object[])null);
    }

    public void warn(String logId) {
        this.warn(logId, (Object[])null);
    }

    public void warn(String logId, Throwable throwable) {
        this.warn(logId, throwable, (Object[])null);
    }

    public void info(String logId) {
        this.info(logId, (Object[])null);
    }

    public void info(String logId, Throwable throwable) {
        this.info(logId, throwable, (Object[])null);
    }

    public void error(String logId) {
        this.error(logId, (Object[])null);
    }

    public void error(String logId, Throwable throwable) {
        this.error(logId, throwable, (Object[])null);
    }

    public void fatal(String logId) {
        this.fatal(logId, (Object[])null);
    }

    public void fatal(String logId, Throwable throwable) {
        this.fatal(logId, throwable, (Object[])null);
    }
}

