/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import jp.terasoluna.fw.collector.validate.ValidateErrorStatus;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorLoglevel;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.logger.TLogger;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidationErrorHandler
implements ValidationErrorHandler {
    private static final TLogger LOGGER = TLogger.getLogger(AbstractValidationErrorHandler.class);
    protected int errorFieldCount = 0;
    protected Queue<Errors> errorsQueue = new ConcurrentLinkedQueue<Errors>();
    protected ValidationErrorLoglevel logLevel = ValidationErrorLoglevel.INFO;

    public AbstractValidationErrorHandler() {
    }

    public AbstractValidationErrorHandler(ValidationErrorLoglevel logLevel) {
        this();
        this.logLevel = logLevel;
    }

    @Override
    public ValidateErrorStatus handleValidationError(DataValueObject dataValueObject, Errors errors) {
        ++this.errorFieldCount;
        if (errors != null) {
            this.errorsQueue.add(errors);
        }
        this.outputLog(dataValueObject, errors);
        return this.getValidateStatus(dataValueObject, errors);
    }

    protected void outputLog(DataValueObject dataValueObject, Errors errors) {
        if (ValidationErrorLoglevel.TRACE == this.logLevel && LOGGER.isTraceEnabled()) {
            LOGGER.trace("TAL041001", new Object[]{this.logEdit(dataValueObject, errors)});
        } else if (ValidationErrorLoglevel.DEBUG == this.logLevel && LOGGER.isDebugEnabled()) {
            LOGGER.debug("DAL041001", new Object[]{this.logEdit(dataValueObject, errors)});
        } else if (ValidationErrorLoglevel.INFO == this.logLevel && LOGGER.isInfoEnabled()) {
            LOGGER.info("IAL041001", new Object[]{this.logEdit(dataValueObject, errors)});
        } else if (ValidationErrorLoglevel.WARN == this.logLevel && LOGGER.isWarnEnabled()) {
            LOGGER.warn("WAL041001", new Object[]{this.logEdit(dataValueObject, errors)});
        } else if (ValidationErrorLoglevel.ERROR == this.logLevel && LOGGER.isErrorEnabled()) {
            LOGGER.error("EAL041001", new Object[]{this.logEdit(dataValueObject, errors)});
        } else if (ValidationErrorLoglevel.FATAL == this.logLevel && LOGGER.isFatalEnabled()) {
            LOGGER.fatal("FAL041001", new Object[]{this.logEdit(dataValueObject, errors)});
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("TAL041001", new Object[]{this.logEdit(dataValueObject, errors)});
        }
    }

    protected String logEdit(DataValueObject dataValueObject, Errors errors) {
        StringBuilder sb = new StringBuilder();
        List<FieldError> fel = AbstractValidationErrorHandler.getFieldErrorList(errors);
        for (FieldError fe : fel) {
            sb.setLength(0);
            sb.append("ValidationError");
            sb.append(" dataCount:[");
            if (dataValueObject != null) {
                sb.append(dataValueObject.getDataCount());
            }
            sb.append("]");
            sb.append(" code:[");
            sb.append(fe.getCode());
            sb.append("]");
            sb.append(" objectName:[");
            sb.append(fe.getObjectName());
            sb.append("]");
            sb.append(" field:[");
            sb.append(fe.getField());
            sb.append("]");
            sb.append(" rejectedValue:[");
            sb.append(fe.getRejectedValue());
            sb.append("]");
        }
        return sb.toString();
    }

    protected abstract ValidateErrorStatus getValidateStatus(DataValueObject var1, Errors var2);

    public static List<FieldError> getFieldErrorList(Errors errors) {
        ArrayList<FieldError> resultList = new ArrayList<FieldError>();
        if (errors != null) {
            List errs = errors.getAllErrors();
            for (Object errObj : errs) {
                if (!(errObj instanceof FieldError)) continue;
                FieldError fe = (FieldError)errObj;
                resultList.add(fe);
            }
        }
        return resultList;
    }

    public int getErrorFieldCount() {
        return this.errorFieldCount;
    }

    public Errors[] getErrors() {
        return this.errorsQueue.toArray(new Errors[0]);
    }

    public void setLogLevel(ValidationErrorLoglevel logLevel) {
        this.logLevel = logLevel;
    }
}

