/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.dao.support;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateResult;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUpdateExecutor {
    private static final TLogger LOGGER = TLogger.getLogger(BatchUpdateExecutor.class);

    public static List<BatchUpdateResult> executeBatch(Object value, UpdateDAO updateDAO) {
        ArrayList<BatchUpdateResult> resultList = new ArrayList<BatchUpdateResult>();
        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                BatchUpdateSupport bus = (BatchUpdateSupport)value;
                int res = 0;
                try {
                    res = bus.executeBatch(updateDAO);
                    resultList.add(new BatchUpdateResult(bus, res));
                }
                catch (Throwable e) {
                    resultList.add(new BatchUpdateResult(bus, e));
                }
            } else if (value instanceof List) {
                List valueList = (List)value;
                for (Object obj : valueList) {
                    List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                }
            } else if (value.getClass().isArray()) {
                Object[] valueArray;
                for (Object obj : valueArray = (Object[])value) {
                    List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                }
            } else {
                List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatchInnerObject(value, updateDAO);
                resultList.addAll(res);
            }
        }
        return resultList;
    }

    protected static List<BatchUpdateResult> executeBatchInnerObject(Object value, UpdateDAO updateDAO) {
        ArrayList<BatchUpdateResult> resultList = new ArrayList<BatchUpdateResult>();
        if (value != null) {
            BeanInfo bi = null;
            try {
                bi = Introspector.getBeanInfo(value.getClass());
                if (bi != null) {
                    PropertyDescriptor[] pds;
                    for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                        if (pd == null) continue;
                        Class<?> pt = pd.getPropertyType();
                        Method rm = pd.getReadMethod();
                        if (rm == null || !BatchUpdateExecutor.isTargetClass(pt)) continue;
                        try {
                            Object readValue = rm.invoke(value, new Object[0]);
                            List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatch(readValue, updateDAO);
                            resultList.addAll(res);
                        }
                        catch (IllegalArgumentException e) {
                            BatchUpdateExecutor.outputExceptionLog(e);
                        }
                        catch (IllegalAccessException e) {
                            BatchUpdateExecutor.outputExceptionLog(e);
                        }
                        catch (InvocationTargetException e) {
                            BatchUpdateExecutor.outputExceptionLog(e);
                        }
                    }
                }
            }
            catch (IntrospectionException e) {
                BatchUpdateExecutor.outputExceptionLog(e);
            }
        }
        return resultList;
    }

    public static void clearAll(Object value) {
        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                ((BatchUpdateSupport)value).clear();
            } else if (value instanceof List) {
                List valueList = (List)value;
                for (Object obj : valueList) {
                    BatchUpdateExecutor.clearAll(obj);
                }
            } else if (value.getClass().isArray()) {
                Object[] valueArray;
                for (Object obj : valueArray = (Object[])value) {
                    BatchUpdateExecutor.clearAll(obj);
                }
            } else {
                BatchUpdateExecutor.clearAllInnerObject(value);
            }
        }
    }

    protected static void clearAllInnerObject(Object value) {
        if (value != null) {
            BeanInfo bi = null;
            try {
                bi = Introspector.getBeanInfo(value.getClass());
                if (bi != null) {
                    PropertyDescriptor[] pds;
                    for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                        if (pd == null) continue;
                        Class<?> pt = pd.getPropertyType();
                        Method rm = pd.getReadMethod();
                        if (rm == null || !BatchUpdateExecutor.isTargetClass(pt)) continue;
                        try {
                            Object readValue = rm.invoke(value, new Object[0]);
                            BatchUpdateExecutor.clearAll(readValue);
                        }
                        catch (IllegalArgumentException e) {
                            BatchUpdateExecutor.outputExceptionLog(e);
                        }
                        catch (IllegalAccessException e) {
                            BatchUpdateExecutor.outputExceptionLog(e);
                        }
                        catch (InvocationTargetException e) {
                            BatchUpdateExecutor.outputExceptionLog(e);
                        }
                    }
                }
            }
            catch (IntrospectionException e) {
                BatchUpdateExecutor.outputExceptionLog(e);
            }
        }
    }

    protected static boolean isTargetClass(Class<?> clazz) {
        return clazz != null && clazz != Object.class && clazz != Class.class && !Date.class.isAssignableFrom(clazz) && !clazz.isPrimitive() && !BatchUpdateExecutor.isPrimitiveWrapper(clazz);
    }

    protected static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (clazz != null) {
            if (Number.class.isAssignableFrom(clazz) && !AtomicInteger.class.isAssignableFrom(clazz) && !AtomicLong.class.isAssignableFrom(clazz) && !AtomicBoolean.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Boolean.class == clazz || Character.class == clazz || String.class == clazz || Date.class == clazz || Void.class == clazz) {
                return true;
            }
        }
        return false;
    }

    protected static void outputExceptionLog(Throwable e) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("WAL036001", e, new Object[]{e.getMessage() == null ? "" : e.getMessage()});
        }
    }
}

