/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.terasoluna.fw.batch.executor.AbstractBatchExecutor;
import jp.terasoluna.fw.batch.executor.vo.BLogicResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.util.JobUtil;
import jp.terasoluna.fw.logger.TLogger;

public class SyncBatchExecutor
extends AbstractBatchExecutor {
    private static final TLogger LOGGER = TLogger.getLogger(SyncBatchExecutor.class);
    private static final String JOB_ARG_PARAM_BASE = "JobArgNm";

    protected SyncBatchExecutor() {
    }

    public static void main(String[] args) {
        BLogicResult result = new BLogicResult();
        String jobAppCd = null;
        LOGGER.info("IAL025014");
        BatchJobData jobRecord = new BatchJobData();
        if (args.length > 0) {
            jobAppCd = args[0];
        }
        for (int i = 1; i < args.length && i <= 20; ++i) {
            String arg = args[i];
            if (arg == null || arg.length() == 0) continue;
            SyncBatchExecutor.setParam(jobRecord, JOB_ARG_PARAM_BASE, i, arg);
        }
        if (jobAppCd == null || jobAppCd.length() == 0) {
            jobAppCd = JobUtil.getenv("JOB_APP_CD");
        }
        jobRecord.setJobAppCd(jobAppCd);
        StringBuilder envName = new StringBuilder();
        for (int i = 1; i <= 20; ++i) {
            String param = SyncBatchExecutor.getParam(jobRecord, JOB_ARG_PARAM_BASE, i);
            if (param != null && param.length() != 0) continue;
            envName.setLength(0);
            envName.append("JOB_ARG_NM");
            envName.append(i);
            param = JobUtil.getenv(envName.toString());
            if (param == null || param.length() == 0) continue;
            SyncBatchExecutor.setParam(jobRecord, JOB_ARG_PARAM_BASE, i, param);
        }
        jobRecord.setJobSequenceId(JobUtil.getenv("JOB_SEQ_ID"));
        jobRecord.setErrAppStatus(JobUtil.getenv("BLOGIC_APP_STATUS"));
        jobRecord.setCurAppStatus(JobUtil.getenv("CUR_APP_STATUS"));
        SyncBatchExecutor executor = new SyncBatchExecutor();
        result = executor.executeBatch(jobRecord);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("IAL025015", new Object[]{result.getBlogicStatus()});
        }
        System.exit(result.getBlogicStatus());
    }

    private static String getParam(Object obj, String paramName, int i) {
        String result = null;
        if (obj != null) {
            Method method = null;
            StringBuilder methodName = new StringBuilder();
            methodName.append("get");
            methodName.append(paramName);
            methodName.append(i);
            try {
                method = obj.getClass().getMethod(methodName.toString(), new Class[0]);
            }
            catch (SecurityException e) {
                LOGGER.error("EAL025014", (Throwable)e);
                return null;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("EAL025015", (Throwable)e);
                return null;
            }
            if (method != null) {
                Object resultObj = null;
                try {
                    resultObj = method.invoke(obj, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("EAL025032", (Throwable)e);
                    return null;
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("EAL025033", (Throwable)e);
                    return null;
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("EAL025034", (Throwable)e);
                    return null;
                }
                if (resultObj instanceof String) {
                    result = (String)resultObj;
                }
            }
        }
        return result;
    }

    private static void setParam(Object obj, String paramName, int i, String value) {
        if (obj != null) {
            Method method = null;
            StringBuilder methodName = new StringBuilder();
            methodName.append("set");
            methodName.append(paramName);
            methodName.append(i);
            try {
                method = obj.getClass().getMethod(methodName.toString(), String.class);
            }
            catch (SecurityException e) {
                LOGGER.error("EAL025014", (Throwable)e);
                return;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("EAL025015", (Throwable)e);
                return;
            }
            if (method != null) {
                try {
                    method.invoke(obj, value);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("EAL025032", (Throwable)e);
                    return;
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("EAL025033", (Throwable)e);
                    return;
                }
                catch (InvocationTargetException e) {
                    LOGGER.error("EAL025034", (Throwable)e);
                    return;
                }
            }
        }
    }
}

