// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections;
using System.Web;
using System.Web.Configuration;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Web.Configuration.ExceptionTransition;
using TERASOLUNA.Fw.Web.Configuration.Page;
using System.Web.SessionState;

namespace TERASOLUNA.Fw.Web.HttpModule
{
    /// <summary>
    /// AvP[VX[ꂽONX̎ނɉĉʑJڂs@\񋟂܂B
    /// </summary>
    /// <remarks>
    /// {NX𗘗pۂɂ́AAvP[V Grobal.asax t@CǉKv܂B
    /// <para>web.config  &lt;httpModules&gt; ݒ肪KvłB</para>
    /// </remarks>
    public class ExceptionTransitionListenerImpl : IHttpModule
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ExceptionTransitionListenerImpl));

        /// <summary>
        /// {W[Lł邩ǂێ <see cref="Boolean"/>B
        /// </summary>
        /// <remarks>
        /// {W[L̏ꍇ trueB̏ꍇ falseB
        /// </remarks>
        private bool _exceptionTransitionEnabled = false;
      
        /// <summary>
        /// IIS OɗOɊւo͂邩ǂێ <see cref="Boolean"/>B
        /// </summary>
        /// <remarks>
        /// Oo͂ꍇ trueBo͂Ȃꍇ falseB
        /// </remarks>
        private bool _exceptionLoggingEnabled = false;

        /// <summary>
        /// W[̗Lۂ擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// W[̗LہB
        /// </value>
        protected bool ExceptionTransitionEnabled
        {
            get
            { 
                return _exceptionTransitionEnabled; 
            }
            set 
            {
                _exceptionTransitionEnabled = value; 
            }
        }

        /// <summary>
        /// Oo͂̉ۂ擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// Oo͂̉ہB
        /// </value>
        protected bool ExceptionLoggingEnabled
        {
            get
            { 
                return _exceptionLoggingEnabled; 
            }
            set 
            { 
                _exceptionLoggingEnabled = value; 
            }
        }

        /// <summary>
        /// ExceptionTransitionListenerImpl IuWFNgŎgp郊\[X () ܂B 
        /// </summary>
        public virtual void Dispose()
        {            
        }

        /// <summary>
        /// ExceptionTransitionListenerImpl IuWFNg̍쐬ɏR[hĂяo܂B 
        /// </summary>
        /// <remarks>
        /// G[ʑJڃW[LȏꍇA<see cref="HttpApplication"/> IuWFNg
        /// Error Cxg̃Cxgnho^܂B
        /// </remarks>
        /// <param name="context">
        /// ASP.NET AvP[Vׂ̂ẴAvP[VIuWFNgɋʂ̃\bhA
        /// vpeBAуCxgւ̃ANZX񋟂 <see cref="HttpApplication"/> IuWFNgB
        /// </param>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods")]
        public virtual void Init(HttpApplication context)
        {
            ExceptionTransitionConfigurationSection etcs 
                = (ExceptionTransitionConfigurationSection)WebConfigurationManager.GetSection("exceptionTransitionConfiguration");

            if (String.Equals(etcs.Mode, "on", StringComparison.CurrentCultureIgnoreCase))
            {
                _exceptionTransitionEnabled = true;
                context.Error += new EventHandler(context_Error);
            }

            if (_exceptionTransitionEnabled && String.Equals(etcs.Logging, "on", StringComparison.CurrentCultureIgnoreCase))
            {
                _exceptionLoggingEnabled = true;
            }

        }

        /// <summary>
        /// HttpApplication.Error Cxg̃CxgnhB
        /// </summary>
        /// <remarks>
        /// ݒt@CAONXɑ΂JڐURL擾AʑJڂs܂B
        /// </remarks>
        /// <param name="sender">Cxg̃\[XB</param>
        /// <param name="e">Cxgf[^i[Ă <see cref="EventArgs"/> IuWFNgB</param>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2234:PassSystemUriObjectsInsteadOfStrings")]
        protected virtual void context_Error(object sender, EventArgs e)
        {
            HttpApplication app = sender as HttpApplication;
            HttpContext context = app.Context;

            if (WebUtils.IsInCustomErrorPages())
            {   // request  web.config  customErrors Œ`ꂽy[W̏ꍇ͏sȂ
                return;
            }

            try
            {
                Exception lastError = context.Server.GetLastError();

                if (lastError == null)
                {   // O񂪂Ȃꍇ͂ȂɂȂ
                    return;
                }

                if (lastError is HttpUnhandledException)
                {   // [U[R[hɂďĂȂȌꍇ
                    // InnerException Ƀ[UR[hŔOIuWFNgO̗OƂȂ
                    if (lastError.InnerException != null)
                    {
                        lastError = lastError.InnerException;
                    }
                }
                else
                {
                    HttpException he = lastError as HttpException;
                    if (he != null)
                    {
                        int errorCode = he.GetHttpCode();
                        string source = he.Source;
                        if (errorCode >= 400 && "System.Web".Equals(source))
                        {   // HTTP Status Code 
                            // 4XX  Client Error ^ 5XX  Server Error ̏ꍇŁA
                            // ASP.NET̗Ȍꍇ͂ȂɂȂ
                            return;
                        }
                    }
                }

                string redirectPagePath = GetRedirectUrl(lastError);

                if (redirectPagePath.Length > 0)
                {
                    // ʑJڕۏ؋@\Lȏꍇ̓g[Nݒ肷
                    string appPath = context.Request.ApplicationPath;
                    string redirectUrl = null;
                    if (!("/".Equals(appPath)))
                    {
                        redirectUrl = appPath + redirectPagePath;
                    }
                    else
                    {
                        redirectUrl = redirectPagePath;
                    }

                    bool isCheckTokenEnabled = PageConfiguration.IsCheckTokenEnabled(redirectPagePath);
                    HttpSessionState session = context.Session;
                    if (isCheckTokenEnabled && session.IsNewSession)
                    {
                        // ̉ʂɃZbVpƂłA
                        // g[N`FbNŗĂ܂߁AVXeG[ƂB
                        // iASP.NET̃G[@\ɔCBj
                        return;
                    }

                    string token = (string)context.Items["TERASOLUNA_Token"];
                    if (isCheckTokenEnabled && token != null)
                    {
                        // ZbVɃG[y[WɑΉg[Nݒ肷
                        Hashtable tokens = (Hashtable)session["TERASOLUNA_Token"];
                        tokens[redirectUrl] = token;
                        session["TERASOLUNA_Token"] = tokens;
                        // g[NNGɕt
                        redirectUrl = WebUtils.AppendParameter(redirectUrl, "__Token", token);
                    }

                    session["TERASOLUNA_LastError"] = lastError;
                    session["TERASOLUNA_ErrorPage"] = context.Request.Url.AbsoluteUri;

                    if (_exceptionLoggingEnabled)
                    {
                        string errMessage = string.Format(" Source :{0};  Message : {1}; StackTace : {2};",
                                                  lastError.Source,
                                                  lastError.Message,
                                                  lastError.StackTrace);
                        context.Response.AppendToLog(errMessage);
                    }

                    context.Server.ClearError();

                    // ʑJڂ邱ƂOo͂B
                    if (_log.IsDebugEnabled)
                    {
                        _log.Debug(string.Format(Properties.Resources.D_EXCEPTION_TRANSIT,
                            lastError.GetType(), redirectUrl));
                    }
                    context.Response.Redirect(redirectUrl);

                    // G[ʑJڎ TokenProcessorImpl.context_EndRequest ŁA
                    // RedirectLocation ̍ĐݒȂ߂̃tO
                    context.Items["TERASOLUNA_ErrorTransition"] = true;
                }
                // else G[ʑJڋ@\ɐݒ肪Ȃꍇ͉ȂBiASP.NET̃G[@\ɔCBj

            }
            catch (Exception ex)
            {
                string errMessage = string.Format(" Source :{0};  Message : {1}; StackTace : {2};",
                                                ex.Source,
                                                ex.Message,
                                                ex.StackTrace);
                context.Response.AppendToLog(errMessage);

                throw;
            }
        }

        /// <summary>
        /// ݒt@CAONXɑ΂Jڐy[W擾܂B
        /// </summary>
        /// <remarks>
        /// Jڐy[W擾łȂꍇ́A󕶎Ԃ܂B
        /// </remarks>
        /// <param name="ex"><see cref="Exception"/> IuWFNgB</param>
        /// <returns>zAvP[V[gpXȍ~̑Jڐy[WB</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="ex"/>  null QƂłB
        /// </exception>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1055:UriReturnValuesShouldNotBeStrings")]
        protected virtual string GetRedirectUrl(Exception ex)
        {
            if(ex == null)
            {
                ArgumentNullException exception = new ArgumentNullException("ex");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "ex"), exception);
                }
                throw exception;
            }
            Type t = ex.GetType();

            string nextPagePath = "";

            while (t != null)
            {
                string nextPage = ExceptionTransitionConfiguration.GetNextPage(t);

                if (nextPage != null)
                {
                    nextPagePath = PageConfiguration.GetPath(nextPage);
                    break;
                }

                t = t.BaseType;
            }

            return nextPagePath;
        }
    }
}
