﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Configuration.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicElement のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicElement 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class BLogicElementTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// BLogicElement () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            BLogicElement target = new BLogicElement();
            Assert.IsNotNull(target);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicElement (string, string, dbInfos) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, dbInfos)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor02()
        {
            string name = "Biz1";
            string type = "Biz1.Class1, Biz1";
            BLogicDbInfoCollection objBlc = new BLogicDbInfoCollection();

            BLogicElement target = new BLogicElement(name, type, objBlc);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(type, target.Type);
            Assert.AreEqual(objBlc, target.DbInfos);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicElement (string, string, dbInfos) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, dbInfos)</TestTarget>
        /// <TestCondition>引数nameを空文字に設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor03()
        {
            string name = "";
            string type = "Biz1.Class1, Biz1";
            BLogicDbInfoCollection objBlc = new BLogicDbInfoCollection();

            BLogicElement target = new BLogicElement(name, type, objBlc);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(type, target.Type);
            Assert.AreEqual(objBlc, target.DbInfos);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicElement (string, string, dbInfos) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, dbInfos)</TestTarget>
        /// <TestCondition>引数nameをnullに設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor04()
        {
            string name = null;
            string type = "Biz1.Class1, Biz1";
            BLogicDbInfoCollection objBlc = new BLogicDbInfoCollection();

            BLogicElement target = new BLogicElement(name, type, objBlc);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(type, target.Type);
            Assert.AreEqual(objBlc, target.DbInfos);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicElement (string, string, dbInfos) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, dbInfos)</TestTarget>
        /// <TestCondition>引数typeを空文字に設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor05()
        {
            string name = "Biz1";
            string type = "";
            BLogicDbInfoCollection objBlc = new BLogicDbInfoCollection();

            BLogicElement target = new BLogicElement(name, type, objBlc);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(type, target.Type);
            Assert.AreEqual(objBlc, target.DbInfos);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicElement (string, string, dbInfos) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, dbInfos)</TestTarget>
        /// <TestCondition>引数typeをnullに設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor06()
        {
            string name = "Biz1";
            string type = null;
            BLogicDbInfoCollection objBlc = new BLogicDbInfoCollection();

            BLogicElement target = new BLogicElement(name, type, objBlc);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(type, target.Type);
            Assert.AreEqual(objBlc, target.DbInfos);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicElement (string, string, dbInfos) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, dbInfos)</TestTarget>
        /// <TestCondition>引数dbInfosをnullに設定すること</TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor07()
        {
            string name = "Biz1";
            string type = "Biz1.Class1, Biz1";
            BLogicDbInfoCollection objBlc = null;

            BLogicElement target = new BLogicElement(name, type, objBlc);

            Assert.IsNotNull(target);
            Assert.AreEqual(name, target.Name);
            Assert.AreEqual(type, target.Type);
            Assert.AreEqual(objBlc, target.DbInfos);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// Name のテスト
        /// </summary>
        /// <TestTarget>Name</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>nameの値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestName01()
        {
            string name = "Biz1";
            string type = "Biz1.Class1, Biz1";

            BLogicElement target = new BLogicElement(name, type, new BLogicDbInfoCollection());

            Assert.AreEqual(name, target.Name);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// Type のテスト
        /// </summary>
        /// <TestTarget>Type</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>typeの値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestType01()
        {
            string name = "Biz1";
            string type = "Biz1.Class1, Biz1";

            BLogicElement target = new BLogicElement(name, type, new BLogicDbInfoCollection());

            Assert.AreEqual(type, target.Type);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }

        /// <summary>
        /// DbInfos のテスト
        /// </summary>
        /// <TestTarget>DbInfos</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>DbInfosの値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestDbInfos01()
        {
            string name = "Biz1";
            string type = "Biz1.Class1, Biz1";
            BLogicDbInfoCollection objBlc = new BLogicDbInfoCollection();

            BLogicElement target = new BLogicElement(name, type, objBlc);

            Assert.AreEqual(objBlc, target.DbInfos);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicElement), LogLevel.INFO));
        }
    }
}
