﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


namespace TERASOLUNA.Fw.Common.Logging
{
    /// <summary>
    /// ログレベルの列挙体です。
    /// </summary>
	public enum LogLevel : int
	{
		/// <summary>
        /// ログレベルが Trace であることを示します。
        /// </summary>
        /// <remarks>
        /// この定数の値は 6 です。
        /// </remarks>
		TRACE = 6,

        /// <summary>
        /// ログレベルが Debug であることを示します。
        /// </summary>
        /// <remarks>
        /// この定数の値は 5 です。
        /// </remarks>
		DEBUG = 5,

        /// <summary>
        /// ログレベルが Info であることを示します。
        /// </summary>
        /// <remarks>
        /// この定数の値は 4 です。
        /// </remarks>
		INFO = 4,

        /// <summary>
        /// ログレベルが Warn であることを示します。
        /// </summary>
        /// <remarks>
        /// この定数の値は 3 です。
        /// </remarks>
		WARN = 3,

        /// <summary>
        /// ログレベルが Error であることを示します。
        /// </summary>
        /// <remarks>
        /// この定数の値は 2 です。
        /// </remarks>
		ERROR = 2,

        /// <summary>
        /// ログレベルが Fatal であることを示します。
        /// </summary>
        /// <remarks>
        /// この定数の値は 1 です。
        /// </remarks>
		FATAL = 1,

        /// <summary>
        /// ログレベルが Off であることを示します。
        /// </summary>
        /// <remarks>
        /// この定数の値は 0 です。
        /// </remarks>
		OFF = 0
	}
}
