/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import junit.framework.TestCase;

/**
 * ClassUtil ubN{bNXeXgB<br>
 * <br>
 * (O)<br>
 *     Ȃ
 * <br>
 */
@SuppressWarnings("unused")
public class ClassUtilTest extends TestCase {

    /**
     * Constructor for ClassUtilTest.
     * @param arg0
     */
    public ClassUtilTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testCreate01(String)B<br>
     * 
     * inj<br>
     * ϓ_FE<br>
     * <br>
     * ͒l :IuWFNg̃NX<br>
     * Ғl :CX^X<br>
     *
     * IuWFNg̃NXɃCX^X𐶐邱ƂmFB<br>
     *
     */
    public void testCreateString01() {
        //ݒ
        String input = "java.lang.String";

        try {
            //eXgs
            Object obj = ClassUtil.create(input);

            //ʊmF
            assertEquals("java.lang.String", obj.getClass().getName());
        } catch (ClassLoadException e) {
            fail();
        }
    }

    /**
     * testCreate02(String)B<br>
     * 
     * inj<br>
     * ϓ_FE<br>
     * <br>
     * ͒l :IuWFNg̃NX(TerasolunaΉ)<br>
     * Ғl :CX^X<br>
     *
     * IuWFNgTerasolunaɑΉNX
     * CX^X𐶐邱ƂmFB<br>
     *
     */
    public void testCreateString02() {
        //ݒ
        String input = "jp.terasoluna.fw.util.ClassUtil";

        try {
            //eXgs
            Object obj = ClassUtil.create(input);

            //ʊmF
            assertEquals(
                "jp.terasoluna.fw.util.ClassUtil",
                obj.getClass().getName());
        } catch (ClassLoadException e) {
            fail();
        }
    }

    /**
     * testCreate03(String)B<br>
     * 
     * inj<br>
     * ϓ_FG<br>
     * <br>
     * ͒l :ۃNXAC^tF[XNX<br>
     * Ғl :InstantiationException<br>
     *
     * w肵NXnullRXgN^ێȂNX̏ꍇA
     * InstantiationException邱ƂmFB<br>
     *
     */
    public void testCreateString03() {
        //ݒ
        String input = "javax.swing.AbstractAction";

        try {
            //eXgs
            ClassUtil.create(input);
            fail();
        } catch (ClassLoadException e) {
            if (e.getMessage().indexOf("InstantiationException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testCreate04(String)B<br>
     * 
     * inj<br>
     * ϓ_FG<br>
     * <br>
     * ͒l :*.classȂNX<br>
     * Ғl :ClassNotFoundException<br>
     *
     * w肵NX݂ȂꍇA
     * ClassNotFoundException邱ƂmFB<br>
     *
     */
    public void testCreateString04() {
        //ݒ
        String input = "java.lang.Str";

        try {
            //eXgs
            ClassUtil.create(input);
            fail();
        } catch (ClassLoadException e) {
            if (e.getMessage().indexOf("ClassNotFoundException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testCreate05(String)B<br>
     * 
     * inj<br>
     * ϓ_FG<br>
     * <br>
     * ͒l :ANZXłȂRXgN^<br>
     * Ғl :IllegalAccessException<br>
     *
     * w肵NX̃RXgN^ɃANZXłȂꍇA
     * IllegalAccessException邱ƂmFB<br>
     *
     */
    public void testCreateString05() {
        //ݒ
        String input = "java.lang.Void";

        try {
            //eXgs
            ClassUtil.create(input);

        } catch (ClassLoadException e) {
            if (e.getMessage().indexOf("IllegalAccessException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testCreate01(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FE<br>
     * <br>
     * ͒l :IuWFNg̃NXARXgN^̃p[^1<br>
     * Ғl :CX^X<br>
     *
     * RXgN^̈1̎A
     * IuWFNg̃NXɃCX^X𐶐邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray01() {
        //ݒ
        String input = "java.lang.Integer";

        try {
            //eXgs
            Object obj = ClassUtil.create(input, new Object[] { "12" });
            java.lang.Integer resultObj = (java.lang.Integer) obj;

            //ʊmF
            //NX
            assertEquals("java.lang.Integer", obj.getClass().getName());

            //e
            assertEquals("12", resultObj.toString());

        } catch (ClassLoadException e) {
            fail();
        }
    }

    /**
     * testCreate02(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FE<br>
     * <br>
     * ͒l :IuWFNg̃NXARXgN^̃p[^<br>
     * Ғl :CX^X<br>
     *
     * RXgN^̈̎A
     * IuWFNg̃NXɃCX^X𐶐邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray02() {
        //ݒ
        String input = "java.lang.String";

        try {
            //eXgs
            Object obj = ClassUtil.create(input, new Object[]{});
            java.lang.String resultObj = (java.lang.String) obj;

            //ʊmF
            //NX
            assertEquals("java.lang.String", obj.getClass().getName());

            //e
            assertEquals("", resultObj);

        } catch (ClassLoadException e) {
            fail();
        }
    }

    /**
     * testCreate03(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FE<br>
     * <br>
     * ͒l :IuWFNg̃NXARXgN^̃p[^2<br>
     * Ғl :CX^X<br>
     *
     * RXgN^̈2̎A
     * IuWFNg̃NXɃCX^X𐶐邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray03() {
        //ݒ
        String input = "java.util.Locale";
        String language = "es";
        String country = "MEXICO";

        try {
            //eXgs
            Object obj =
                ClassUtil.create(input, new Object[] { language, country });
            java.util.Locale resultObj = (java.util.Locale) obj;

            //ʊmF
            //NX
            assertEquals("java.util.Locale", obj.getClass().getName());

            //e
            assertEquals("MEXICO", resultObj.getCountry());
            assertEquals("es", resultObj.getLanguage());

        } catch (ClassLoadException e) {
            fail();
        }
    }

    /**
     * testCreate04(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FE<br>
     * <br>
     * ͒l :IuWFNg̃NX(TerasolunaΉ)ARXgN^̃p[^<br>
     * Ғl :CX^X<br>
     *
     * IuWFNgTerasolunaɑΉNX
     * CX^X𐶐邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray04() {
        //ݒ
        String input = ClassUtil.class.getName();

        try {
            //eXgs
            Object obj = ClassUtil.create(input, new Object[] {});

            //ʊmF
            assertEquals(input, obj.getClass().getName());

        } catch (ClassLoadException e) {
            fail();
        }
    }

    /**
     * testCreate05(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FG<br>
     * <br>
     * ͒l :*.classȂNX<br>
     * Ғl :ClassNotFoundException<br>
     *
     * w肵NX݂ȂꍇAClassNotFoundExceptionA
     * bvClassLoadException邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray05() {
        //ݒ
        String input = "java.lang.Str";

        try {
            //eXgs
            ClassUtil.create(input, new Object[] {});
        } catch (ClassLoadException e) {
            if (e.getMessage().indexOf("ClassNotFoundException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testCreate06(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FG<br>
     * <br>
     * ͒l :ۃNX<br>
     * Ғl :InstantiationException<br>
     * 
     * w肵NXۃNX̏ꍇAInstantiationExceptionA
     * bvOClassLoadException邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray06() {
        //ݒ
        String input = "javax.swing.AbstractAction";

        try {
            //eXgs
            ClassUtil.create(input, new Object[] { "1", "2" });
        } catch (ClassLoadException e) {
            if (e.getMessage().indexOf("InstantiationException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testCreate07(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FG<br>
     * <br>
     * ͒l :IuWFNg̃NXARXgN^̃p[^null<br>
     * Ғl :InvocationTargetException<br>
     *
     * IuWFNgłȂꍇAInvocationTargetExceptionA
     * bvOClassLoadException邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray07() {
        //ݒ
        String input = "java.lang.String";

        try {
            //eXgs
            ClassUtil.create(input, new Object[] { null });
        } catch (ClassLoadException e) {
            if (e.getMessage().indexOf("InvocationTargetException") == -1) {
                //ʊmF
                fail();
            }
        }
    }

    /**
     * testCreate08(String, Object[])B<br>
     * 
     * inj<br>
     * ϓ_FG<br>
     * <br>
     * ͒l :IuWFNg̃NXARXgN^̃p[^<br>
     * Ғl :IllegalArgumentException<br>
     *
     * IuWFNgłȂꍇAIllegalArgumentExceptionA
     * bvOClassLoadException邱ƂmFB<br>
     *
     */
    public void testCreateStringObjectArray08() {
        //ݒ
        String input = "java.lang.Void";
        try {
            //eXgs
            ClassUtil.create(input, new Object[] {});
        } catch (ClassLoadException e) {
            if (e.getMessage().indexOf("IllegalArgumentException") == -1) {
                //ʊmF
                fail();
            }
            if (e.getCause().getMessage().indexOf("class name is java.lang.Void") == -1) {
                //ʊmF
                fail();
            }
        }
    }
}
