/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.util.ArrayList;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.Var;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest06 extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest06.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest06(String name) {
        super(name);
    }

    /**
     * testValidateAlphaNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateAlphaNumericString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateAlphaNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateAlphaNumericString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateAlphaNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"a0A"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beanpp݂̂ō\ĂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString03() throws Exception {
        // O
        // bean : "a0A"
        Object bean = "a0A";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateAlphaNumericString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateAlphaNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"Zg3%"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanɔppȊO̕܂܂ĂꍇAG[ǉtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateAlphaNumericString04() throws Exception {
        // O
        // bean : "Zg3%"
        Object bean = "Zg3%";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b = new FieldChecks().validateAlphaNumericString(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateCapAlphaNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateCapAlphaNumericString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateCapAlphaNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateCapAlphaNumericString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateCapAlphaNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"ABC0"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean啶̔pp݂̂ō\ĂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString03() throws Exception {
        // O
        // bean : "ABC0"
        Object bean = "ABC0";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateCapAlphaNumericString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateCapAlphaNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"Aa0"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanɑ啶̔ppȊO̕܂܂ĂꍇAG[ǉtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateCapAlphaNumericString04() throws Exception {
        // O
        // bean : "Aa0"
        Object bean = "Aa0";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b = new FieldChecks().validateCapAlphaNumericString(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateNumber01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateNumber02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateNumber03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"T"iSpj<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * ͒lSp̏ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber03() throws Exception {
        // O
        // bean : "T"
        Object bean = "T";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateNumber04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * ͒llɕϊłȂꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber04() throws Exception {
        // O
        // bean : "test"
        Object bean = "test";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateNumber05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                integerLength="abc"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. - integerLength is not number. You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. - integerLength is not number. You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varintegerLengthlɕϊłȂꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber05() throws Exception {
        // O
        // bean : "5"
        Object bean = "5";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : var:integerLength="abc"
        Field field = new Field();
        Var var = new Var();
        var.setName("integerLength");
        var.setValue("abc");
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        try {
            // eXg{
            @SuppressWarnings("unused") boolean b =
                new FieldChecks().validateNumber(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            // 
            String message = "Mistake on validation definition file. "
                + "- integerLength is not number. "
                + "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateNumber06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:"5"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                scale="abc"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. - scale is not number. You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. - scale is not number. You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varscalelɕϊłȂꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber06() throws Exception {
        // O
        // bean : "5"
        Object bean = "5";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : var:scale="abc"
        Field field = new Field();
        Var var = new Var();
        var.setName("scale");
        var.setValue("abc");
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        try {
            // eXg{
            @SuppressWarnings("unused") boolean b =
                new FieldChecks().validateNumber(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            // 
            String message = "Mistake on validation definition file. "
                + "- scale is not number. "
                + "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateNumber07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_F
     * <br><br>
     * ͒lF() bean:"100.05"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                integerLength="5"<br>
     *                scale="3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * ͂ꂽ̐̌AvarintegerLength̒l菬Ǎvarscale̒l菬ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber07() throws Exception {
        // O
        // bean : "100.05"
        Object bean = "100.05";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : var:integerLength="5" scale="3"
        Field field = new Field();
        Var var1 = new Var();
        var1.setName("integerLength");
        var1.setValue("5");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("scale");
        var2.setValue("3");
        field.addVar(var2);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateNumber08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"100.05"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                integerLength="3"<br>
     *                scale="2"<br>
     *                isAccordedInteger="true"<br>
     *                isAccordedScale="true"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varisAccordedIntegertruew肳ĂāA͂ꂽ̐̌AvarintegerLength̒lƓAvarisAccordedScaletruew肳ĂāǍvarscale̒lƓꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber08() throws Exception {
        // O
        // bean : "100.05"
        Object bean = "100.05";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : var:integerLength="3" scale="2" isAccordedInteger="true" isAccordedScale="true"
        Field field = new Field();
        Var var1 = new Var();
        var1.setName("integerLength");
        var1.setValue("3");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("scale");
        var2.setValue("2");
        field.addVar(var2);
        
        Var var3 = new Var();
        var3.setName("isAccordedInteger");
        var3.setValue("true");
        field.addVar(var3);
        
        Var var4 = new Var();
        var4.setName("isAccordedScale");
        var4.setValue("true");
        field.addVar(var4);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateNumber09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"100.05"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                integerLength="5"<br>
     *                scale="3"<br>
     *                isAccordedInteger="test"<br>
     *                isAccordedScale="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varisAccordedIntegertrueȊO̕񂪎w肳ĂāA͂ꂽ̐̌AvarintegerLength̒l菬AvarisAccordedScaletrueȊO̕񂪎w肳ĂāǍvarscale̒l菬ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber09() throws Exception {
        // O
        // bean : "100.05"
        Object bean = "100.05";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : var:integerLength="5" scale="3" isAccordedInteger="test" isAccordedScale="test"
        Field field = new Field();
        
        Var var1 = new Var();
        var1.setName("integerLength");
        var1.setValue("5");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("scale");
        var2.setValue("3");
        field.addVar(var2);
        
        Var var3 = new Var();
        var3.setName("isAccordedInteger");
        var3.setValue("test");
        field.addVar(var3);
        
        Var var4 = new Var();
        var4.setName("isAccordedScale");
        var4.setValue("test");
        field.addVar(var4);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateNumber10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"100.05"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                integerLength="2"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * ͂ꂽ̐̌AvarintegerLength̒l傫ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber10() throws Exception {
        // O
        // bean : "100.05"
        Object bean = "100.05";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        
        // field : var:integerLength="2"
        Field field = new Field();
        Var var = new Var();
        var.setName("integerLength");
        var.setValue("2");
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);
        
        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateNumber11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"100.05"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                scale="1"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * ͂ꂽ̏̌Avarscale̒l傫ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber11() throws Exception {
        // O
        // bean : "100.05"
        Object bean = "100.05";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        
        // field : var:scale="1"
        Field field = new Field();
        Var var = new Var();
        var.setName("scale");
        var.setValue("1");
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);
        
        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateNumber12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"100.05"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                integerLength="5"<br>
     *                isAccordedInteger="true"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * varisAccordedIntegertruew肳ĂāA͂ꂽ̐̌AvarintegerLength̒l菬ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber12() throws Exception {
        // O
        // bean : "100.05"
        Object bean = "100.05";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : var:scale="5" isAccordedInteger="true"
        Field field = new Field();
        Var var1 = new Var();
        var1.setName("scale");
        var1.setValue("5");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("isAccordedInteger");
        var2.setValue("true");
        field.addVar(var2);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);
        
        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateNumber13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"100.05"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                scale="3"<br>
     *                isAccordedScale="true"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * varisAccordedScaletruew肳ĂāA͂ꂽ̏̌Avarscale̒l菬ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber13() throws Exception {
        // O
        // bean : "100.05"
        Object bean = "100.05";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : var:scale="3" isAccordedScale="true"
        Field field = new Field();
        Var var1 = new Var();
        var1.setName("scale");
        var1.setValue("3");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("isAccordedScale");
        var2.setValue("true");
        field.addVar(var2);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateNumber(bean, va, field, errors);
        
        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }
}