/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.mock;

import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.event.DataRowHandler;

/**
 * {@link QueryRowHandleDAO}̃bNłB
 * 
 * <p>
 * {@link MockQueryRowHandleDao#addResult(DataRowHandleCallback)}\bh<br>
 * {@link DataRowHandleCallback}^̃R[obNݒ肷邱ƂɂA<br>
 * {@link QueryRowHandleDAO#executeWithRowHandler(String, Object, DataRowHandler)}
 * sꂽۂ̏ݒł܂B <br>
 * </p>
 * <p>
 * ȉɗ܂B <br>
 * e[ũeXgf[^ȉ̏ꍇA
 * <table border=1>
 * <tr>
 * <th>test1</th>
 * <th>test2</th>
 * </tr>
 * <tr>
 * <td>aaa1</td>
 * <td>bbb1</td>
 * </tr>
 * <tr>
 * <td>aaa2</td>
 * <td>aaaa2</td>
 * </tr>
 * <tr>
 * <td colspan=2>...</td>
 * </tr>
 * <tr>
 * <td>aaa10</td>
 * <td>bbb10</td>
 * </tr>
 * </table>
 * bNւ̃f[^ݒ͈ȉ̂悤ɍs܂B
 * </p>
 * 
 * <pre>
 * // bNDAO쐬
 * MockQueryRowHandleDao queryRowHandleDao = new MockQueryRowHandleDao();
 * // executeWithRowHandler̊ҏ(R[obN)̐ݒ
 * queryRowHandleDao.addResult(new DataRowHandleCallback() {
 *     &#064;Override
 *     void handle(String sqlId, Object[] bindParams, DataRowHandler handler) {
 *         // eXgf[^
 *         for (int i = 0; i &lt; 10; i++) {
 *             TestData data = new TestData();
 *             data.setTest1(&quot;aaa&quot; + i);
 *             data.setTest2(&quot;bbb&quot; + i);
 *             handler.handleRow(data);
 *         }
 *     }
 * });
 * XxxBLogic blogic = new XxxBLogic();
 * blogic.setQueryRowHandleDAO(queryRowHandleDao);
 * blogic.execute(XXXX); // eXg\bhs
 * </pre>
 */
public class MockQueryRowHandleDao extends AbstractMockDao implements
        QueryRowHandleDAO {

    public void executeWithRowHandler(String sqlId, Object bindParams,
            DataRowHandler rowHandler) {
        addParam(new DaoParam(sqlId, bindParams));
        pollAndExecuteIfCallback(new Object[] { sqlId, bindParams, rowHandler });
    }

    /**
     * @param callback
     * @since 2.1
     */
    public void addResult(DataRowHandleCallback callback) {
        super.addResult(callback);
    }
}
