/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.testcase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.ex.unit.common.DefaultProperties;
import jp.terasoluna.fw.ex.unit.common.PropertyKeys;
import jp.terasoluna.fw.ex.unit.testcase.TestCaseUtils;
import jp.terasoluna.fw.ex.unit.util.ClassLoaderUtils;
import jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaoTestCase
extends AbstractTransactionalDataSourceSpringContextTests {
    private boolean loadDefaultConfig = true;

    public DaoTestCase() {
    }

    public DaoTestCase(String name) {
        super(name);
    }

    protected final String getConfigPath() {
        String contextRoot = DefaultProperties.getValue(PropertyKeys.WEBAPP_PATH);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("add " + contextRoot + " to classpath"));
        }
        ClassLoaderUtils.addClassPath(contextRoot);
        this.beforeGetConfig();
        return super.getConfigPath();
    }

    public <T> T getBean(String name) {
        Assert.notNull((Object)this.applicationContext, (String)"applicationContext is null!");
        return (T)this.applicationContext.getBean(name);
    }

    protected void beforeGetConfig() {
    }

    protected void addConfigLocations(List<String> configLocations) {
    }

    protected void onTearDown() throws Exception {
        super.onTearDown();
        ClassLoaderUtils.resetClassLoader();
    }

    protected final String[] getConfigLocations() {
        List<String> configLocations = null;
        configLocations = this.isLoadDefaultConfig() ? TestCaseUtils.getConfigLocationsForDaoTestCase(super.getConfigLocations()) : new ArrayList<String>();
        this.addConfigLocations(configLocations);
        String[] configs = configLocations.toArray(new String[configLocations.size()]);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("load configLocations = " + configLocations));
        }
        return configs;
    }

    public void setLoadDefaultConfig(boolean loadDefaultConfig) {
        this.loadDefaultConfig = loadDefaultConfig;
    }

    public boolean isLoadDefaultConfig() {
        return this.loadDefaultConfig;
    }

    protected void deleteFromTable(String name) {
        super.deleteFromTables(new String[]{name});
    }

    public void execute(String sql) throws DataAccessException {
        JdbcTemplateUtils.execute(this.jdbcTemplate, sql);
    }

    public int update(String sql) throws DataAccessException {
        return JdbcTemplateUtils.update(this.jdbcTemplate, sql);
    }

    public int update(String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.update(this.jdbcTemplate, sql, args);
    }

    public int[] batchUpdate(String ... sqls) throws DataAccessException {
        return JdbcTemplateUtils.batchUpdate(this.jdbcTemplate, sqls);
    }

    public long queryForLong(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForLong(this.jdbcTemplate, sql);
    }

    public long queryForLong(String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.queryForLong(this.jdbcTemplate, sql, args);
    }

    public int queryForInt(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForInt(this.jdbcTemplate, sql);
    }

    public int queryForInt(String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.queryForInt(this.jdbcTemplate, sql, args);
    }

    public String queryForString(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForString(this.jdbcTemplate, sql);
    }

    public String queryForString(String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.queryForString(this.jdbcTemplate, sql, args);
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) throws DataAccessException {
        return JdbcTemplateUtils.queryForObject(this.jdbcTemplate, sql, requiredType);
    }

    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws DataAccessException {
        return JdbcTemplateUtils.queryForObject(this.jdbcTemplate, sql, args, requiredType);
    }

    public Map<String, ?> queryForRowMap(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMap(this.jdbcTemplate, sql);
    }

    public Map<String, ?> queryForRowMap(String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMap(this.jdbcTemplate, sql, args);
    }

    public <T> T queryForRowObject(String sql, Class<T> clazz) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObject(this.jdbcTemplate, sql, clazz);
    }

    public <T> T queryForRowObject(String sql, Object[] args, Class<T> clazz) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObject(this.jdbcTemplate, sql, args, clazz);
    }

    public <T> List<T> queryForSingleColumnList(String sql, Class<T> elementType) throws DataAccessException {
        return JdbcTemplateUtils.queryForSingleColumnList(this.jdbcTemplate, sql, elementType);
    }

    public <T> List<T> queryForSingleColumnList(String sql, Object[] args, Class<T> elementType) throws DataAccessException {
        return JdbcTemplateUtils.queryForSingleColumnList(this.jdbcTemplate, sql, args, elementType);
    }

    public List<Map<String, ?>> queryForRowMapList(String sql) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMapList(this.jdbcTemplate, sql);
    }

    public List<Map<String, ?>> queryForRowMapList(String sql, Object[] args) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMapList(this.jdbcTemplate, sql, args);
    }

    public List<Map<String, ?>> queryForRowMapList(Class<?> clazz) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowMapList(this.jdbcTemplate, clazz);
    }

    public <T> List<T> queryForRowObjectList(String sql, Class<T> clazz) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObjectList(this.jdbcTemplate, sql, clazz);
    }

    public <T> List<T> queryForRowObjectList(String sql, Object[] args, Class<T> clazz) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObjectList(this.jdbcTemplate, sql, args, clazz);
    }

    public <T> List<T> queryForRowObjectList(Class<T> clazz) throws DataAccessException {
        return JdbcTemplateUtils.queryForRowObjectList(this.jdbcTemplate, clazz);
    }

    public String createSelectSql(String tableName, String[] fieldNames) {
        return JdbcTemplateUtils.createSelectSql(tableName, fieldNames);
    }

    public String createSelectSql(String tableName, Class<?> clazz) {
        return JdbcTemplateUtils.createSelectSql(tableName, clazz);
    }

    public String createSelectSql(Class<?> clazz) {
        return JdbcTemplateUtils.createSelectSql(clazz);
    }

    public String createInsertSql(String tableName, String[] fieldNames) {
        return JdbcTemplateUtils.createInsertSql(tableName, fieldNames);
    }

    public String createInsertSql(String tableName, Class<?> clazz) {
        return JdbcTemplateUtils.createInsertSql(tableName, clazz);
    }

    public String createInsertSql(Class<?> clazz) {
        return JdbcTemplateUtils.createInsertSql(clazz);
    }
}

