package jp.terasoluna.fw.collector.db;

import static org.junit.Assert.*;
import jp.terasoluna.fw.collector.db.DBCollector;
import jp.terasoluna.fw.collector.db.QueueingDataRowHandlerImpl;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueueingDataRowHandlerImplTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        QueueingDataRowHandlerImpl.setVerbose(true);
    }

    @After
    public void tearDown() throws Exception {
        QueueingDataRowHandlerImpl.setVerbose(false);
    }

    /**
     * testHandleRow
     */
    @Test
    public void testHandleRow001() {
        QueueingDataRowHandlerImpl drh = new QueueingDataRowHandlerImpl();

        assertNotNull(drh);

        try {
            drh.handleRow(null);
            drh.handleRow(null);
            drh.handleRow(null);
            drh.handleRow(null);
            drh.handleRow(null);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * testHandleRow
     */
    @Test
    public void testHandleRow002() {
        QueueingDataRowHandlerImpl drh = new QueueingDataRowHandlerImpl();

        assertNotNull(drh);

        try {
            drh.handleRow("hoge1");
            drh.handleRow("hoge2");
            drh.handleRow(null);
            drh.handleRow("hoge3");
            drh.handleRow("hoge4");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * testHandleRow
     */
    @Test
    public void testHandleRow003() {
        QueueingDataRowHandlerImpl drh = new QueueingDataRowHandlerImpl();
        DBCollector<HogeBean> dbCollector = new DBCollectorStub001();
        drh.setDbCollector(dbCollector);

        assertNotNull(drh);

        try {
            drh.handleRow("hoge1");
            drh.handleRow("hoge2");
            drh.handleRow(null);
            drh.handleRow("hoge3");
            drh.handleRow("hoge4");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * testHandleRow
     */
    @Test
    public void testHandleRow004() {
        QueueingDataRowHandlerImpl drh = new QueueingDataRowHandlerImpl();
        DBCollector<HogeBean> dbCollector = new DBCollectorStub001();
        drh.setDbCollector(dbCollector);

        assertNotNull(drh);

        try {
            drh.handleRow("hoge1");
            drh.handleRow("hoge2");
            drh.interrupted = true;
            drh.handleRow("hoge3");
            drh.handleRow("hoge4");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * testHandleRow
     */
    @Test
    public void testHandleRow005() {
        QueueingDataRowHandlerImpl drh = new QueueingDataRowHandlerImpl();
        DBCollectorStub001 dbCollector = new DBCollectorStub001();
        drh.setDbCollector(dbCollector);

        assertNotNull(drh);

        try {
            drh.handleRow("hoge1");
            drh.handleRow("hoge2");
            dbCollector.exceptionFlag = true;
            drh.handleRow("hoge3");
            drh.handleRow("hoge4");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

    /**
     * testDelayCollect
     */
    @Test
    public void testDelayCollect001() {
        QueueingDataRowHandlerImpl drh = new QueueingDataRowHandlerImpl();
        DBCollector<HogeBean> dbCollector = new DBCollectorStub001();
        drh.setDbCollector(dbCollector);

        assertNotNull(drh);

        try {
            drh.handleRow("hoge1");
            drh.handleRow("hoge2");
            drh.interrupted = true;
            drh.delayCollect();
            drh.handleRow("hoge3");
            drh.delayCollect();
            drh.handleRow("hoge4");
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }
    }

}
