/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.fw.ex.unit.mock.file;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.file.dao.FileLineWriter;

/**
 * {@link FileLineWriter}̃bNNXB
 * <p>
 * {@link FileLineWriter#printDataLine(Object)}ŏo͂ꂽIuWFNg<br>
 * {@link MockFileLineWriter#getPrintDataLineList()}Ŏ擾ł܂B<br>
 * ܂{@link FileLineWriter#printHeaderLine(List)}A
 * {@link FileLineWriter#printTrailerLine(List)}̏o͓eꂼ<br>
 * {@link MockFileLineWriter#getPrintHeaderLineList()}A
 * {@link MockFileLineWriter#getPrintTrailerLineList()}Ŏ擾ł܂B<br>
 * {@link FileLineWriter}<code>close</code>ꂽǂ
 * {@link MockFileLineWriter#isClosed()}ɂĊmFł܂B
 * </p>
 * 
 * @param <T> sIuWFNgNX
 */
public class MockFileLineWriter<T> implements FileLineWriter<T> {

    /**
     * printHeaderLine \bh̃Xg
     */
    private final List<List<String>> headerLineList = new ArrayList<List<String>>();

    /**
     * printTrailerLine \bh̃Xg
     */
    private final List<List<String>> trailerLineList = new ArrayList<List<String>>();

    /**
     * printDataLine \bh̃Xg
     */
    private final List<T> dataLineList = new ArrayList<T>();

    private boolean isClosed = false;

    /**
     * RXgN^B
     */
    public MockFileLineWriter() {
    }

    /**
     * <p>
     * FileLineWriter#printHeaderLine() ̃bN\bhB
     * </p>
     *  headerLineList Ɋi[B
     * 
     * @param headerLine wb_
     */
    public void printHeaderLine(List<String> headerLine) {

        this.headerLineList.add(headerLine);
    }

    /**
     * <p>
     * FileLineWriter#printDataLine() ̃bN\bhB
     * </p>
     *  dataLineList Ɋi[B
     * 
     * @param dataLine f[^
     */
    public void printDataLine(T dataLine) {

        this.dataLineList.add(dataLine);
    }

    /**
     * <p>
     * FileLineWriter#printTrailerLine() ̃bN\bhB
     * </p>
     *  trailerLineList Ɋi[B
     * 
     * @param trailerLine g[
     */
    public void printTrailerLine(List<String> trailerLine) {

        this.trailerLineList.add(trailerLine);
    }

    /**
     * <p>
     * FileLineWriter#closeFile() ̃bN\bhB
     * </p>
     * 
     */
    public void closeFile() {
        isClosed = true;
    }

    /**
     * printHeaderLine \bh̃XgԋpB
     * 
     * @return printHeaderLine \bh̃Xg
     */
    public List<List<String>> getPrintHeaderLineList() {
        return this.headerLineList;
    }

    /**
     * printTrailerLine \bh̃XgԋpB
     * 
     * @return printTrailerLine \bh̃Xg
     */
    public List<List<String>> getPrintTrailerLineList() {
        return this.trailerLineList;
    }

    /**
     * printDataLine \bh̃XgԋpB
     * 
     * @return printDataLine \bh̃Xg
     */
    public List<T> getPrintDataLineList() {
        return this.dataLineList;
    }

    /**
     * closeꂽǂԋp܂B
     * 
     * @return closeꂽǂ(<code>true</code>...closeꂽA<code>false</code>
     *         ...closeĂȂ)
     */
    public boolean isClosed() {
        return isClosed;
    }

    /**
     * ێԂNA܂B
     */
    public void clear() {
        dataLineList.clear();
        headerLineList.clear();
        trailerLineList.clear();
        isClosed = false;
    }
}
