/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io.impl;

import java.util.Iterator;
import java.util.Map;

import jp.terasoluna.fw.ex.unit.io.Comparison;
import jp.terasoluna.fw.ex.unit.io.InputSource;
import jp.terasoluna.fw.ex.unit.io.OutputTarget;
import jp.terasoluna.fw.ex.unit.util.DefaultEqualsStrategy;
import jp.terasoluna.fw.ex.unit.util.EqualsStrategy;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ̓\[XۃNXB
 * 
 * {NXp̓\[XNX͈ȉ̐ݒsetterɂčs܂B
 * 
 * <table border=1>
 * <tr>
 * <th>p[^</th>
 * <th></th>
 * <th>ݒӏ</th>
 * <th>K{</th>
 * </tr>
 * <tr>
 * <td>header</td>
 * <td>}bsOBeañvpeBzB</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>headerMap</td>
 * <td>wb_񂩂wb_֕̕ϊ邽߂̃}bvBCSVt@C̈sڂ̃wb_BeañvpeBł͂ȂA
 * _łꍇAvpeB()ւ̃}bvw肵ĂB</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>equalStrategy</td>
 * <td>s̃IuWFNgm̔rBftHg{@link DefaultEqualsStrategy}gp܂B</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * </table>
 * 
 */
public abstract class AbstractInputSource<T> implements InputSource<T> {
    /**
     * wb_(̓f[^擾̃wb_)B
     */
    protected String[] header = null;

    /**
     * ̃wb_񂩂wb_֕̕ϊ邽߂̃}bvB
     */
    protected Map<String, String> headerMap = null;

    /**
     * ftHg̃IuWFNgrBEffective Javã[ɏ]܂B
     */
    protected EqualsStrategy equalStrategy = new DefaultEqualsStrategy();

    public Comparison compare(InputSource<T> target) {
        Iterator<T> targetItr = target.getIterator();
        Iterator<T> thisItr = this.getIterator();
        int index = 0;

        boolean targetHasNext = targetItr.hasNext();
        boolean thisHasNext = thisItr.hasNext();

        while (targetHasNext && thisHasNext) {
            T o1 = thisItr.next();
            T o2 = targetItr.next();

            if (!getEqualStrategy().equals(o1, o2)) {
                String message = "index[" + index + "] "
                        + ToStringBuilder.reflectionToString(o1)
                        + " does't equal "
                        + ToStringBuilder.reflectionToString(o2);
                return Comparison.notEqual(message);
            }

            index++;
            targetHasNext = targetItr.hasNext();
            thisHasNext = thisItr.hasNext();
        }
        return (targetHasNext || thisHasNext) ? Comparison
                .notEqual("length is wrong") : Comparison.equal();
    }

    public void to(OutputTarget<T> target) {
        Iterator<T> itr = getIterator();
        if (getHeader() != null) {
            target.writeHeader(getHeader());
        }
        while (itr.hasNext()) {
            T obj = itr.next();
            target.write(obj);
        }
        target.close();
    }

    public EqualsStrategy getEqualStrategy() {
        return equalStrategy;
    }

    public void setEqualStrategy(EqualsStrategy equalStrategy) {
        this.equalStrategy = equalStrategy;
    }

    public String[] getHeader() {
        return header;
    }

    public void setHeader(String[] header) {
        this.header = header;
    }

    public Map<String, String> getHeaderMap() {
        return headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

}
