/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.IllegalClassTypeException;
import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

/**
 * 
 * 
 */
public abstract class BatchUtilTestBase extends TestCase {
    // private Log log = LogFactory.getLog(BatchUtilTest.class);
    private Log log = getLog();

    abstract Log getLog();

    /**
     * testBatchUtil001
     * @throws Exception
     */
    public void testBatchUtil001() throws Exception {
        BatchUtil bu = new BatchUtil();
        assertNotNull(bu);
    }

    /**
     * 񌋍\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * ͂ꂽz̓eɌ邩ǂmFB <br>
     * mFځF<br>
     * ꂽ񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testCat01() throws Exception {

        // eXg̓f[^ݒ
        String[] args = { "test1", "test2" };

        // eXg{
        String result = BatchUtil.cat((Object[]) args);

        // ʌ
        assertEquals("test1test2", result);
    }

    /**
     * 񌋍\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * nullݒ肳ꂽꍇnullԋp邱ƂmFB <br>
     * mFځF<br>
     * nullԋp邱<br>
     * @throws Exception
     */
    public void testCat02() throws Exception {

        // eXg̓f[^ݒ
        String[] args = null;

        // eXg{
        String result = BatchUtil.cat((Object[]) args);

        // ʌ
        assertNull(result);
    }

    /**
     * 񌋍\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * 󕶎ݒ肳ꂽꍇA󕶎ԋp邱ƂmFB <br>
     * mFځF<br>
     * 󕶎ԋp邱<br>
     * @throws Exception
     */
    public void testCat03() throws Exception {

        // eXg̓f[^ݒ
        String[] args = { "" };

        // eXg{
        String result = BatchUtil.cat((Object[]) args);

        // ʌ
        assertEquals("", result);
    }

    /**
     * 񌋍\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * 3ȏ̕񂪐ݒ肳ĂAԂ̕null܂܂ĂꍇAnull͔΂Čԋp邱ƂmFB <br>
     * mFځF<br>
     * null΂񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testCat04() throws Exception {

        // eXg̓f[^ݒ
        String[] args = { "test1", null, "test2" };

        // eXg{
        String result = BatchUtil.cat((Object[]) args);

        // ʌ
        assertEquals("test1test2", result);
    }

    /**
     * CtHO̊JnbZ[W擾郁\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * ͂ɕ^Az肵O񂪕ԋp邱ƂmFB<br>
     * mFځF<br>
     * ͕񂪖ߍ܂ꂽO񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testGetInfoLogStartMsg01() throws Exception {

        // eXg̓f[^ݒ
        String arg = "test1";

        // eXg{
        String result = BatchUtil.getInfoLogStartMsg(arg);

        // ʌ
        assertEquals("[test1] Jn", result);
    }

    /**
     * CtHO̊JnbZ[W擾郁\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * ͂null^Az肵O񂪕ԋp邱ƂmFB<br>
     * mFځF<br>
     * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testGetInfoLogStartMsg02() throws Exception {

        // eXg̓f[^ݒ
        String arg = null;

        // eXg{
        String result = BatchUtil.getInfoLogStartMsg(arg);

        // ʌ
        assertEquals("[] Jn", result);
    }

    /**
     * CtHO̊JnbZ[W擾郁\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * ͂ɋ󕶎^Az肵O񂪕ԋp邱ƂmFB<br>
     * mFځF<br>
     * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testGetInfoLogStartMsg03() throws Exception {

        // eXg̓f[^ݒ
        String arg = "";

        // eXg{
        String result = BatchUtil.getInfoLogStartMsg(arg);

        // ʌ
        assertEquals("[] Jn", result);
    }

    /**
     * CtHȌIbZ[W擾郁\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * ͂ɕ^Az肵O񂪕ԋp邱ƂmFB<br>
     * mFځF<br>
     * ͕񂪖ߍ܂ꂽO񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testGetInfoLogEndMsg01() throws Exception {

        // eXg̓f[^ݒ
        String arg = "test1";

        // eXg{
        String result = BatchUtil.getInfoLogEndMsg(arg);

        // ʌ
        assertEquals("[test1] I", result);
    }

    /**
     * CtHȌIbZ[W擾郁\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * ͂ɋ󕶎^Az肵O񂪕ԋp邱ƂmFB<br>
     * mFځF<br>
     * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testGetInfoLogEndMsg02() throws Exception {

        // eXg̓f[^ݒ
        String arg = null;

        // eXg{
        String result = BatchUtil.getInfoLogEndMsg(arg);

        // ʌ
        assertEquals("[] I", result);
    }

    /**
     * CtHȌIbZ[W擾郁\bh̃eXg<br>
     * <br>
     * eXgTvF<br>
     * ͂ɋ󕶎^Az肵O񂪕ԋp邱ƂmFB<br>
     * mFځF<br>
     * ͕񂪖ߍ܂ȂO񂪕ԋp邱<br>
     * @throws Exception
     */
    public void testGetInfoLogEndMsg03() throws Exception {

        // eXg̓f[^ݒ
        String arg = "";

        // eXg{
        String result = BatchUtil.getInfoLogEndMsg(arg);

        // ʌ
        assertEquals("[] I", result);
    }

    /**
     * testGetTransactionDefinition01
     * @throws Exception
     */
    public void testGetTransactionDefinition01() throws Exception {

        // eXg{
        TransactionDefinition result = BatchUtil.getTransactionDefinition();

        // ʌ
        assertNotNull(result);
    }

    /**
     * testGetTransactionDefinition02
     * @throws Exception
     */
    public void testGetTransactionDefinition02() throws Exception {

        // eXg{
        TransactionDefinition result = BatchUtil.getTransactionDefinition(
                TransactionDefinition.PROPAGATION_REQUIRED,
                TransactionDefinition.ISOLATION_DEFAULT,
                TransactionDefinition.TIMEOUT_DEFAULT, false);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testChangeListToArray01
     * @throws Exception
     */
    public void testChangeListToArray01() throws Exception {

        // eXg̓f[^ݒ
        List<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        list.add("test3");

        // eXg{
        String[] result = BatchUtil.changeListToArray(list, String.class);

        // ʌ
        assertEquals("test1", result[0]);
        assertEquals("test2", result[1]);
        assertEquals("test3", result[2]);
    }

    /**
     * testChangeListToArray02
     * @throws Exception
     */
    public void testChangeListToArray02() throws Exception {

        // eXg̓f[^ݒ
        List<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        list.add("test3");
        try {

            // eXg{
            @SuppressWarnings("unused")
            String[] result = BatchUtil.changeListToArray(list, null);

            // ʌ
            fail();
        } catch (IllegalClassTypeException e) {
            assertNotNull(e);
        }

    }

    /**
     * testChangeListToArray03
     * @throws Exception
     */
    public void testChangeListToArray03() throws Exception {

        // eXg̓f[^ݒ
        List<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        list.add("test3");
        try {
            // eXg{
            @SuppressWarnings("unused")
            String[] result = BatchUtil.changeListToArray(list, Integer.class);

            // ʌ
            fail();
        } catch (IllegalClassTypeException e) {
            assertNotNull(e);
        }

    }

    /**
     * testGetProperties01
     * @throws Exception
     */
    public void testGetProperties01() throws Exception {

        // eXg{
        List<String> result = BatchUtil.getProperties("messages", "errors");

        // ʌ
        assertEquals(26, result.size());
    }

    /**
     * testStartTransaction01
     * @throws Exception
     */
    public void testStartTransaction01() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = null;

        // eXg{
        TransactionStatus result = BatchUtil.startTransaction(tran);

        // ʌ
        assertNull(result);
    }

    /**
     * testStartTransaction02
     * @throws Exception
     */
    public void testStartTransaction02() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();

        // eXg{
        TransactionStatus result = BatchUtil.startTransaction(tran);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testStartTransaction03
     * @throws Exception
     */
    public void testStartTransaction03() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();

        // eXg{
        TransactionStatus result = BatchUtil.startTransaction(tran, log);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testStartTransaction04
     * @throws Exception
     */
    public void testStartTransaction04() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();

        // eXg{
        TransactionStatus result = BatchUtil.startTransaction(tran,
                TransactionDefinition.PROPAGATION_REQUIRED,
                TransactionDefinition.ISOLATION_DEFAULT,
                TransactionDefinition.TIMEOUT_DEFAULT, false);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testStartTransaction05
     * @throws Exception
     */
    public void testStartTransaction05() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();

        // eXg{
        TransactionStatus result = BatchUtil.startTransaction(tran,
                TransactionDefinition.PROPAGATION_REQUIRED,
                TransactionDefinition.ISOLATION_DEFAULT,
                TransactionDefinition.TIMEOUT_DEFAULT, false, log);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testStartTransaction06
     * @throws Exception
     */
    public void testStartTransaction06() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionDefinition def = BatchUtil.getTransactionDefinition();

        // eXg{
        TransactionStatus result = BatchUtil.startTransaction(tran, def);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testStartTransaction07
     * @throws Exception
     */
    public void testStartTransaction07() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionDefinition def = BatchUtil.getTransactionDefinition();

        // eXg{
        TransactionStatus result = BatchUtil.startTransaction(tran, def, log);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testStartTransactions01
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public void testStartTransactions01() throws Exception {
        // eXg̓f[^ݒ
        TransactionDefinition def = BatchUtil.getTransactionDefinition();
        Map<String, PlatformTransactionManager> tranMap = new HashMap();
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        tranMap.put("tran", tran);

        // eXg{
        Map<String, TransactionStatus> result = BatchUtil.startTransactions(
                def, tranMap);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testStartTransactions02
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public void testStartTransactions02() throws Exception {
        // eXg̓f[^ݒ
        TransactionDefinition def = BatchUtil.getTransactionDefinition();
        Map<String, PlatformTransactionManager> tranMap = new HashMap();
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        tranMap.put("tran", tran);

        // eXg{
        Map<String, TransactionStatus> result = BatchUtil.startTransactions(
                def, tranMap, log);

        // ʌ
        assertNotNull(result);
    }

    /**
     * testCommitTransaction01
     * @throws Exception
     */
    public void testCommitTransaction01() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        try {
            BatchUtil.commitTransaction(tran, stat);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testCommitTransaction02
     * @throws Exception
     */
    public void testCommitTransaction02() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        try {
            BatchUtil.commitTransaction(tran, stat, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testCommitTransactions01
     * @throws Exception
     */
    public void testCommitTransactions01() throws Exception {
        // eXg̓f[^ݒ
        Map<String, PlatformTransactionManager> tranMap = new HashMap<String, PlatformTransactionManager>();
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        tranMap.put("tran", tran);
        Map<String, TransactionStatus> statMap = new HashMap<String, TransactionStatus>();

        // eXg{
        try {
            BatchUtil.commitTransactions(tranMap, statMap);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testCommitTransactions02
     * @throws Exception
     */
    public void testCommitTransactions02() throws Exception {
        // eXg̓f[^ݒ
        Map<String, PlatformTransactionManager> tranMap = new HashMap<String, PlatformTransactionManager>();
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        tranMap.put("tran", tran);
        Map<String, TransactionStatus> statMap = new HashMap<String, TransactionStatus>();
        statMap.put("tran", new TransactionStatusStub());

        // eXg{
        try {
            BatchUtil.commitTransactions(tranMap, statMap, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testEndTransaction01
     * @throws Exception
     */
    public void testEndTransaction01() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        try {
            BatchUtil.endTransaction(tran, stat);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testEndTransaction02
     * @throws Exception
     */
    public void testEndTransaction02() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        try {
            BatchUtil.endTransaction(tran, stat, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testEndTransactions01
     * @throws Exception
     */
    public void testEndTransactions01() throws Exception {
        // eXg̓f[^ݒ
        Map<String, PlatformTransactionManager> tranMap = new HashMap<String, PlatformTransactionManager>();
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        tranMap.put("tran", tran);
        Map<String, TransactionStatus> statMap = new HashMap<String, TransactionStatus>();
        statMap.put("tran", new TransactionStatusStub());

        // eXg{
        boolean result = false;
        try {
            result = BatchUtil.endTransactions(tranMap, statMap);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertTrue(result);
    }

    /**
     * testEndTransactions02
     * @throws Exception
     */
    public void testEndTransactions02() throws Exception {
        // eXg̓f[^ݒ
        Map<String, PlatformTransactionManager> tranMap = new HashMap<String, PlatformTransactionManager>();
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        PlatformTransactionManager tran2 = new PlatformTransactionManagerStub2();
        tranMap.put("tran", tran);
        tranMap.put("tran2", tran2);
        Map<String, TransactionStatus> statMap = new HashMap<String, TransactionStatus>();
        statMap.put("tran", new TransactionStatusStub());
        statMap.put("tran2", new TransactionStatusStub());

        // eXg{
        boolean result = true;
        try {
            result = BatchUtil.endTransactions(tranMap, statMap, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertFalse(result);
    }

    /**
     * testSetSavepoint01
     * @throws Exception
     */
    public void testSetSavepoint01() throws Exception {
        // eXg̓f[^ݒ

        // eXg{
        Object result = null;
        try {
            result = BatchUtil.setSavepoint(new TransactionStatusStub());
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testSetSavepoint02
     * @throws Exception
     */
    public void testSetSavepoint02() throws Exception {
        // eXg̓f[^ݒ

        // eXg{
        Object result = null;
        try {
            result = BatchUtil.setSavepoint(new TransactionStatusStub(), log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testReleaseSavepoint01
     * @throws Exception
     */
    public void testReleaseSavepoint01() throws Exception {
        // eXg̓f[^ݒ

        // eXg{
        try {
            BatchUtil.releaseSavepoint(new TransactionStatusStub(),
                    new Object());
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testReleaseSavepoint02
     * @throws Exception
     */
    public void testReleaseSavepoint02() throws Exception {
        // eXg̓f[^ݒ

        // eXg{
        try {
            BatchUtil.releaseSavepoint(new TransactionStatusStub(),
                    new Object(), log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testRollbackSavepoint01
     * @throws Exception
     */
    public void testRollbackSavepoint01() throws Exception {
        // eXg̓f[^ݒ

        // eXg{
        try {
            BatchUtil.rollbackSavepoint(new TransactionStatusStub(),
                    new Object());
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testRollbackSavepoint02
     * @throws Exception
     */
    public void testRollbackSavepoint02() throws Exception {
        // eXg̓f[^ݒ

        // eXg{
        try {
            BatchUtil.rollbackSavepoint(new TransactionStatusStub(),
                    new Object(), log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testRollbackTransaction01
     * @throws Exception
     */
    public void testRollbackTransaction01() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        try {
            BatchUtil.rollbackTransaction(tran, stat);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testRollbackTransaction02
     * @throws Exception
     */
    public void testRollbackTransaction02() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        try {
            BatchUtil.rollbackTransaction(tran, stat, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
    }

    /**
     * testCommitRestartTransaction01
     * @throws Exception
     */
    public void testCommitRestartTransaction01() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.commitRestartTransaction(tran, stat);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testCommitRestartTransaction02
     * @throws Exception
     */
    public void testCommitRestartTransaction02() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.commitRestartTransaction(tran, stat, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testCommitRestartTransaction03
     * @throws Exception
     */
    public void testCommitRestartTransaction03() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();
        TransactionDefinition def = BatchUtil.getTransactionDefinition();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.commitRestartTransaction(tran, stat, def);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testCommitRestartTransaction04
     * @throws Exception
     */
    public void testCommitRestartTransaction04() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();
        TransactionDefinition def = BatchUtil.getTransactionDefinition();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.commitRestartTransaction(tran, stat, def, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testRollbackRestartTransaction001
     * @throws Exception
     */
    public void testRollbackRestartTransaction001() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.rollbackRestartTransaction(tran, stat);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testRollbackRestartTransaction002
     * @throws Exception
     */
    public void testRollbackRestartTransaction002() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.rollbackRestartTransaction(tran, stat, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testRollbackRestartTransaction003
     * @throws Exception
     */
    public void testRollbackRestartTransaction003() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();
        TransactionDefinition def = BatchUtil.getTransactionDefinition();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.rollbackRestartTransaction(tran, stat, def);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testRollbackRestartTransaction004
     * @throws Exception
     */
    public void testRollbackRestartTransaction004() throws Exception {
        // eXg̓f[^ݒ
        PlatformTransactionManager tran = new PlatformTransactionManagerStub();
        TransactionStatus stat = new TransactionStatusStub();
        TransactionDefinition def = BatchUtil.getTransactionDefinition();

        // eXg{
        TransactionStatus result = null;
        try {
            result = BatchUtil.rollbackRestartTransaction(tran, stat, def, log);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
            return;
        }

        // ʌ
        assertNotNull(result);
    }

    /**
     * testGetMemoryInfo001
     * @throws Exception
     */
    public void testGetMemoryInfo001() throws Exception {
        String info = BatchUtil.getMemoryInfo();

        assertNotNull(info);
        assertTrue(info.startsWith("Java memory info : "));
    }
}
