/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.tag;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.tag.DynamicAttribute;
import com.mockrunner.tag.DynamicChild;
import com.mockrunner.tag.NestedBodyTag;
import com.mockrunner.tag.NestedSimpleTag;
import com.mockrunner.tag.NestedStandardTag;
import com.mockrunner.tag.NestedTag;
import com.mockrunner.util.common.StringUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagUtil {
    private static final Log log = LogFactory.getLog((Class)(class$com$mockrunner$tag$TagUtil == null ? (class$com$mockrunner$tag$TagUtil = TagUtil.class$("com.mockrunner.tag.TagUtil")) : class$com$mockrunner$tag$TagUtil));
    static /* synthetic */ Class class$com$mockrunner$tag$TagUtil;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$DynamicAttributes;

    public static Object createNestedTagInstance(Class clazz, Object object, Map map) {
        Object t;
        if (null == clazz) {
            throw new IllegalArgumentException("tag must not be null");
        }
        try {
            t = clazz.newInstance();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new NestedApplicationException(exception);
        }
        return TagUtil.createNestedTagInstance(t, object, map);
    }

    public static Object createNestedTagInstance(Object object, Object object2, Map map) {
        if (null == object) {
            throw new IllegalArgumentException("tag must not be null");
        }
        NestedTag nestedTag = null;
        if (object instanceof BodyTag) {
            TagUtil.checkPageContext(object2);
            nestedTag = new NestedBodyTag((BodyTag)object, (PageContext)object2, map);
        } else if (object instanceof Tag) {
            TagUtil.checkPageContext(object2);
            nestedTag = new NestedStandardTag((Tag)object, (PageContext)object2, map);
        } else if (object instanceof SimpleTag) {
            TagUtil.checkJspContext(object2);
            nestedTag = new NestedSimpleTag((SimpleTag)object, (JspContext)object2, map);
        } else {
            throw new IllegalArgumentException("tag must be an instance of Tag or SimpleTag");
        }
        return nestedTag;
    }

    public static void handleException(Tag tag, Throwable throwable) throws JspException {
        if (tag instanceof TryCatchFinally) {
            try {
                ((TryCatchFinally)tag).doCatch(throwable);
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        if (throwable instanceof JspException) {
            throw (JspException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new JspException(throwable);
    }

    public static void handleFinally(Tag tag) {
        if (tag instanceof TryCatchFinally) {
            ((TryCatchFinally)tag).doFinally();
        }
    }

    private static void checkPageContext(Object object) {
        if (object instanceof PageContext) {
            return;
        }
        throw new IllegalArgumentException("pageContext must be an instance of PageContext");
    }

    private static void checkJspContext(Object object) {
        if (object instanceof JspContext) {
            return;
        }
        throw new IllegalArgumentException("pageContext must be an instance of JspContext");
    }

    public static void populateTag(Object object, Map map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                if (v instanceof DynamicAttribute) {
                    TagUtil.populateDynamicAttribute(object, string, (DynamicAttribute)v);
                    return;
                }
                if (PropertyUtils.isWriteable((Object)object, (String)string)) {
                    BeanUtils.copyProperty((Object)object, (String)string, map.get(string));
                    continue;
                }
                if (!(object instanceof DynamicAttributes)) continue;
                TagUtil.populateDynamicAttribute(object, string, new DynamicAttribute(null, v));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new NestedApplicationException(exception);
        }
    }

    private static void populateDynamicAttribute(Object object, String string, DynamicAttribute dynamicAttribute) throws JspException {
        if (!(object instanceof DynamicAttributes)) {
            String string2 = "Attribute " + string + " specified as dynamic attribute but tag ";
            string2 = string2 + "is not an instance of " + (class$javax$servlet$jsp$tagext$DynamicAttributes == null ? (class$javax$servlet$jsp$tagext$DynamicAttributes = TagUtil.class$("javax.servlet.jsp.tagext.DynamicAttributes")) : class$javax$servlet$jsp$tagext$DynamicAttributes).getName();
            throw new IllegalArgumentException(string2);
        }
        ((DynamicAttributes)object).setDynamicAttribute(dynamicAttribute.getUri(), string, dynamicAttribute.getValue());
    }

    public static void evalBody(List list, Object object) throws JspException {
        for (int i = 0; i < list.size(); ++i) {
            int n;
            Object e = list.get(i);
            if (e instanceof NestedBodyTag) {
                n = ((NestedBodyTag)e).doLifecycle();
                if (5 != n) continue;
                return;
            }
            if (e instanceof NestedStandardTag) {
                n = ((NestedStandardTag)e).doLifecycle();
                if (5 != n) continue;
                return;
            }
            if (e instanceof NestedSimpleTag) {
                ((NestedSimpleTag)e).doLifecycle();
                continue;
            }
            try {
                if (object instanceof PageContext) {
                    ((PageContext)object).getOut().print(TagUtil.getChildText(e));
                    continue;
                }
                if (object instanceof JspContext) {
                    ((JspContext)object).getOut().print(TagUtil.getChildText(e));
                    continue;
                }
                throw new IllegalArgumentException("pageContext must be an instance of JspContext");
            }
            catch (IOException iOException) {
                log.error((Object)iOException.getMessage(), (Throwable)iOException);
                throw new NestedApplicationException(iOException);
            }
        }
    }

    private static String getChildText(Object object) {
        if (null == object) {
            return "null";
        }
        if (object instanceof DynamicChild) {
            Object object2 = ((DynamicChild)object).evaluate();
            if (null == object2) {
                return "null";
            }
            return object2.toString();
        }
        return object.toString();
    }

    public static String dumpTag(NestedTag nestedTag, StringBuffer stringBuffer, int n) {
        StringUtil.appendTabs(stringBuffer, n);
        stringBuffer.append("<" + nestedTag.getClass().getName() + ">\n");
        TagUtil.dumpTagTree(nestedTag.getChilds(), stringBuffer, n);
        StringUtil.appendTabs(stringBuffer, n);
        stringBuffer.append("</" + nestedTag.getClass().getName() + ">");
        return stringBuffer.toString();
    }

    public static void dumpTagTree(List list, StringBuffer stringBuffer, int n) {
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof NestedTag) {
                TagUtil.dumpTag((NestedTag)e, stringBuffer, n + 1);
            } else {
                StringUtil.appendTabs(stringBuffer, n + 1);
                stringBuffer.append(list.get(i).toString());
            }
            stringBuffer.append("\n");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

