package jp.terasoluna.batch.functionsample.b008;

import java.util.Map;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupportImpl;
import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.file.FileCollector;
import jp.terasoluna.fw.collector.util.CollectorUtility;
import jp.terasoluna.fw.collector.util.ControlBreakChecker;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

/**
 * Rg[uCN@\̃Tv<br>
 * <p>
 * OFC:\tmpzKEN_ALL.CSVt@Czu邱<br>
 * </p>
 * <p>
 * KEN_ALL.CSV́AL̓{XO[ṽz[y[W_E[hł܂B<br>
 * {@link http://www.post.japanpost.jp/zipcode/download.html}
 * </p>
 * <p>
 * TveFt@Cǂݍ݁ADBɍXVTvB <br>
 * Oł͕̃uCNL[gpARg[uCN<br>
 * Oւ̃wb_óAs̃JEgsĂB<br>
 * ㏈ł͒P̃uCNL[pāARg[uCN̔̍ۂɃob`XVsB<br>
 *</p>
 */
@Component
public class B008001BLogic implements BLogic {

    private Log log = LogFactory.getLog(B008001BLogic.class);

    private static final int BATCH_NORMAL_END = 0;

    private static final String INPUT_FILE = "C:\\tmp\\KEN_ALL.CSV";

    @Autowired
    @Qualifier("csvFileQueryDAO")
    private FileQueryDAO csvFileQueryDAO = null;

    @Autowired
    @Qualifier("updateDAO")
    private UpdateDAO updateDAO = null;

    @Autowired
    @Qualifier("transactionManager")
    private PlatformTransactionManager transactionManager = null;

    public int execute(BLogicParam param) {
        TransactionStatus stat = null;

        // ////////////
        // 
        if (log.isInfoEnabled()) {
            log.info("ZipCodee[u:Jn");
        }

        try {
            // gUNVJn
            stat = BatchUtil.startTransaction(transactionManager);

            // ZipCodee[ȕ
            updateDAO.execute("B008001.deleteZipCode", null);

            // gUNVR~bg
            BatchUtil.commitTransaction(transactionManager, stat);
        } catch (Exception e) {
            throw new BatchException(e);
        } finally {
            // gUNVI
            BatchUtil.endTransaction(transactionManager, stat);
        }

        if (log.isInfoEnabled()) {
            log.info("ZipCodee[u:I");
        }

        Collector<ZipCode> collector = null;
        BatchUpdateSupport bus = new BatchUpdateSupportImpl();

        // ////////////
        // o^
        if (log.isInfoEnabled()) {
            log.info("KEN_ALL.CSVt@Cǂݍ:Jn");
        }

        try {
            int municipalDistrictCnt = 0;
            int townRegionCnt = 0;

            // gUNVJn
            stat = BatchUtil.startTransaction(transactionManager);

            collector = new FileCollector<ZipCode>(csvFileQueryDAO, INPUT_FILE,
                    ZipCode.class);

            while (collector.hasNext()) {
                ZipCode record = collector.next();
                townRegionCnt++;

                // Rg[uCNiwb_j
                boolean preCtrlBreak = ControlBreakChecker.isPreBreak(
                        collector, "adminDivisions", "municipalDistrict");

                // Rg[uCNitb^j
                boolean ctrlBreak = ControlBreakChecker.isBreak(collector,
                        "adminDivisions");

                // Rg[uCNiwb_j
                if (preCtrlBreak) {
                    StringBuilder sb = new StringBuilder();

                    Map<String, Object> pbMap = ControlBreakChecker
                            .getPreBreakKey(collector, "adminDivisions",
                                    "municipalDistrict");

                    // s撬ςɃJEg
                    if (pbMap.containsKey("municipalDistrict")) {
                        municipalDistrictCnt++;
                    }

                    // s{ςɃOɃwb_o͂
                    if (log.isInfoEnabled()
                            && pbMap.containsKey("adminDivisions")) {
                        sb.setLength(0);
                        sb.append(pbMap.get("adminDivisions"));
                        log.info("=========================");
                        log.info(sb.toString());
                    }

                }

                // ob`XVɒǉ
                bus.addBatch("B008001.insertZipCode", record);

                // Rg[uCNitb^j
                if (ctrlBreak) {
                    Map<String, Object> brkMap = ControlBreakChecker
                            .getBreakKey(collector, "adminDivisions");

                    // s{ςɃob`XVs
                    if (brkMap.containsKey("adminDivisions")) {
                        if (log.isInfoEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("ob`XVs ");
                            sb.append(bus.size());
                            sb.append(" ");
                            sb.append("s撬 ");
                            sb.append(municipalDistrictCnt);
                            sb.append(" ");
                            sb.append("搔 ");
                            sb.append(townRegionCnt);
                            sb.append(" ");
                            log.info(sb.toString());
                        }

                        // ob`XVs
                        bus.executeBatch(updateDAO);

                        // JE^Zbg
                        municipalDistrictCnt = 0;
                        townRegionCnt = 0;
                    }
                }
            }

            if (log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("ob`XVs ");
                sb.append(bus.size());
                sb.append("");
                log.info(sb.toString());
            }

            // ob`XVs
            bus.executeBatch(updateDAO);

            // gUNVR~bg
            BatchUtil.commitTransaction(transactionManager, stat);
        } catch (Exception e) {
            throw new BatchException(e);
        } finally {
            // RN^̃N[Y
            CollectorUtility.closeQuietly(collector);

            // gUNVI
            BatchUtil.endTransaction(transactionManager, stat);
        }

        if (log.isInfoEnabled()) {
            log.info("KEN_ALL.CSVt@Cǂݍ:I");
        }

        // I
        return BATCH_NORMAL_END;
    }

}
