/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.FileException;

/**
 * ϒt@Ct@Cp̃t@CANZX(f[^擾)NXB
 * <p>
 * ϒt@Cf[^ǂݍ݁A1s̃f[^t@CsIuWFNg i[B<br>
 * CSVt@Cł͋؂蕶J}ŌŒ肳Ă邪Aϒt@Cł J}ȊO𗘗p邱Ƃ\B
 * </p>
 * <b>pt@CsIuWFNg̃Ame[V</b><br>
 * @D@{@link FileFormat}̐ݒ荀<br>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 * <tr>
 * <td><b>_ږ</b></td>
 * <td><b>ږ</b></td>
 * <td><b>ftHgl</b></td>
 * <td><b>K{</b></td>
 * </tr>
 * <tr>
 * <td> <code>s؂蕶</code></td>
 * <td> <code>lineFeedChar</code></td>
 * <td> <code>VXe̍s؂蕶</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>؂蕶</code></td>
 * <td> <code>delimiter</code></td>
 * <td> <code>','</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>͂ݕ</code></td>
 * <td> <code>encloseChar</code></td>
 * <td> <code>Ȃ('\u0000')</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>t@CGR[fBO</code></td>
 * <td> <code>fileEncodeing</code></td>
 * <td> <code>VXẽt@CGR[fBO</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>wb_s</code></td>
 * <td> <code>headerLineCount</code></td>
 * <td> <code>0</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>gCs</code></td>
 * <td> <code>trailerLineCount</code></td>
 * <td> <code>0</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * </table>
 * </div> <br>
 * AD@{@link jp.terasoluna.fw.file.annotation.InputFileColumn}A@{@link jp.terasoluna.fw.file.annotation.OutputFileColumn}̐ݒ荀<br>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 * <tr>
 * <td><b>_ږ</b></td>
 * <td><b>ږ</b></td>
 * <td><b>ftHgl</b></td>
 * <td><b>K{</b></td>
 * </tr>
 * <tr>
 * <td> <code>JCfbNX</code></td>
 * <td> <code>columnIndex</code></td>
 * <td>-</td>
 * <td> <code>K{</code></td>
 * </tr>
 * <tr>
 * <td> <code>tH[}bg</code></td>
 * <td> <code>columnFormat</code></td>
 * <td> <code>""</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>oCg</code></td>
 * <td> <code>bytes</code></td>
 * <td> <code>-1</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>pfBO</code></td>
 * <td> <code>paddingType</code></td>
 * <td> <code>pfBOȂ</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>pfBO</code></td>
 * <td> <code>paddingChar</code></td>
 * <td> <code>' '</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>g</code></td>
 * <td> <code>trimType</code></td>
 * <td> <code>gȂ</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>g</code></td>
 * <td> <code>trimChar</code></td>
 * <td> <code>' '</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>ϊ</code></td>
 * <td> <code>stringConverter</code></td>
 * <td> <code>NullStringConverter.class</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * </table>
 * </div> <br>
 * <b>ӎ</b><br>
 * <ul>
 * @
 * <li>؂蕶Caracter.MIN_VALUEݒ肷邱Ƃ͏oȂB(G[)</li>
 * </ul>
 * @param <T> t@CsIuWFNg
 */
public class VariableFileLineIterator<T> extends AbstractFileLineIterator<T> {

    /**
     * ؂蕶B
     */
    private char delimiter = ',';

    /**
     * ͂ݕB
     */
    private char encloseChar = Character.MIN_VALUE;

    /**
     * RXgN^B
     * @param fileName t@C
     * @param clazz t@CsIuWFNgNX
     * @param columnParserMap eLXgݒ胋[
     */
    public VariableFileLineIterator(String fileName, Class<T> clazz,
            Map<String, ColumnParser> columnParserMap) {

        super(fileName, clazz, columnParserMap);

        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);

        // ؂蕶Character.MIN_VALUȄꍇAOX[B
        if (fileFormat.delimiter() == Character.MIN_VALUE) {
            throw new FileException("Delimiter can not use '\\u0000'.",
                    new IllegalStateException(), fileName);
        }

        // sɋ؂蕶܂܂ĂꍇAOX[B
        if (fileFormat.lineFeedChar().indexOf(fileFormat.delimiter()) >= 0) {
            throw new FileException(
                    "delimiter is the same as lineFeedChar and is no use.",
                    new IllegalStateException(), fileName);
        }

        // ͂ݕݒ肷B
        this.encloseChar = fileFormat.encloseChar();

        // ؂蕶ݒ肷B
        this.delimiter = fileFormat.delimiter();

        // sB
        super.init();
    }

    /**
     * ǂݍ񂾃t@C̃R[hA؂蕶A ͂ݕɏ] zɕϊB<br>
     * <code>fileLineString</code><code>null</code> 󕶎̏ꍇ́AvfȂ<code>String</code>zԂ܂B
     * @param fileLineString ϒt@C1R[h̕
     * @return z
     */
    protected String[] separateColumns(String fileLineString) {

        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }

        // 1J̕i[镶V[PX
        StringBuilder columnBuilder = new StringBuilder();

        // `FbNΏە̒O̕
        char previousChar = Character.MIN_VALUE;

        // i[邽߂̔z
        List<String> columnList = new ArrayList<String>();

        boolean isEnclosed = true;
        boolean isEscaped = false;

        int fieldCount = 0;
        char[] columnEncloseChar = getColumnEncloseChar();

        if (!isEnclosed()) {
            return fileLineString.split(Character.toString(delimiter), -1);
        } else {
            for (char currentChar : fileLineString.toCharArray()) {
                if (previousChar == Character.MIN_VALUE) {
                    previousChar = currentChar;
                }
                if (previousChar == getEncloseCharcter(columnEncloseChar,
                        fieldCount)) {
                    if (isEnclosed) {
                        if (currentChar == getEncloseCharcter(
                                columnEncloseChar, fieldCount)) {
                            isEnclosed = false;
                        }
                    } else {
                        if (currentChar == getEncloseCharcter(
                                columnEncloseChar, fieldCount)) {
                            if (isEscaped) {
                                columnBuilder.append(currentChar);
                                isEscaped = false;
                            } else {
                                isEscaped = true;
                            }
                        } else if (currentChar == getDelimiter()) {
                            if (isEscaped) {
                                columnList.add(columnBuilder.toString());
                                previousChar = Character.MIN_VALUE;
                                columnBuilder.delete(0, columnBuilder.length());
                                isEnclosed = true;
                                isEscaped = false;
                                fieldCount++;
                            } else {
                                columnBuilder.append(currentChar);
                                isEscaped = false;
                            }
                        } else {
                            columnBuilder.append(currentChar);
                        }
                    }
                } else {
                    if (currentChar != getDelimiter()) {
                        columnBuilder.append(currentChar);
                    } else {
                        columnList.add(columnBuilder.toString());
                        previousChar = Character.MIN_VALUE;
                        columnBuilder.delete(0, columnBuilder.length());
                        fieldCount++;
                    }
                }
            }
            columnList.add(columnBuilder.toString());
            return columnList.toArray(new String[columnList.size()]);
        }
    }

    /**
     * JɑΉ͂ݕ擾B
     * @param index J̃CfbNX
     * @return ͂ݕ
     */
    private char getEncloseCharcter(char[] columnEncloseChar, int index) {
        if (columnEncloseChar.length == 0 || index >= columnEncloseChar.length) {
            return this.encloseChar;
        } else {
            return columnEncloseChar[index];
        }
    }

    /**
     * ؂蕶擾B
     * @return ؂蕶
     */
    @Override
    public char getDelimiter() {

        return delimiter;
    }

    /**
     * ͂ݕ擾B
     * @return ͂ݕ
     */
    @Override
    public char getEncloseChar() {

        return encloseChar;
    }
}
