/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.jndi;

import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import jp.terasoluna.fw.web.jndi.JndiException;
import jp.terasoluna.fw.web.jndi.JndiSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiLocatorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJndiSupport
extends JndiLocatorSupport
implements JndiSupport {
    private static Log log = LogFactory.getLog(DefaultJndiSupport.class);
    private static final String JNDI_FACTORY_KEY = "factory";
    private static final String JNDI_URL_KEY = "url";
    private static final String JNDI_USERNAME_KEY = "username";
    private static final String JNDI_PASSWORD_KEY = "password";
    private Map<String, String> jndiEnvironmentMap = null;

    public void setJndiPrefix(boolean jndiPrefix) {
        super.setResourceRef(jndiPrefix);
    }

    public boolean isJndiPrefix() {
        return super.isResourceRef();
    }

    public Map<String, String> getJndiEnvironmentMap() {
        return this.jndiEnvironmentMap;
    }

    public void setJndiEnvironmentMap(Map<String, String> jndiEnvironmentMap) {
        this.jndiEnvironmentMap = jndiEnvironmentMap;
    }

    public void initialize() {
        if (this.jndiEnvironmentMap != null) {
            String factory = this.jndiEnvironmentMap.get(JNDI_FACTORY_KEY);
            String url = this.jndiEnvironmentMap.get(JNDI_URL_KEY);
            String username = this.jndiEnvironmentMap.get(JNDI_USERNAME_KEY);
            String password = this.jndiEnvironmentMap.get(JNDI_PASSWORD_KEY);
            Properties environment = new Properties();
            environment.put("java.naming.factory.initial", factory);
            environment.put("java.naming.provider.url", url);
            if (!"".equals(username) && username != null) {
                environment.put("java.naming.security.principal", username);
                if (password == null) {
                    password = "";
                }
                environment.put("java.naming.security.credentials", password);
            }
            this.getJndiTemplate().setEnvironment(environment);
            if (log.isInfoEnabled()) {
                log.info((Object)"Initialize Weblogic JNDI Resource");
                log.info((Object)("java.naming.factory.initial = " + factory));
                log.info((Object)("java.naming.provider.url = " + url));
                log.info((Object)("java.naming.security.principal = " + username));
                log.info((Object)("java.naming.security.credentials = " + password));
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) {
        if (name == null || obj == null) {
            log.error((Object)("Illegal arguments error : name=" + name + ", obj=" + obj));
            throw new IllegalArgumentException();
        }
        String jndiNameToUse = this.convertJndiName(name);
        try {
            this.getJndiTemplate().rebind(jndiNameToUse, obj);
        }
        catch (NamingException e) {
            log.error((Object)"Illegal JNDI context name.");
            throw new JndiException(e);
        }
    }

    @Override
    public void unbind(String name) {
        if (name == null) {
            log.error((Object)("Illegal arguments error : name=" + name));
            throw new IllegalArgumentException();
        }
        String jndiNameToUse = this.convertJndiName(name);
        try {
            this.getJndiTemplate().unbind(jndiNameToUse);
        }
        catch (NamingException e) {
            log.error((Object)"Illegal JNDI context name.");
            throw new JndiException(e);
        }
    }

    @Override
    public Object lookup(String name) {
        if (name == null) {
            log.error((Object)("Illegal arguments error : name=" + name));
            throw new IllegalArgumentException();
        }
        String jndiNameToUse = this.convertJndiName(name);
        try {
            return this.getJndiTemplate().lookup(jndiNameToUse);
        }
        catch (NamingException e) {
            log.error((Object)"Illegal JNDI context name.");
            throw new JndiException(e);
        }
    }
}

