/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.annotation.TrimType;
import jp.terasoluna.fw.file.dao.FileException;

public class FileDAOUtility {
    private static final Map<String, Map<Character, Boolean>> encodingCache = new ConcurrentHashMap<String, Map<Character, Boolean>>();

    public static String padding(String columnString, String fileEncoding, int columnBytes, char paddingChar, PaddingType paddingType) {
        if (PaddingType.NONE.equals((Object)paddingType)) {
            return columnString;
        }
        if (!FileDAOUtility.isHalfWidthChar(fileEncoding, paddingChar)) {
            throw new FileException("Padding char is not half-width character.");
        }
        try {
            int paddingSize = columnBytes - columnString.getBytes(fileEncoding).length;
            if (paddingSize <= 0) {
                return columnString;
            }
            StringBuilder columnBuilder = new StringBuilder(columnBytes);
            char[] fillChars = new char[paddingSize];
            Arrays.fill(fillChars, paddingChar);
            if (PaddingType.LEFT.equals((Object)paddingType)) {
                columnBuilder.append(fillChars).append(columnString);
                return columnBuilder.toString();
            }
            if (PaddingType.RIGHT.equals((Object)paddingType)) {
                columnBuilder.append(columnString).append(fillChars);
                return columnBuilder.toString();
            }
            return columnString;
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException("Specified Encoding : " + fileEncoding + " is not supported", e);
        }
    }

    public static String trim(String columnString, String fileEncoding, char trimChar, TrimType trimType) {
        int start;
        if (TrimType.NONE.equals((Object)trimType)) {
            return columnString;
        }
        if (!FileDAOUtility.isHalfWidthChar(fileEncoding, trimChar)) {
            throw new FileException("Trim char is not half-width character.");
        }
        int length = columnString.length();
        if (TrimType.LEFT.equals((Object)trimType) || TrimType.BOTH.equals((Object)trimType)) {
            for (start = 0; start < length && columnString.charAt(start) == trimChar; ++start) {
            }
        }
        if (TrimType.RIGHT.equals((Object)trimType) || TrimType.BOTH.equals((Object)trimType)) {
            while (start < length && columnString.charAt(length - 1) == trimChar) {
                --length;
            }
        }
        return columnString.substring(start, length);
    }

    private static boolean isHalfWidthChar(String fileEncoding, char checkChar) throws FileException {
        Boolean result;
        Map<Character, Boolean> cache = encodingCache.get(fileEncoding);
        if (cache == null) {
            cache = new ConcurrentHashMap<Character, Boolean>();
            encodingCache.put(fileEncoding, cache);
        }
        if ((result = cache.get(Character.valueOf(checkChar))) == null) {
            try {
                result = 1 == Character.toString(checkChar).getBytes(fileEncoding).length;
                cache.put(Character.valueOf(checkChar), result);
            }
            catch (UnsupportedEncodingException e) {
                throw new FileException("Specified Encoding : " + fileEncoding + " is not supported", e);
            }
        }
        return result;
    }
}

