/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;
import jp.terasoluna.fw.file.dao.standard.DecimalFormatLocal;

public class DecimalColumnParser
implements ColumnParser {
    private Map<String, DecimalFormatLocal> dfMap = new ConcurrentHashMap<String, DecimalFormatLocal>();

    public void parse(String column, Object t, Method method, String columnFormat) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ParseException {
        if (columnFormat != null && !"".equals(columnFormat)) {
            DecimalFormatLocal dfLocal = this.dfMap.get(columnFormat);
            if (dfLocal == null) {
                dfLocal = new DecimalFormatLocal(columnFormat);
                this.dfMap.put(columnFormat, dfLocal);
            }
            DecimalFormat decimalFormat = (DecimalFormat)dfLocal.get();
            decimalFormat.setParseBigDecimal(true);
            method.invoke(t, decimalFormat.parse(column));
        } else {
            method.invoke(t, new BigDecimal(column));
        }
    }
}

